/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Sets;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.spi.MetadataProvider;
import org.kitesdk.data.spi.filesystem.FileSystemMetadataProvider;

public class TestFileSystemMetadataProviderBackwardCompatibility {
    private static final Path root = new Path("file:/tmp/tests/mixed-repository");
    private static final Configuration conf = new Configuration();
    private static final DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"int\"").build();
    private static FileSystem local;
    private static MetadataProvider provider;

    @BeforeClass
    public static void createMixedLayoutRepository() throws IOException {
        local = FileSystem.get((Configuration)conf);
        local.delete(root, true);
        TestFileSystemMetadataProviderBackwardCompatibility.createMetadata(local, new Path(root, new Path("old_1", ".metadata")), "old_1");
        TestFileSystemMetadataProviderBackwardCompatibility.createMetadata(local, new Path(root, new Path("old_2", ".metadata")), "old_2");
        provider = new FileSystemMetadataProvider(conf, root);
        provider.create("ns", "new_1", descriptor);
        provider.create("ns2", "new_2", descriptor);
    }

    public static void createMetadata(FileSystem fs, Path path, String name) throws IOException {
        fs.mkdirs(path);
        FileSystemMetadataProvider.writeDescriptor((FileSystem)fs, (Path)path, (String)name, (DatasetDescriptor)descriptor);
    }

    @Test
    public void testNamespaces() {
        Assert.assertEquals((String)"Should report default namespace for old datasets", (Object)Sets.newHashSet((Object[])new String[]{"default", "ns", "ns2"}), (Object)Sets.newHashSet((Iterable)provider.namespaces()));
    }

    @Test
    public void testNamespacesWithOverlap() {
        provider.create("old_1", "new_3", descriptor);
        Assert.assertEquals((String)"Should report default namespace for old datasets", (Object)Sets.newHashSet((Object[])new String[]{"old_1", "default", "ns", "ns2"}), (Object)Sets.newHashSet((Iterable)provider.namespaces()));
        provider.delete("old_1", "new_3");
    }

    @Test
    public void testDatasets() throws IOException {
        Assert.assertEquals((String)"Should report old datasets in default namespace", (Object)Sets.newHashSet((Object[])new String[]{"old_1", "old_2"}), (Object)Sets.newHashSet((Iterable)provider.datasets("default")));
        provider.create("default", "new_3", descriptor);
        Assert.assertEquals((String)"Should merge old datasets into default namespace", (Object)Sets.newHashSet((Object[])new String[]{"old_1", "old_2", "new_3"}), (Object)Sets.newHashSet((Iterable)provider.datasets("default")));
        provider.delete("default", "new_3");
    }

    @Test
    public void testDatasetsWithOverlap() {
        provider.create("old_1", "new_3", descriptor);
        Assert.assertEquals((String)"Should report old datasets in default namespace", (Object)Sets.newHashSet((Object[])new String[]{"old_1", "old_2"}), (Object)Sets.newHashSet((Iterable)provider.datasets("default")));
        Assert.assertEquals((String)"Should merge old datasets into default namespace", (Object)Sets.newHashSet((Object[])new String[]{"new_3"}), (Object)Sets.newHashSet((Iterable)provider.datasets("old_1")));
        provider.delete("old_1", "new_3");
    }

    @Test
    public void testLoad() {
        DatasetDescriptor loaded = provider.load("default", "old_1");
        Assert.assertNotNull((String)"Should find old layout datasets", (Object)loaded);
    }

    @Test
    public void testExists() {
        Assert.assertTrue((String)"Should find old layout datasets", (boolean)provider.exists("default", "old_1"));
    }

    @Test
    public void testUpdate() throws IOException {
        DatasetDescriptor updated = new DatasetDescriptor.Builder(descriptor).property("parquet.block.size", "1024").build();
        DatasetDescriptor saved = provider.update("default", "old_2", updated);
        Assert.assertNotNull((String)"Should find saved metadata", (Object)saved);
        Assert.assertEquals((String)"Should update old dataset successfully", (Object)updated.getProperty("parquet.block.size"), (Object)saved.getProperty("parquet.block.size"));
        DatasetDescriptor loaded = provider.load("default", "old_2");
        Assert.assertNotNull((String)"Should find saved metadata", (Object)loaded);
        Assert.assertEquals((String)"Should make changes on disk", (Object)updated.getProperty("parquet.block.size"), (Object)loaded.getProperty("parquet.block.size"));
        Assert.assertFalse((String)"Should not move metadata to new location", (boolean)local.exists(new Path(root, new Path("default", "old_2"))));
    }

    static {
        provider = null;
    }
}

