/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.io.Files;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.spi.MetadataProvider;
import org.kitesdk.data.spi.TestMetadataProviders;
import org.kitesdk.data.spi.filesystem.FileSystemMetadataProvider;

public class TestFileSystemMetadataProvider
extends TestMetadataProviders {
    private FileSystem fileSystem;
    private Path testDirectory;

    public TestFileSystemMetadataProvider(boolean distributed) {
        super(distributed);
    }

    @Override
    public MetadataProvider newProvider(Configuration conf) {
        this.testDirectory = new Path(Files.createTempDir().getAbsolutePath());
        return new FileSystemMetadataProvider(conf, this.testDirectory);
    }

    @Before
    public void before() throws IOException {
        this.fileSystem = FileSystem.get((Configuration)this.conf);
    }

    @After
    public void tearDown() throws IOException {
        this.fileSystem.delete(this.testDirectory, true);
        this.testDirectory = null;
    }

    @Test
    public void testLoadSetsLocation() throws IOException {
        this.ensureCreated();
        DatasetDescriptor loaded = this.provider.load("ns1", "provider_test1");
        Assert.assertNotNull((String)"Loaded descriptor should have a location", (Object)loaded.getLocation());
        if (this.distributed) {
            Assert.assertEquals((Object)TestFileSystemMetadataProvider.getDFS(), (Object)FileSystem.get((URI)loaded.getLocation(), (Configuration)new Configuration()));
            Assert.assertEquals((Object)"hdfs", (Object)loaded.getLocation().getScheme());
            Assert.assertEquals((Object)TestFileSystemMetadataProvider.getDFS().getUri().getAuthority(), (Object)loaded.getLocation().getAuthority());
        } else {
            Assert.assertEquals((Object)TestFileSystemMetadataProvider.getFS(), (Object)FileSystem.get((URI)loaded.getLocation(), (Configuration)new Configuration()));
            Assert.assertEquals((Object)"file", (Object)loaded.getLocation().getScheme());
            Assert.assertEquals((Object)TestFileSystemMetadataProvider.getFS().getUri().getAuthority(), (Object)loaded.getLocation().getAuthority());
        }
    }

    @Test
    public void testCreateIgnoresLocation() throws IOException {
        DatasetDescriptor created = this.provider.create("ns1", "provider_test1", this.testDescriptor);
        Assert.assertNull((String)"Created descriptor should not have a location", (Object)created.getLocation());
    }

    @Test
    public void testCreateMetadataFiles() throws IOException {
        this.ensureCreated();
        Path namedDirectory = new Path(this.testDirectory, new Path("ns1", "provider_test1"));
        Path metadataDirectory = new Path(namedDirectory, ".metadata");
        Path propertiesFile = new Path(metadataDirectory, "descriptor.properties");
        Path schemaDirectory = new Path(metadataDirectory, "schemas");
        Assert.assertTrue((String)"Named directory should exist for name:provider_test1", (boolean)this.fileSystem.exists(namedDirectory));
        Assert.assertTrue((String)"Metadata directory should exist", (boolean)this.fileSystem.exists(metadataDirectory));
        Assert.assertTrue((String)"Descriptor properties file should exist", (boolean)this.fileSystem.exists(propertiesFile));
        Assert.assertTrue((String)"Descriptor schema directory should exist", (boolean)this.fileSystem.exists(schemaDirectory));
    }

    @Test
    public void testDeleteRemovesMetadataFiles() throws IOException {
        this.testCreateMetadataFiles();
        DatasetDescriptor loaded = this.provider.load("ns1", "provider_test1");
        Path namedDirectory = new Path(loaded.getLocation());
        Path metadataDirectory = new Path(namedDirectory, ".metadata");
        Path propertiesFile = new Path(metadataDirectory, "descriptor.properties");
        Path schemaDirectory = new Path(metadataDirectory, "schemas");
        boolean result = this.provider.delete("ns1", "provider_test1");
        Assert.assertTrue((boolean)result);
        Assert.assertFalse((String)"Descriptor properties file should not exist", (boolean)this.fileSystem.exists(propertiesFile));
        Assert.assertFalse((String)"Descriptor schema directory should not exist", (boolean)this.fileSystem.exists(schemaDirectory));
        Assert.assertFalse((String)"Metadata directory should not exist", (boolean)this.fileSystem.exists(metadataDirectory));
        Assert.assertTrue((String)"Named directory should still exist for name:provider_test1", (boolean)this.fileSystem.exists(namedDirectory));
    }

    private void useOldRepositoryFormat() throws IOException {
        this.testCreateMetadataFiles();
        DatasetDescriptor placeholder = this.provider.load("ns1", "provider_test1");
        Path namedDirectory = new Path(placeholder.getLocation());
        Path metadataDirectory = new Path(namedDirectory, ".metadata");
        Path propertiesFile = new Path(metadataDirectory, "descriptor.properties");
        Path schemaDirectory = new Path(metadataDirectory, "schemas");
        Path oldSchemaLocation = new Path(metadataDirectory, "schema.avsc");
        this.fileSystem.delete(schemaDirectory, true);
        Assert.assertTrue((String)"Named directory should exist for name:provider_test1", (boolean)this.fileSystem.exists(namedDirectory));
        Assert.assertTrue((String)"Metadata directory should exist", (boolean)this.fileSystem.exists(metadataDirectory));
        Assert.assertTrue((String)"Descriptor properties file should exist", (boolean)this.fileSystem.exists(propertiesFile));
        Assert.assertTrue((String)"Old schema location should exist.", (boolean)this.fileSystem.exists(oldSchemaLocation));
    }

    @Test
    public void testUsePreviousFormat() throws IOException {
        this.useOldRepositoryFormat();
        DatasetDescriptor oldFormatDescriptor = this.provider.load("ns1", "provider_test1");
        Assert.assertEquals((Object)this.testDescriptor.getSchema(), (Object)oldFormatDescriptor.getSchema());
    }

    @Test
    public void testUpdatePreviousFormat() throws IOException {
        this.useOldRepositoryFormat();
        DatasetDescriptor oldFormatDescriptor = this.provider.load("ns1", "provider_test1");
        Path namedDirectory = new Path(oldFormatDescriptor.getLocation());
        Path metadataDirectory = new Path(namedDirectory, ".metadata");
        Path schemaDirectory = new Path(metadataDirectory, "schemas");
        Path newSchemaLocation = new Path(schemaDirectory, "1.avsc");
        DatasetDescriptor updated = new DatasetDescriptor.Builder(oldFormatDescriptor).build();
        this.provider.update("ns1", "provider_test1", updated);
        Assert.assertEquals((Object)this.testDescriptor.getSchema(), (Object)oldFormatDescriptor.getSchema());
        Assert.assertTrue((String)"Schema should exist at the new location.", (boolean)this.fileSystem.exists(newSchemaLocation));
    }
}

