/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.AbstractRefinableView;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemDatasets;

public class TestFileSystemDatasets {
    private static final Schema schema = (Schema)SchemaBuilder.record((String)"Event").fields().requiredString("id").requiredLong("timestamp").requiredString("color").endRecord();
    private static PartitionStrategy ymd = new PartitionStrategy.Builder().year("timestamp", "y").month("timestamp", "m").day("timestamp", "d").build();
    private FileSystemDataset<GenericRecord> dataset;

    @Before
    public void createFileSystemDataset() {
        String uri = "dataset:file:/tmp/datasets/ns/test";
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(schema).partitionStrategy(ymd).build();
        Datasets.delete((String)uri);
        this.dataset = (FileSystemDataset)Datasets.create((String)uri, (DatasetDescriptor)descriptor);
    }

    @Test
    public void testViewForUri() {
        Path path = new Path("/tmp/datasets/ns/test/y=2014/m=03/d=14");
        View view = FileSystemDatasets.viewForUri(this.dataset, (String)("file:" + path));
        Assert.assertEquals((String)"Should create correct view", (Object)view, (Object)this.dataset.getPartitionView(path));
        view = FileSystemDatasets.viewForUri(this.dataset, (String)path.toString());
        Assert.assertEquals((String)"Should create correct view", (Object)view, (Object)this.dataset.getPartitionView(path));
        Constraints expected = ((AbstractRefinableView)this.dataset.with("y", new Object[]{2014}).with("m", new Object[]{3}).with("d", new Object[]{14})).getConstraints();
        Constraints actual = ((AbstractRefinableView)view).getConstraints();
        Assert.assertEquals((String)"Constraints should match expected", (Object)expected, (Object)actual);
    }

    @Test
    public void testViewForIncompleteUri() {
        Path path = new Path("/tmp/datasets/ns/test/y=2014/m=03");
        View view = FileSystemDatasets.viewForUri(this.dataset, (String)path.toString());
        Assert.assertEquals((String)"Should create correct view", (Object)view, (Object)this.dataset.getPartitionView(path));
        Constraints expected = ((AbstractRefinableView)this.dataset.with("y", new Object[]{2014}).with("m", new Object[]{3})).getConstraints();
        Constraints actual = ((AbstractRefinableView)view).getConstraints();
        Assert.assertEquals((String)"Constraints should match expected", (Object)expected, (Object)actual);
    }

    @Test
    public void testIgnoresAuthority() {
        Path path = new Path("/tmp/datasets/ns/test/y=2014/m=03/d=14");
        View view = FileSystemDatasets.viewForUri(this.dataset, (String)"file://127.0.0.1/tmp/datasets/ns/test/y=2014/m=03/d=14");
        Assert.assertEquals((String)"Should create correct view", (Object)view, (Object)this.dataset.getPartitionView(path));
        Constraints expected = ((AbstractRefinableView)this.dataset.with("y", new Object[]{2014}).with("m", new Object[]{3}).with("d", new Object[]{14})).getConstraints();
        Constraints actual = ((AbstractRefinableView)view).getConstraints();
        Assert.assertEquals((String)"Constraints should match expected", (Object)expected, (Object)actual);
    }

    @Test
    public void testViewForRelativeUri() {
        Path path = new Path("/tmp/datasets/ns/test/y=2014/m=03/d=14");
        View view = FileSystemDatasets.viewForUri(this.dataset, (String)"y=2014/m=03/d=14");
        Assert.assertEquals((String)"Should create correct view", (Object)view, (Object)this.dataset.getPartitionView(path));
        Constraints expected = ((AbstractRefinableView)this.dataset.with("y", new Object[]{2014}).with("m", new Object[]{3}).with("d", new Object[]{14})).getConstraints();
        Constraints actual = ((AbstractRefinableView)view).getConstraints();
        Assert.assertEquals((String)"Constraints should match expected", (Object)expected, (Object)actual);
    }

    @Test
    public void testViewForMissingPartitionNames() {
        Path path = new Path("2014/3/14");
        View view = FileSystemDatasets.viewForUri(this.dataset, (String)path.toString());
        Assert.assertEquals((String)"Should create correct view", (Object)view, (Object)this.dataset.getPartitionView(path));
        Constraints expected = ((AbstractRefinableView)this.dataset.with("y", new Object[]{2014}).with("m", new Object[]{3}).with("d", new Object[]{14})).getConstraints();
        Constraints actual = ((AbstractRefinableView)view).getConstraints();
        Assert.assertEquals((String)"Constraints should match expected", (Object)expected, (Object)actual);
    }

    @Test
    public void testViewForDifferentPartitionNames() {
        Path path = new Path("year=2014/month=3/day=14");
        View view = FileSystemDatasets.viewForUri(this.dataset, (String)path.toString());
        Assert.assertEquals((String)"Should create correct view", (Object)view, (Object)this.dataset.getPartitionView(path));
        Constraints expected = ((AbstractRefinableView)this.dataset.with("y", new Object[]{2014}).with("m", new Object[]{3}).with("d", new Object[]{14})).getConstraints();
        Constraints actual = ((AbstractRefinableView)view).getConstraints();
        Assert.assertEquals((String)"Constraints should match expected", (Object)expected, (Object)actual);
    }

    @Test
    public void testNoConstraints() {
        View view = FileSystemDatasets.viewForUri(this.dataset, (String)"file:/tmp/datasets/ns/test/");
        Assert.assertEquals((String)"Should create correct view", (Object)view, this.dataset);
    }

    @Test
    public void testDatasetNotPartitioned() {
        Datasets.delete((String)"dataset:file:/tmp/datasets/ns/test");
        final Dataset ds = (Dataset)Datasets.create((String)"dataset:file:/tmp/datasets/ns/test", (DatasetDescriptor)new DatasetDescriptor.Builder().schema(schema).build());
        Assert.assertEquals((String)"Should work for empty relative directory", (Object)ds, (Object)FileSystemDatasets.viewForUri((Dataset)ds, (String)"file:/tmp/datasets/ns/test"));
        TestHelpers.assertThrows("Should reject paths in a non-partitioned dataset", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                FileSystemDatasets.viewForUri((Dataset)ds, (String)"y=2014/m=03/d=14");
            }
        });
    }

    @Test
    public void testNotContained() {
        TestHelpers.assertThrows("Should reject paths not in the dataset", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                FileSystemDatasets.viewForUri((Dataset)TestFileSystemDatasets.this.dataset, (String)"file:/tmp/datasets/ns/test2/y=2014/m=03/d=14");
            }
        });
    }

    @Test
    public void testOtherFileSystemRejected() {
        TestHelpers.assertThrows("Should reject paths not in the dataset", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                FileSystemDatasets.viewForUri((Dataset)TestFileSystemDatasets.this.dataset, (String)"hdfs:/tmp/datasets/ns/test/y=2014/m=03/d=14");
            }
        });
    }
}

