/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Formats;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestDatasetRepositories;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.MetadataProvider;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;

public class TestFileSystemDatasetRepository
extends TestDatasetRepositories {
    public TestFileSystemDatasetRepository(boolean distributed) {
        super(distributed);
    }

    @Override
    public DatasetRepository newRepo(MetadataProvider provider) {
        return new FileSystemDatasetRepository(new Configuration(), this.testDirectory, provider);
    }

    @Test
    public void testCreatePath() throws IOException {
        Dataset created = this.repo.create("ns1", "test1", this.testDescriptor);
        URI location = created.getDescriptor().getLocation();
        Assert.assertNotNull((String)"FileSystemDatasetRepository should return descriptor locations", (Object)location);
        Assert.assertTrue((String)("Dataset data directory:" + location + " should exist"), (boolean)this.fileSystem.exists(new Path(location)));
    }

    @Test
    public void testLoadNewHasZeroSize() {
        this.ensureCreated();
        Dataset dataset = this.repo.load("ns1", "test1");
        Assert.assertEquals((long)0L, (long)DatasetTestUtilities.datasetSize(dataset));
    }

    @Test
    public void testUpdateFailsWithFormatChange() {
        Dataset dataset = this.repo.create("ns1", "test1", new DatasetDescriptor.Builder(this.testDescriptor).format(Formats.AVRO).build());
        DatasetDescriptor changed = new DatasetDescriptor.Builder(dataset.getDescriptor()).format(Formats.PARQUET).build();
        try {
            this.repo.update("ns1", "test1", changed);
            Assert.fail((String)"Should fail due to format change");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)Formats.AVRO, (Object)this.repo.load("ns1", "test1").getDescriptor().getFormat());
    }

    @Test
    public void testUpdateFailsWithPartitionStrategyChange() {
        PartitionStrategy ps1 = new PartitionStrategy.Builder().hash("username", 2).build();
        PartitionStrategy ps2 = new PartitionStrategy.Builder().hash("username", 2).hash("email", 3).build();
        Dataset dataset = this.repo.create("ns1", "test1", new DatasetDescriptor.Builder(this.testDescriptor).partitionStrategy(ps1).build());
        DatasetDescriptor changed = new DatasetDescriptor.Builder(dataset.getDescriptor()).partitionStrategy(ps2).build();
        try {
            this.repo.update("ns1", "test1", changed);
            Assert.fail((String)"Should fail due to partition strategy change");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)ps1, (Object)this.repo.load("ns1", "test1").getDescriptor().getPartitionStrategy());
    }

    @Test
    public void testUpdateFailsWithLocationChange() {
        this.ensureCreated();
        Dataset dataset = this.repo.load("ns1", "test1");
        URI location = dataset.getDescriptor().getLocation();
        DatasetDescriptor changed = new DatasetDescriptor.Builder(dataset.getDescriptor()).location(new Path(this.testDirectory, "newDataLocation").toUri()).build();
        try {
            this.repo.update("ns1", "test1", changed);
            Assert.fail((String)"Should fail due to data location change");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)location, (Object)this.repo.load("ns1", "test1").getDescriptor().getLocation());
    }

    @Test
    public void testUpdateFailsWithIncompatibleSchemaChange() {
        Dataset dataset = this.repo.create("ns1", "test1", new DatasetDescriptor.Builder().schema(this.testSchema).build());
        Assert.assertEquals((String)"Dataset name is propagated", (Object)"test1", (Object)dataset.getName());
        Assert.assertEquals((String)"Dataset schema is propagated", (Object)this.testSchema, (Object)dataset.getDescriptor().getSchema());
        Schema testSchemaV2 = (Schema)SchemaBuilder.record((String)"user").fields().requiredString("username").requiredString("email").requiredString("favoriteColor").endRecord();
        try {
            this.repo.update("ns1", "test1", new DatasetDescriptor.Builder(dataset.getDescriptor()).schema(testSchemaV2).build());
            Assert.fail((String)"Should fail due to incompatible update");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        dataset = this.repo.load("ns1", "test1");
        Assert.assertEquals((String)"Dataset schema is unchanged", (Object)this.testSchema, (Object)dataset.getDescriptor().getSchema());
    }

    @Test
    public void testUpdateSuccessfulWithCompatibleSchemaChangeFieldAdded() {
        Dataset dataset = this.repo.create("ns1", "test1", new DatasetDescriptor.Builder().schema(this.testSchema).build());
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)dataset, 5, 0, "email");
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)dataset, 5, "email");
        Schema testSchemaV2 = (Schema)SchemaBuilder.record((String)"user").fields().requiredString("username").requiredString("email").nullableString("favoriteColor", "orange").endRecord();
        Dataset datasetV2 = this.repo.update("ns1", "test1", new DatasetDescriptor.Builder(dataset.getDescriptor()).schema(testSchemaV2).build());
        Assert.assertEquals((String)"Dataset schema is updated", (Object)testSchemaV2, (Object)datasetV2.getDescriptor().getSchema());
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)datasetV2, 5, "email", "favoriteColor");
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)datasetV2, 5, 5, "email", "favoriteColor");
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)datasetV2, 10, "email", "favoriteColor");
    }

    @Test
    public void testUpdateSuccessfulWithCompatibleSchemaChangeFieldRemoved() {
        Dataset dataset = this.repo.create("ns1", "test1", new DatasetDescriptor.Builder().schema(this.testSchema).build());
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)dataset, 5, 0, "email");
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)dataset, 5, "email");
        Schema testSchemaV2 = (Schema)SchemaBuilder.record((String)"user").fields().requiredString("username").endRecord();
        Dataset datasetV2 = this.repo.update("ns1", "test1", new DatasetDescriptor.Builder(dataset.getDescriptor()).schema(testSchemaV2).build());
        Assert.assertEquals((String)"Dataset schema is updated", (Object)testSchemaV2, (Object)datasetV2.getDescriptor().getSchema());
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)datasetV2, 5, new String[0]);
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)datasetV2, 5, 5, new String[0]);
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)datasetV2, 10, new String[0]);
    }

    @Test
    public void testDeleteRemovesDatasetPath() throws IOException {
        this.ensureCreated();
        Dataset dataset = this.repo.load("ns1", "test1");
        Path dataPath = new Path(dataset.getDescriptor().getLocation());
        Assert.assertTrue((boolean)this.fileSystem.exists(dataPath));
        this.repo.delete("ns1", "test1");
        Assert.assertFalse((boolean)this.fileSystem.exists(dataPath));
    }

    @Test
    public void testCreateWithAllowNullSchema() {
        String name = "allowNull";
        try {
            this.repo.create("ns1", name, new DatasetDescriptor.Builder().schema(ReflectData.AllowNull.get().getSchema(ObjectPoJo.class)).build());
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.repo.delete("ns1", name);
        }
    }

    @Test
    public void testReadNullsWithPrimitivesAllowNullSchema() {
        String name = "allowNullPrimitives";
        try {
            this.repo.create("ns1", "allowNullPrimitives", new DatasetDescriptor.Builder().schema(ReflectData.AllowNull.get().getSchema(ObjectPoJo.class)).build(), ObjectPoJo.class);
            final Dataset dataset = this.repo.load("ns1", "allowNullPrimitives", PrimitivePoJo.class);
            TestHelpers.assertThrows("AllowNull primitives cannot read nullable type", IncompatibleSchemaException.class, new Runnable(){

                @Override
                public void run() {
                    dataset.newReader();
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.repo.delete("ns1", "allowNullPrimitives");
        }
    }

    @Test
    public void testReplaceProvidedPartition() {
        Schema event = (Schema)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"Event").fields().requiredLong("created_at").requiredLong("version").name("properties").type().optional().map().values().stringType()).endRecord();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(event).partitionStrategy(new PartitionStrategy.Builder().provided("v", "int").year("created_at").month("created_at").day("created_at").build()).build();
        Dataset ds = this.repo.create("ns", "test", descriptor);
        DatasetDescriptor update = new DatasetDescriptor.Builder(ds.getDescriptor()).partitionStrategy(new PartitionStrategy.Builder().identity("version", "v").year("created_at").month("created_at").day("created_at").build()).build();
        this.repo.update("ns", "test", update);
    }

    private static class PrimitivePoJo {
        private long id;
        private String name;
        private Date birthDate;

        private PrimitivePoJo() {
        }
    }

    private static class ObjectPoJo {
        private Long id;
        private String name;
        private Date birthDate;

        public ObjectPoJo(Long id, String name, Date birthDate) {
            this.id = id;
            this.name = name;
            this.birthDate = birthDate;
        }
    }
}

