/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.io.Files;
import java.io.IOException;
import java.net.URI;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.PartitionKey;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;

public class TestFileSystemDatasetPartitionKeyForPath {
    private FileSystem fileSystem;
    private Path testDirectory;
    private PartitionStrategy partitionStrategy;
    private FileSystemDataset<GenericData.Record> dataset;

    @Before
    public void setUp() throws IOException {
        this.fileSystem = FileSystem.get((Configuration)new Configuration());
        this.testDirectory = this.fileSystem.makeQualified(new Path(Files.createTempDir().getAbsolutePath()));
        this.partitionStrategy = new PartitionStrategy.Builder().hash("username", "username_part", 2).hash("email", 3).build();
        this.dataset = new FileSystemDataset.Builder().namespace("ns").name("partitioned-users").configuration(new Configuration()).uri(URI.create("test")).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).location(this.testDirectory).partitionStrategy(this.partitionStrategy).build()).type(GenericData.Record.class).build();
    }

    @After
    public void tearDown() throws IOException {
        this.fileSystem.delete(this.testDirectory, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDifferentFileSystem() throws Exception {
        FileSystemDatasetRepository.partitionKeyForPath(this.dataset, (URI)new URI("hdfs://namenode/"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDifferentRootDirectory() throws Exception {
        FileSystemDatasetRepository.partitionKeyForPath(this.dataset, (URI)new Path(this.testDirectory.getParent(), "bogus").toUri());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonExistentPartitionDirectory() throws Exception {
        FileSystemDatasetRepository.partitionKeyForPath(this.dataset, (URI)new Path(this.testDirectory, "not_a_partition").toUri());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTooManyPartitionDirectories() throws Exception {
        FileSystemDatasetRepository.partitionKeyForPath(this.dataset, (URI)new Path(this.testDirectory, "username_part=1/email=2/extra=3").toUri());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidPartitionName() throws Exception {
        FileSystemDatasetRepository.partitionKeyForPath(this.dataset, (URI)new Path(this.testDirectory, "not_a_partition=1").toUri());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingPartitionValue() throws Exception {
        FileSystemDatasetRepository.partitionKeyForPath(this.dataset, (URI)new Path(this.testDirectory, "username_part").toUri());
    }

    @Test
    public void testValidPartition() throws Exception {
        PartitionKey key = FileSystemDatasetRepository.partitionKeyForPath(this.dataset, (URI)new Path(this.testDirectory, "username_part=1").toUri());
        Assert.assertEquals((Object)new PartitionKey(new Object[]{1}), (Object)key);
    }
}

