/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.Signalable;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.View;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.PartitionKey;
import org.kitesdk.data.spi.PartitionedDataset;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestFileSystemDataset
extends MiniDFSTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileSystemDataset.class);
    private final Format format;
    private final FileSystem fileSystem;
    private final CompressionType compressionType;
    private Path testDirectory;

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws IOException {
        MiniDFSTest.setupFS();
        Object[][] data = new Object[][]{{Formats.AVRO, TestFileSystemDataset.getDFS(), CompressionType.Uncompressed}, {Formats.AVRO, TestFileSystemDataset.getDFS(), CompressionType.Snappy}, {Formats.AVRO, TestFileSystemDataset.getDFS(), CompressionType.Deflate}, {Formats.AVRO, TestFileSystemDataset.getDFS(), CompressionType.Bzip2}, {Formats.AVRO, TestFileSystemDataset.getFS(), CompressionType.Uncompressed}, {Formats.AVRO, TestFileSystemDataset.getFS(), CompressionType.Snappy}, {Formats.AVRO, TestFileSystemDataset.getFS(), CompressionType.Deflate}, {Formats.AVRO, TestFileSystemDataset.getFS(), CompressionType.Bzip2}, {Formats.PARQUET, TestFileSystemDataset.getDFS(), CompressionType.Uncompressed}, {Formats.PARQUET, TestFileSystemDataset.getDFS(), CompressionType.Snappy}, {Formats.PARQUET, TestFileSystemDataset.getDFS(), CompressionType.Deflate}, {Formats.PARQUET, TestFileSystemDataset.getFS(), CompressionType.Uncompressed}, {Formats.PARQUET, TestFileSystemDataset.getFS(), CompressionType.Snappy}, {Formats.PARQUET, TestFileSystemDataset.getFS(), CompressionType.Deflate}};
        return Arrays.asList(data);
    }

    public TestFileSystemDataset(Format format, FileSystem fs, CompressionType compressionType) {
        this.format = format;
        this.fileSystem = fs;
        this.compressionType = compressionType;
    }

    @Before
    public void setUp() throws IOException {
        this.testDirectory = this.fileSystem.makeQualified(new Path(Files.createTempDir().getAbsolutePath()));
    }

    @After
    public void tearDown() throws IOException {
        this.fileSystem.delete(this.testDirectory, true);
    }

    @Test
    public void testWriteAndRead() throws IOException {
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("test").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schemaUri(DatasetTestUtilities.USER_SCHEMA_URL).format(this.format).compressionType(this.compressionType).location(this.testDirectory).build()).type(GenericData.Record.class).build();
        Assert.assertFalse((String)"Dataset is not partitioned", (boolean)ds.getDescriptor().isPartitioned());
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)ds, 10);
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)ds, 10);
    }

    @Test
    public void testPartitionedWriterSingle() throws IOException {
        PartitionStrategy partitionStrategy = new PartitionStrategy.Builder().hash("username", 2).build();
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("partitioned-users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).compressionType(this.compressionType).location(this.testDirectory).partitionStrategy(partitionStrategy).build()).type(GenericData.Record.class).build();
        Assert.assertTrue((String)"Dataset is partitioned", (boolean)ds.getDescriptor().isPartitioned());
        Assert.assertEquals((Object)partitionStrategy, (Object)ds.getDescriptor().getPartitionStrategy());
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)ds, 10);
        Assert.assertTrue((String)"Partitioned directory 0 exists", (boolean)this.fileSystem.exists(new Path(this.testDirectory, "username_hash=0")));
        Assert.assertTrue((String)"Partitioned directory 1 exists", (boolean)this.fileSystem.exists(new Path(this.testDirectory, "username_hash=1")));
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)ds, 10);
        PartitionKey key0 = new PartitionKey(new Object[]{0});
        PartitionKey key1 = new PartitionKey(new Object[]{1});
        int total = this.readTestUsersInPartition((FileSystemDataset<GenericData.Record>)ds, key0, null) + this.readTestUsersInPartition((FileSystemDataset<GenericData.Record>)ds, key1, null);
        Assert.assertEquals((long)10L, (long)total);
        DatasetTestUtilities.testPartitionKeysAreEqual(ds, new PartitionKey[]{key0, key1});
        HashSet records = Sets.newHashSet();
        for (Dataset dataset : ds.getPartitions()) {
            Assert.assertFalse((String)"Partitions should not have further partitions", (boolean)dataset.getDescriptor().isPartitioned());
            records.addAll(DatasetTestUtilities.materialize(ds));
        }
        DatasetTestUtilities.checkTestUsers(records, 10);
    }

    @Test
    public void testPartitionedWriterSingleNullableField() throws IOException {
        PartitionStrategy partitionStrategy = new PartitionStrategy.Builder().hash("username", 2).build();
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("partitioned-users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_NULLABLE_SCHEMA).format(this.format).compressionType(this.compressionType).location(this.testDirectory).partitionStrategy(partitionStrategy).build()).type(GenericData.Record.class).build();
        Assert.assertTrue((String)"Dataset is partitioned", (boolean)ds.getDescriptor().isPartitioned());
        Assert.assertEquals((Object)partitionStrategy, (Object)ds.getDescriptor().getPartitionStrategy());
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)ds, 10);
        Assert.assertTrue((String)"Partitioned directory 0 exists", (boolean)this.fileSystem.exists(new Path(this.testDirectory, "username_hash=0")));
        Assert.assertTrue((String)"Partitioned directory 1 exists", (boolean)this.fileSystem.exists(new Path(this.testDirectory, "username_hash=1")));
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)ds, 10);
        PartitionKey key0 = new PartitionKey(new Object[]{0});
        PartitionKey key1 = new PartitionKey(new Object[]{1});
        int total = this.readTestUsersInPartition((FileSystemDataset<GenericData.Record>)ds, key0, null) + this.readTestUsersInPartition((FileSystemDataset<GenericData.Record>)ds, key1, null);
        Assert.assertEquals((long)10L, (long)total);
        DatasetTestUtilities.testPartitionKeysAreEqual(ds, new PartitionKey[]{key0, key1});
        HashSet records = Sets.newHashSet();
        for (Dataset dataset : ds.getPartitions()) {
            Assert.assertFalse((String)"Partitions should not have further partitions", (boolean)dataset.getDescriptor().isPartitioned());
            records.addAll(DatasetTestUtilities.materialize(ds));
        }
        DatasetTestUtilities.checkTestUsers(records, 10);
    }

    @Test
    public void testPartitionedWriterDouble() throws IOException {
        PartitionStrategy partitionStrategy = new PartitionStrategy.Builder().hash("username", 2).hash("email", 3).build();
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("partitioned-users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).compressionType(this.compressionType).location(this.testDirectory).partitionStrategy(partitionStrategy).build()).type(GenericData.Record.class).build();
        Assert.assertTrue((String)"Dataset is partitioned", (boolean)ds.getDescriptor().isPartitioned());
        Assert.assertEquals((Object)partitionStrategy, (Object)ds.getDescriptor().getPartitionStrategy());
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)ds, 10);
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)ds, 10);
        PartitionKey key0 = new PartitionKey(new Object[]{0});
        PartitionKey key1 = new PartitionKey(new Object[]{1});
        int total = this.readTestUsersInPartition((FileSystemDataset<GenericData.Record>)ds, key0, "email_hash") + this.readTestUsersInPartition((FileSystemDataset<GenericData.Record>)ds, key0, "email_hash");
        Assert.assertEquals((long)10L, (long)total);
        total = 0;
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int i2 = 0; i2 < 3; ++i2) {
                String part = "username_hash=" + i1 + "/email_hash=" + i2;
                Assert.assertTrue((String)("Partitioned directory " + part + " exists"), (boolean)this.fileSystem.exists(new Path(this.testDirectory, part)));
                total += this.readTestUsersInPartition((FileSystemDataset<GenericData.Record>)ds, new PartitionKey(new Object[]{i1, i2}), null);
            }
        }
        Assert.assertEquals((long)10L, (long)total);
        DatasetTestUtilities.testPartitionKeysAreEqual(ds, new PartitionKey[]{key0, key1});
        HashSet records = Sets.newHashSet();
        for (Dataset dataset : ds.getPartitions()) {
            Assert.assertTrue((String)"Partitions should have further partitions", (boolean)dataset.getDescriptor().isPartitioned());
            records.addAll(DatasetTestUtilities.materialize(ds));
        }
        DatasetTestUtilities.checkTestUsers(records, 10);
    }

    @Test
    public void testGetPartitionReturnsNullIfNoAutoCreate() throws IOException {
        PartitionStrategy partitionStrategy = new PartitionStrategy.Builder().hash("username", 2).build();
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("partitioned-users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).location(this.testDirectory).partitionStrategy(partitionStrategy).build()).type(GenericData.Record.class).build();
        Assert.assertNull((Object)ds.getPartition(new PartitionKey(new Object[]{1}), false));
    }

    @Test
    public void testWriteToSubpartition() throws IOException {
        PartitionStrategy partitionStrategy = new PartitionStrategy.Builder().hash("username", "username_part", 2).hash("email", 3).build();
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("partitioned-users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).compressionType(this.compressionType).location(this.testDirectory).partitionStrategy(partitionStrategy).build()).type(GenericData.Record.class).build();
        PartitionKey key = new PartitionKey(new Object[]{1});
        FileSystemDataset userPartition = (FileSystemDataset)ds.getPartition(key, true);
        Assert.assertEquals((Object)key, (Object)userPartition.getPartitionKey());
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)userPartition, 1);
        Assert.assertTrue((String)"Partitioned directory exists", (boolean)this.fileSystem.exists(new Path(this.testDirectory, "username_part=1/email_hash=2")));
        Assert.assertEquals((long)1L, (long)this.readTestUsersInPartition((FileSystemDataset<GenericData.Record>)ds, key, "email_hash"));
    }

    @Test
    public void testDropPartition() throws IOException {
        PartitionStrategy partitionStrategy = new PartitionStrategy.Builder().hash("username", 2).build();
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("partitioned-users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).compressionType(this.compressionType).location(this.testDirectory).partitionStrategy(partitionStrategy).build()).type(GenericData.Record.class).build();
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)ds, 10);
        Assert.assertTrue((boolean)this.fileSystem.isDirectory(new Path(this.testDirectory, "username_hash=0")));
        Assert.assertTrue((boolean)this.fileSystem.isDirectory(new Path(this.testDirectory, "username_hash=1")));
        ds.dropPartition(new PartitionKey(new Object[]{0}));
        Assert.assertFalse((boolean)this.fileSystem.isDirectory(new Path(this.testDirectory, "username_hash=0")));
        ds.dropPartition(new PartitionKey(new Object[]{1}));
        Assert.assertFalse((boolean)this.fileSystem.isDirectory(new Path(this.testDirectory, "username_hash=1")));
        DatasetException caught = null;
        try {
            ds.dropPartition(new PartitionKey(new Object[]{0}));
        }
        catch (DatasetException e) {
            caught = e;
        }
        Assert.assertNotNull((Object)((Object)caught));
    }

    @Test
    public void testMerge() throws IOException {
        PartitionStrategy partitionStrategy = new PartitionStrategy.Builder().hash("username", 2).build();
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("partitioned-users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).compressionType(this.compressionType).location(this.testDirectory).partitionStrategy(partitionStrategy).build()).type(GenericData.Record.class).build();
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)ds, 10);
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)ds, 10);
        Path newTestDirectory = this.fileSystem.makeQualified(new Path(Files.createTempDir().getAbsolutePath()));
        FileSystemDataset dsUpdate = new FileSystemDataset.Builder().namespace("ns").name("partitioned-users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).compressionType(this.compressionType).location(newTestDirectory).partitionStrategy(partitionStrategy).build()).type(GenericData.Record.class).build();
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)dsUpdate, 5, 10);
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)dsUpdate, 5, 10);
        ds.merge(dsUpdate);
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)dsUpdate, 0);
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)ds, 15);
    }

    @Test(expected=ValidationException.class)
    public void testCannotMergeDatasetsWithDifferentFormats() throws IOException {
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(Formats.AVRO).location(this.testDirectory).build()).type(GenericData.Record.class).build();
        FileSystemDataset dsUpdate = new FileSystemDataset.Builder().namespace("ns").name("users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(Formats.PARQUET).location(this.testDirectory).build()).type(GenericData.Record.class).build();
        ds.merge(dsUpdate);
    }

    @Test(expected=ValidationException.class)
    public void testCannotMergeDatasetsWithDifferentPartitionStrategies() throws IOException {
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).location(this.testDirectory).partitionStrategy(new PartitionStrategy.Builder().hash("username", 2).build()).build()).type(GenericData.Record.class).build();
        FileSystemDataset dsUpdate = new FileSystemDataset.Builder().namespace("ns").name("users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).location(this.testDirectory).partitionStrategy(new PartitionStrategy.Builder().hash("username", 2).hash("email", 3).build()).build()).type(GenericData.Record.class).build();
        ds.merge(dsUpdate);
    }

    @Test(expected=ValidationException.class)
    public void testCannotMergeDatasetsWithDifferentSchemas() throws IOException {
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.STRING_SCHEMA).location(this.testDirectory).build()).type(GenericData.Record.class).build();
        FileSystemDataset dsUpdate = new FileSystemDataset.Builder().namespace("ns").name("users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).location(this.testDirectory).build()).type(GenericData.Record.class).build();
        ds.merge(dsUpdate);
    }

    @Test
    public void testPathIterator_Directory() {
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).compressionType(this.compressionType).location(this.testDirectory).build()).type(GenericData.Record.class).build();
        ArrayList dirPaths = Lists.newArrayList((Iterator)ds.dirIterator());
        Assert.assertEquals((String)"dirIterator for non-partitioned dataset should yield a single path.", (long)1L, (long)dirPaths.size());
        Assert.assertEquals((String)"dirIterator should yield absolute paths.", (Object)this.testDirectory, dirPaths.get(0));
    }

    @Test
    public void testPathIterator_Partition_Directory() {
        PartitionStrategy partitionStrategy = new PartitionStrategy.Builder().hash("username", 2).hash("email", 3).build();
        final FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("partitioned-users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).compressionType(this.compressionType).location(this.testDirectory).partitionStrategy(partitionStrategy).build()).type(GenericData.Record.class).build();
        Assert.assertTrue((String)"Dataset is partitioned", (boolean)ds.getDescriptor().isPartitioned());
        Assert.assertEquals((Object)partitionStrategy, (Object)ds.getDescriptor().getPartitionStrategy());
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)ds, 10);
        DatasetTestUtilities.checkTestUsers((Dataset<GenericData.Record>)ds, 10);
        ArrayList dirPaths = Lists.newArrayList((Iterator)ds.dirIterator());
        Assert.assertEquals((long)6L, (long)dirPaths.size());
        Assert.assertTrue((String)"dirIterator should yield absolute paths.", (boolean)((Path)dirPaths.get(0)).isAbsolute());
        FileSystemDataset partition = (FileSystemDataset)ds.getPartition(new PartitionKey(new Object[]{1, 2}), false);
        ArrayList leafPaths = Lists.newArrayList((Iterator)partition.dirIterator());
        Assert.assertEquals((long)1L, (long)leafPaths.size());
        final Path leafPath = (Path)leafPaths.get(0);
        Assert.assertTrue((String)"dirIterator should yield absolute paths.", (boolean)leafPath.isAbsolute());
        Assert.assertEquals((Object)new PartitionKey(new Object[]{1, 2}), (Object)ds.keyFromDirectory(leafPath));
        Assert.assertEquals((Object)new PartitionKey(new Object[]{1}), (Object)ds.keyFromDirectory(leafPath.getParent()));
        Assert.assertEquals((Object)new PartitionKey(new Object[0]), (Object)ds.keyFromDirectory(leafPath.getParent().getParent()));
        TestHelpers.assertThrows("Path with too many components", IllegalStateException.class, new Runnable(){

            @Override
            public void run() {
                ds.keyFromDirectory(new Path(leafPath, "extra_dir"));
            }
        });
        TestHelpers.assertThrows("Non-relative path", IllegalStateException.class, new Runnable(){

            @Override
            public void run() {
                ds.keyFromDirectory(new Path("hdfs://different_host/"));
            }
        });
    }

    @Test
    public void testDeleteAllWithoutPartitions() {
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).location(this.testDirectory).build()).type(GenericData.Record.class).build();
        DatasetTestUtilities.writeTestUsers((View<GenericData.Record>)ds, 10);
        Assert.assertTrue((boolean)ds.deleteAll());
        DatasetTestUtilities.checkReaderBehavior(ds.newReader(), 0, null);
    }

    @Test
    public void signalReadyOnUnboundedDataset() {
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).location(this.testDirectory).build()).type(GenericData.Record.class).uri(URIBuilder.build((URI)URI.create("repo:" + this.testDirectory.toUri()), (String)"ns", (String)"name")).build();
        Assert.assertFalse((String)"Unbounded dataset has not been signaled", (boolean)ds.isReady());
        ds.signalReady();
        Assert.assertTrue((String)"Unbounded dataset has been signaled and should be ready", (boolean)ds.isReady());
    }

    @Test
    public void testReadySignalUpdatesModifiedTime() {
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace("ns").name("users").configuration(TestFileSystemDataset.getConfiguration()).descriptor(new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).format(this.format).location(this.testDirectory).build()).type(GenericData.Record.class).uri(URIBuilder.build((URI)URI.create("repo:" + this.testDirectory.toUri()), (String)"ns", (String)"name")).build();
        Assert.assertFalse((String)"Dataset should not be ready before being signaled", (boolean)ds.isReady());
        long signaledTime = 0L;
        long currentTime = System.currentTimeMillis();
        while (currentTime >= signaledTime && System.currentTimeMillis() - currentTime <= 2000L) {
            ds.signalReady();
            signaledTime = ds.getLastModified();
        }
        Assert.assertTrue((String)"Dataset should have been signaled as ready", (boolean)ds.isReady());
        Assert.assertTrue((String)"Signal should update the modified time", (signaledTime > currentTime ? 1 : 0) != 0);
        Assert.assertFalse((String)"Only the dataset should have been signaled", (boolean)((Signalable)ds.with("username", new Object[]{"bob"})).isReady());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readTestUsersInPartition(FileSystemDataset<GenericData.Record> ds, PartitionKey key, String subpartitionName) {
        int readCount = 0;
        DatasetReader reader = null;
        try {
            PartitionedDataset partition = ds.getPartition(key, false);
            if (subpartitionName != null) {
                List fieldPartitioners = Accessor.getDefault().getFieldPartitioners(partition.getDescriptor().getPartitionStrategy());
                Assert.assertEquals((long)1L, (long)fieldPartitioners.size());
                Assert.assertEquals((Object)subpartitionName, (Object)((FieldPartitioner)fieldPartitioners.get(0)).getName());
            }
            reader = partition.newReader();
            for (GenericData.Record actualRecord : reader) {
                Assert.assertEquals((String)actualRecord.toString(), (Object)key.get(0), (Object)((actualRecord.get("username").hashCode() & Integer.MAX_VALUE) % 2));
                if (key.getLength() > 1) {
                    Assert.assertEquals((Object)key.get(1), (Object)((actualRecord.get("email").hashCode() & Integer.MAX_VALUE) % 3));
                }
                ++readCount;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return readCount;
    }
}

