/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.codehaus.jackson.JsonNode;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.filesystem.CSVProperties;
import org.kitesdk.data.spi.filesystem.CSVUtil;

public class TestCSVSchemaInference {
    String csvLines = "long,float,double,double2,string,nullable_long,nullable_string\n34,12.3f,99.9d,81.0,s,,\n35,\"1.2f\",,,\"\",1234\n";

    public Schema nullable(Schema.Type type) {
        return Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)type)));
    }

    public Schema schema(Schema.Type type) {
        return Schema.create((Schema.Type)type);
    }

    @Test
    public void testSchemaInference() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.csvLines.getBytes("utf8"));
        Schema schema = CSVUtil.inferSchema((String)"TestRecord", (InputStream)stream, (CSVProperties)new CSVProperties.Builder().hasHeader().build());
        Assert.assertEquals((String)"Should use name", (Object)"TestRecord", (Object)schema.getName());
        Assert.assertNull((String)"Should not have namespace", (Object)schema.getNamespace());
        Assert.assertNotNull((Object)schema.getField("long"));
        Assert.assertNotNull((Object)schema.getField("float"));
        Assert.assertNotNull((Object)schema.getField("double"));
        Assert.assertNotNull((Object)schema.getField("double2"));
        Assert.assertNotNull((Object)schema.getField("string"));
        Assert.assertNotNull((Object)schema.getField("nullable_long"));
        Assert.assertNotNull((Object)schema.getField("nullable_string"));
        Assert.assertEquals((String)"Should infer a long", (Object)this.schema(Schema.Type.LONG), (Object)schema.getField("long").schema());
        Assert.assertEquals((String)"Should infer a float (ends in f)", (Object)this.schema(Schema.Type.FLOAT), (Object)schema.getField("float").schema());
        Assert.assertEquals((String)"Should infer a double (ends in d)", (Object)this.nullable(Schema.Type.DOUBLE), (Object)schema.getField("double").schema());
        Assert.assertEquals((String)"Should infer a double (decimal defaults to double)", (Object)this.nullable(Schema.Type.DOUBLE), (Object)schema.getField("double2").schema());
        Assert.assertEquals((String)"Should infer a non-null string (not numeric)", (Object)this.schema(Schema.Type.STRING), (Object)schema.getField("string").schema());
        Assert.assertEquals((String)"Should infer a nullable long (second line is a long)", (Object)this.nullable(Schema.Type.LONG), (Object)schema.getField("nullable_long").schema());
        Assert.assertEquals((String)"Should infer a nullable string (second is missing)", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("nullable_string").schema());
    }

    @Test
    public void testMissingRequiredFields() throws Exception {
        TestHelpers.assertThrows("Should fail: empty string found, required long", DatasetException.class, new Runnable(){

            @Override
            public void run() {
                try {
                    CSVUtil.inferSchema((String)"TestRecord", (InputStream)new ByteArrayInputStream(TestCSVSchemaInference.this.csvLines.getBytes("utf8")), (CSVProperties)new CSVProperties.Builder().hasHeader().build(), (Set)ImmutableSet.of((Object)"nullable_long"));
                }
                catch (IOException e) {
                    throw new RuntimeException("Schema inference threw IOException", e);
                }
            }
        });
        TestHelpers.assertThrows("Should fail: null found, required string", DatasetException.class, new Runnable(){

            @Override
            public void run() {
                try {
                    CSVUtil.inferSchema((String)"TestRecord", (InputStream)new ByteArrayInputStream(TestCSVSchemaInference.this.csvLines.getBytes("utf8")), (CSVProperties)new CSVProperties.Builder().hasHeader().build(), (Set)ImmutableSet.of((Object)"nullable_string"));
                }
                catch (IOException e) {
                    throw new RuntimeException("Schema inference threw IOException", e);
                }
            }
        });
    }

    @Test
    public void testSchemaInferenceWithoutHeader() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.csvLines.getBytes("utf8"));
        Schema schema = CSVUtil.inferSchema((String)"TestRecord", (InputStream)stream, (CSVProperties)new CSVProperties.Builder().build(), (Set)ImmutableSet.of((Object)"float"));
        Assert.assertNull((Object)schema.getField("long"));
        Assert.assertNull((Object)schema.getField("float"));
        Assert.assertNull((Object)schema.getField("double"));
        Assert.assertNull((Object)schema.getField("double2"));
        Assert.assertNull((Object)schema.getField("string"));
        Assert.assertNull((Object)schema.getField("nullable_long"));
        Assert.assertNull((Object)schema.getField("nullable_string"));
        Assert.assertNotNull((Object)schema.getField("field_0"));
        Assert.assertNotNull((Object)schema.getField("field_1"));
        Assert.assertNotNull((Object)schema.getField("field_2"));
        Assert.assertNotNull((Object)schema.getField("field_3"));
        Assert.assertNotNull((Object)schema.getField("field_4"));
        Assert.assertNotNull((Object)schema.getField("field_5"));
        Assert.assertNotNull((Object)schema.getField("field_6"));
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.schema(Schema.Type.STRING), (Object)schema.getField("field_0").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.schema(Schema.Type.STRING), (Object)schema.getField("field_1").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.schema(Schema.Type.STRING), (Object)schema.getField("field_2").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.schema(Schema.Type.STRING), (Object)schema.getField("field_3").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.schema(Schema.Type.STRING), (Object)schema.getField("field_4").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.schema(Schema.Type.STRING), (Object)schema.getField("field_5").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("field_6").schema());
    }

    @Test
    public void testNullableSchemaInference() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.csvLines.getBytes("utf8"));
        Schema schema = CSVUtil.inferNullableSchema((String)"TestRecord", (InputStream)stream, (CSVProperties)new CSVProperties.Builder().hasHeader().build(), (Set)ImmutableSet.of((Object)"float"));
        Assert.assertEquals((String)"Should use name", (Object)"TestRecord", (Object)schema.getName());
        Assert.assertNull((String)"Should not have namespace", (Object)schema.getNamespace());
        Assert.assertNotNull((Object)schema.getField("long"));
        Assert.assertNotNull((Object)schema.getField("float"));
        Assert.assertNotNull((Object)schema.getField("double"));
        Assert.assertNotNull((Object)schema.getField("double2"));
        Assert.assertNotNull((Object)schema.getField("string"));
        Assert.assertNotNull((Object)schema.getField("nullable_long"));
        Assert.assertNotNull((Object)schema.getField("nullable_string"));
        Assert.assertEquals((String)"Should infer a long", (Object)this.nullable(Schema.Type.LONG), (Object)schema.getField("long").schema());
        Assert.assertEquals((String)"Should infer a non-null float (required, ends in f)", (Object)this.schema(Schema.Type.FLOAT), (Object)schema.getField("float").schema());
        Assert.assertEquals((String)"Should infer a double (ends in d)", (Object)this.nullable(Schema.Type.DOUBLE), (Object)schema.getField("double").schema());
        Assert.assertEquals((String)"Should infer a double (decimal defaults to double)", (Object)this.nullable(Schema.Type.DOUBLE), (Object)schema.getField("double2").schema());
        Assert.assertEquals((String)"Should infer a string (not numeric)", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("string").schema());
        Assert.assertEquals((String)"Should infer a long (second line is a long)", (Object)this.nullable(Schema.Type.LONG), (Object)schema.getField("nullable_long").schema());
        Assert.assertEquals((String)"Should infer a nullable string (second is missing)", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("nullable_string").schema());
    }

    @Test
    public void testNullableSchemaInferenceWithoutHeader() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.csvLines.getBytes("utf8"));
        Schema schema = CSVUtil.inferNullableSchema((String)"TestRecord", (InputStream)stream, (CSVProperties)new CSVProperties.Builder().build(), (Set)ImmutableSet.of((Object)"long", (Object)"field_1"));
        Assert.assertNull((Object)schema.getField("long"));
        Assert.assertNull((Object)schema.getField("float"));
        Assert.assertNull((Object)schema.getField("double"));
        Assert.assertNull((Object)schema.getField("double2"));
        Assert.assertNull((Object)schema.getField("string"));
        Assert.assertNull((Object)schema.getField("nullable_long"));
        Assert.assertNull((Object)schema.getField("nullable_string"));
        Assert.assertNotNull((Object)schema.getField("field_0"));
        Assert.assertNotNull((Object)schema.getField("field_1"));
        Assert.assertNotNull((Object)schema.getField("field_2"));
        Assert.assertNotNull((Object)schema.getField("field_3"));
        Assert.assertNotNull((Object)schema.getField("field_4"));
        Assert.assertNotNull((Object)schema.getField("field_5"));
        Assert.assertNotNull((Object)schema.getField("field_6"));
        Assert.assertEquals((String)"Header fields are all strings, not named long", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("field_0").schema());
        Assert.assertEquals((String)"Header fields are all strings, field_1 is required", (Object)this.schema(Schema.Type.STRING), (Object)schema.getField("field_1").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("field_2").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("field_3").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("field_4").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("field_5").schema());
        Assert.assertEquals((String)"Header fields are all strings", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("field_6").schema());
    }

    @Test
    public void testSchemaInferenceSkipHeader() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.csvLines.getBytes("utf8"));
        Schema schema = CSVUtil.inferSchema((String)"TestRecord", (InputStream)stream, (CSVProperties)new CSVProperties.Builder().linesToSkip(1).build(), (Set)ImmutableSet.of((Object)"long", (Object)"field_1"));
        Assert.assertNull((Object)schema.getField("long"));
        Assert.assertNull((Object)schema.getField("float"));
        Assert.assertNull((Object)schema.getField("double"));
        Assert.assertNull((Object)schema.getField("double2"));
        Assert.assertNull((Object)schema.getField("string"));
        Assert.assertNull((Object)schema.getField("nullable_long"));
        Assert.assertNull((Object)schema.getField("nullable_string"));
        Assert.assertNotNull((Object)schema.getField("field_0"));
        Assert.assertNotNull((Object)schema.getField("field_1"));
        Assert.assertNotNull((Object)schema.getField("field_2"));
        Assert.assertNotNull((Object)schema.getField("field_3"));
        Assert.assertNotNull((Object)schema.getField("field_4"));
        Assert.assertNotNull((Object)schema.getField("field_5"));
        Assert.assertNotNull((Object)schema.getField("field_6"));
        JsonNode nullDefault = ((Schema.Field)((Schema)SchemaBuilder.record((String)"Test").fields().optionalInt("f1").endRecord()).getFields().get(0)).defaultValue();
        Assert.assertEquals((String)"Should infer a long", (Object)this.schema(Schema.Type.LONG), (Object)schema.getField("field_0").schema());
        Assert.assertNull((String)"Should not have a default value", (Object)schema.getField("field_0").defaultValue());
        Assert.assertEquals((String)"Should infer a float (ends in f)", (Object)this.schema(Schema.Type.FLOAT), (Object)schema.getField("field_1").schema());
        Assert.assertNull((String)"Should not have a default value", (Object)schema.getField("field_1").defaultValue());
        Assert.assertEquals((String)"Should infer a double (ends in d)", (Object)this.nullable(Schema.Type.DOUBLE), (Object)schema.getField("field_2").schema());
        Assert.assertEquals((String)"Should have default value null", (Object)schema.getField("field_2").defaultValue(), (Object)nullDefault);
        Assert.assertEquals((String)"Should infer a double (decimal defaults to double)", (Object)this.nullable(Schema.Type.DOUBLE), (Object)schema.getField("field_3").schema());
        Assert.assertEquals((String)"Should have default value null", (Object)schema.getField("field_3").defaultValue(), (Object)nullDefault);
        Assert.assertEquals((String)"Should infer a non-null string (not numeric)", (Object)this.schema(Schema.Type.STRING), (Object)schema.getField("field_4").schema());
        Assert.assertNull((String)"Should not have a default value", (Object)schema.getField("field_4").defaultValue());
        Assert.assertEquals((String)"Should infer a long (second line is a long)", (Object)this.nullable(Schema.Type.LONG), (Object)schema.getField("field_5").schema());
        Assert.assertEquals((String)"Should have default value null", (Object)schema.getField("field_5").defaultValue(), (Object)nullDefault);
        Assert.assertEquals((String)"Should infer a nullable string (second is missing)", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("field_6").schema());
        Assert.assertEquals((String)"Should have default value null", (Object)schema.getField("field_6").defaultValue(), (Object)nullDefault);
    }

    @Test
    public void testSchemaInferenceMissingExample() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream("\none,two\n34,\n".getBytes("utf8"));
        Schema schema = CSVUtil.inferSchema((String)"TestRecord", (InputStream)stream, (CSVProperties)new CSVProperties.Builder().linesToSkip(1).hasHeader().build());
        Assert.assertNotNull((Object)schema.getField("one"));
        Assert.assertNotNull((Object)schema.getField("two"));
        Assert.assertEquals((String)"Should infer a long", (Object)this.schema(Schema.Type.LONG), (Object)schema.getField("one").schema());
        Assert.assertEquals((String)"Should default to a string", (Object)this.nullable(Schema.Type.STRING), (Object)schema.getField("two").schema());
    }

    @Test
    public void testSchemaNamespace() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.csvLines.getBytes("utf8"));
        Schema schema = CSVUtil.inferNullableSchema((String)"com.example.TestRecord", (InputStream)stream, (CSVProperties)new CSVProperties.Builder().hasHeader().build());
        Assert.assertEquals((String)"Should use name", (Object)"TestRecord", (Object)schema.getName());
        Assert.assertEquals((String)"Should set namespace", (Object)"com.example", (Object)schema.getNamespace());
    }

    @Test
    public void testSamplePrintableCharactersNotChanged() {
        String upper = "ABCDEFGHIJKLMNOPQRXTUVWXYZ";
        Assert.assertEquals((String)"Upper case letters shouldn't be removed", (Object)upper, (Object)CSVUtil.sample((String)upper));
        String lower = "abcdefghijklmnopqrstuvwxyz";
        Assert.assertEquals((String)"Lower case letters shouldn't be removed", (Object)lower, (Object)CSVUtil.sample((String)lower));
        String numbers = "0123456789";
        Assert.assertEquals((String)"Numbers shouldn't be removed", (Object)numbers, (Object)CSVUtil.sample((String)numbers));
        String punctuation = " _-~+!@#$%^&*(){}[]<>,.?:;`'\"/\\|";
        Assert.assertEquals((String)"Punctuation shouldn't be removed", (Object)punctuation, (Object)CSVUtil.sample((String)punctuation));
    }

    @Test
    public void testUnicodeRemoved() {
        String hasUnicode = "Unicode snowflake: \u2744";
        Assert.assertEquals((String)"Should remove unicode", (Object)"Unicode snowflake: .", (Object)CSVUtil.sample((String)hasUnicode));
    }

    @Test
    public void testSampleTruncated() {
        String longUrl = "https://github.com/kite-sdk/kite/commit/bbe3e917875e879ca58b8afe90efa96cdd4691d1";
        Assert.assertEquals((String)"Should truncate long values", (Object)"https://github.com/kite-sdk/kite/commit/bbe3e91787", (Object)CSVUtil.sample((String)longUrl));
    }

    @Test
    public void testSampleNull() {
        String nullString = null;
        Assert.assertEquals((String)"Should handle null like String.valueOf", (Object)String.valueOf(nullString), (Object)CSVUtil.sample(nullString));
    }
}

