/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.junit.Assert;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Flushable;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.InitializeAccessor;
import org.kitesdk.data.spi.PartitionKey;
import org.kitesdk.data.spi.PartitionedDataset;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;

public class DatasetTestUtilities {
    public static final Schema STRING_SCHEMA = DatasetTestUtilities.loadSchema("schema/string.avsc");
    public static final Schema USER_SCHEMA = DatasetTestUtilities.loadSchema("schema/user.avsc");
    public static final Schema USER_NULLABLE_SCHEMA = DatasetTestUtilities.loadSchema("schema/user_nullable.avsc");
    public static final Schema OLD_VALUE_SCHEMA = DatasetTestUtilities.loadSchema("schema/old_value.avsc");
    public static final URI USER_SCHEMA_URL = DatasetTestUtilities.findSchemaURI("schema/user.avsc");

    private static Schema loadSchema(String resource) {
        try {
            return new Schema.Parser().parse(Resources.getResource((String)resource).openStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load " + resource);
        }
    }

    private static URI findSchemaURI(String resource) {
        try {
            return Resources.getResource((String)resource).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot load " + resource);
        }
    }

    public static void writeTestUsers(View<GenericData.Record> ds, int count) {
        DatasetTestUtilities.writeTestUsers(ds, count, 0);
    }

    public static void writeTestUsers(View<GenericData.Record> ds, int count, int start) {
        DatasetTestUtilities.writeTestUsers(ds, count, start, "email");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTestUsers(View<GenericData.Record> view, int count, int start, String ... fields) {
        DatasetWriter writer = null;
        try {
            writer = view.newWriter();
            for (int i = start; i < count + start; ++i) {
                GenericRecordBuilder recordBuilder = new GenericRecordBuilder(view.getDataset().getDescriptor().getSchema()).set("username", (Object)("test-" + i));
                for (String field : fields) {
                    recordBuilder.set(field, (Object)(field + "-" + i));
                }
                writer.write((Object)recordBuilder.build());
            }
            if (writer instanceof Flushable) {
                ((Flushable)writer).flush();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void checkTestUsers(Dataset<GenericData.Record> ds, int count) {
        DatasetTestUtilities.checkTestUsers(ds, count, "email");
    }

    public static void checkTestUsers(Dataset<GenericData.Record> ds, int count, int start) {
        DatasetTestUtilities.checkTestUsers(ds, count, start, "email");
    }

    public static void checkTestUsers(Dataset<GenericData.Record> ds, int count, String ... fields) {
        DatasetTestUtilities.checkTestUsers(ds, count, 0, fields);
    }

    public static void checkTestUsers(Dataset<GenericData.Record> ds, int count, int start, final String ... fields) {
        final HashSet usernames = Sets.newHashSet();
        for (int i = start; i < count + start; ++i) {
            usernames.add("test-" + i);
        }
        DatasetTestUtilities.checkReaderBehavior(ds.newReader(), count, new RecordValidator<GenericData.Record>(){

            @Override
            public void validate(GenericData.Record record, int recordNum) {
                String username = record.get("username").toString();
                Assert.assertTrue((String)("Username not found: " + username), (boolean)usernames.remove(username));
                for (String field : fields) {
                    Assert.assertNotNull((String)("Field is null: " + field + ", record: " + record), (Object)record.get(field));
                }
            }
        });
        Assert.assertTrue((boolean)usernames.isEmpty());
    }

    public static void checkTestUsers(Set<GenericData.Record> records, int count) {
        Assert.assertEquals((String)"Wrong number of records", (long)count, (long)records.size());
        HashSet usernames = Sets.newHashSet();
        for (int i = 0; i < count; ++i) {
            usernames.add("test-" + i);
        }
        for (GenericData.Record actualRecord : records) {
            Assert.assertTrue((boolean)usernames.remove(actualRecord.get("username").toString()));
            Assert.assertNotNull((Object)actualRecord.get("email"));
        }
        Assert.assertTrue((boolean)usernames.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> Set<E> materialize(View<E> ds) {
        HashSet records = Sets.newHashSet();
        DatasetReader reader = null;
        try {
            reader = ds.newReader();
            for (Object record : reader) {
                records.add(record);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return records;
    }

    public static <E> int datasetSize(View<E> ds) {
        return DatasetTestUtilities.materialize(ds).size();
    }

    public static <E> void testPartitionKeysAreEqual(PartitionedDataset<E> ds, PartitionKey ... expectedKeys) {
        HashSet expected = Sets.newHashSet((Object[])expectedKeys);
        HashSet actual = Sets.newHashSet((Iterable)Iterables.transform((Iterable)ds.getPartitions(), (Function)new Function<Dataset, PartitionKey>(){

            public PartitionKey apply(Dataset input) {
                return ((FileSystemDataset)input).getPartitionKey();
            }
        }));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> void checkReaderBehavior(DatasetReader<R> reader, int totalRecords, RecordValidator<R> validator) {
        if (!reader.isOpen() && reader instanceof InitializeAccessor) {
            ((InitializeAccessor)reader).initialize();
        }
        try {
            Assert.assertTrue((String)"Reader should be open", (boolean)reader.isOpen());
            DatasetTestUtilities.checkReaderIteration(reader, totalRecords, validator);
        }
        finally {
            reader.close();
        }
        Assert.assertFalse((String)"Reader is open after close()", (boolean)reader.isOpen());
    }

    public static <R> void checkReaderIteration(DatasetReader<R> reader, int expectedRecordCount, RecordValidator<R> validator) {
        int recordCount = 0;
        Assert.assertTrue((String)"Reader is not open", (boolean)reader.isOpen());
        Assert.assertTrue((String)("Reader has no records, expected " + expectedRecordCount), (expectedRecordCount == 0 || reader.hasNext() ? 1 : 0) != 0);
        for (Object record : reader) {
            validator.validate(record, recordCount);
            Assert.assertNotNull(record);
            reader.hasNext();
            ++recordCount;
        }
        Assert.assertFalse((String)"Reader is empty, but hasNext is true", (boolean)reader.hasNext());
        try {
            reader.next();
            Assert.fail((String)"Reader did not throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Reader is empty, but should be open", (boolean)reader.isOpen());
        Assert.assertEquals((String)"Incorrect number of records", (long)expectedRecordCount, (long)recordCount);
    }

    public static interface RecordValidator<R> {
        public void validate(R var1, int var2);
    }
}

