/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.PartitionStrategyParser;

public class TestPartitionStrategyParser {
    public static void checkParser(PartitionStrategy expected, String json) {
        PartitionStrategy parsed = PartitionStrategyParser.parse((String)json);
        Assert.assertEquals((Object)expected, (Object)parsed);
        parsed = PartitionStrategyParser.parse((String)expected.toString());
        Assert.assertEquals((String)"Should reparse properly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testIdentity() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().identity("username", "id").build(), "[ {\"type\": \"identity\", \"source\": \"username\", \"name\": \"id\"} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().identity("username", "username_copy").build(), "[ {\"type\": \"identity\", \"source\": \"username\"} ]");
    }

    @Test
    public void testHash() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().hash("id", 64).build(), "[ {\"type\": \"hash\", \"source\": \"id\", \"buckets\": 64} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().hash("id", "h", 64).build(), "[ {\"type\": \"hash\", \"source\": \"id\", \"name\": \"h\", \"buckets\": 64} ]");
        TestHelpers.assertThrows("Should reject missing buckets", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"hash\", \"source\": \"id\", \"name\": \"h\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject invalid buckets", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"hash\", \"source\": \"id\", \"name\": \"h\", \"buckets\": \"green\"} ]");
            }
        });
    }

    @Test
    public void testFixedSizedRange() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().fixedSizeRange("id", 64L).build(), "[ {\"type\": \"range\", \"source\": \"id\", \"size\": 64} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().fixedSizeRange("id", "rng", 64L).build(), "[ {\"type\": \"range\", \"source\": \"id\", \"name\": \"rng\", \"size\": 64} ]");
        TestHelpers.assertThrows("Should reject missing size", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"range\", \"source\": \"id\", \"name\": \"rng\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject invalid size", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"range\", \"source\": \"id\", \"name\": \"rng\", \"size\": \"green\"} ]");
            }
        });
    }

    @Test
    public void testDateFormat() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().dateFormat("time", "date", "yyyyMMdd").build(), "[ {\"type\": \"dateFormat\", \"source\": \"time\", \"name\": \"date\", \"format\": \"yyyyMMdd\"} ]");
        TestHelpers.assertThrows("Should reject missing format", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"dateFormat\", \"source\": \"time\", \"name\": \"date\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject missing name", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"dateFormat\", \"source\": \"time\", \"format\": \"yyyyMMdd\"} ]");
            }
        });
    }

    @Test
    public void testYear() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().year("time").build(), "[ {\"type\": \"year\", \"source\": \"time\"} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().year("time", "y").build(), "[ {\"type\": \"year\", \"source\": \"time\", \"name\": \"y\"} ]");
    }

    @Test
    public void testMonth() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().month("time").build(), "[ {\"type\": \"month\", \"source\": \"time\"} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().month("time", "m").build(), "[ {\"type\": \"month\", \"source\": \"time\", \"name\": \"m\"} ]");
    }

    @Test
    public void testDay() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().day("time").build(), "[ {\"type\": \"day\", \"source\": \"time\"} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().day("time", "d").build(), "[ {\"type\": \"day\", \"source\": \"time\", \"name\": \"d\"} ]");
    }

    @Test
    public void testHour() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().hour("time").build(), "[ {\"type\": \"hour\", \"source\": \"time\"} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().hour("time", "h").build(), "[ {\"type\": \"hour\", \"source\": \"time\", \"name\": \"h\"} ]");
    }

    @Test
    public void testMinute() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().minute("time").build(), "[ {\"type\": \"minute\", \"source\": \"time\"} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().minute("time", "m").build(), "[ {\"type\": \"minute\", \"source\": \"time\", \"name\": \"m\"} ]");
    }

    @Test
    public void testProvided() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().provided("version").build(), "[ {\"type\": \"provided\", \"name\": \"version\"} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().provided("version").build(), "[ {\"type\": \"provided\", \"name\": \"version\", \"values\": \"string\"} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().provided("version", "string").build(), "[ {\"type\": \"provided\", \"name\": \"version\", \"values\": \"string\"} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().provided("version", "int").build(), "[ {\"type\": \"provided\", \"name\": \"version\", \"values\": \"int\"} ]");
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().provided("version", "long").build(), "[ {\"type\": \"provided\", \"name\": \"version\", \"values\": \"long\"} ]");
        TestHelpers.assertThrows("Should reject missing name", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"provided\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject unsupported values type", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"provided\", \"name\": \"version\", \"values\": \"float\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject invalid values type", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"provided\", \"name\": \"version\", \"values\": \"unknown\"} ]");
            }
        });
    }

    @Test
    public void testMultipleFields() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().provided("version").hash("username", 64).identity("username", "u").year("time").month("time").day("time").hour("time").minute("time").dateFormat("time", "datetime", "yyyy_MM_dd_HHmmss").build(), "[ {\"type\": \"provided\", \"name\": \"version\"},{\"type\": \"hash\", \"source\": \"username\", \"buckets\": 64},{\"type\": \"identity\",\"source\": \"username\", \"name\": \"u\"},{\"type\": \"year\", \"source\": \"time\"},{\"type\": \"month\", \"source\": \"time\"},{\"type\": \"day\", \"source\": \"time\"},{\"type\": \"hour\", \"source\": \"time\"},{\"type\": \"minute\", \"source\": \"time\"},{\"type\": \"dateFormat\", \"source\": \"time\", \"name\": \"datetime\", \"format\": \"yyyy_MM_dd_HHmmss\"} ]");
    }

    @Test
    public void testNumericInsteadOfString() {
        TestPartitionStrategyParser.checkParser(new PartitionStrategy.Builder().year("34").build(), "[ {\"type\": \"year\", \"source\": 34} ]");
    }

    @Test
    public void testMissingSource() {
        String[] types;
        for (final String type : types = new String[]{"identity", "hash", "year", "month", "day", "hour", "minute", "dateFormat"}) {
            TestHelpers.assertThrows("Should reject missing source", ValidationException.class, new Runnable(){

                @Override
                public void run() {
                    PartitionStrategyParser.parse((String)("[ {\"type\": \"" + type + "\"} ]"));
                }
            });
        }
    }

    @Test
    public void testMissingType() {
        TestHelpers.assertThrows("Should reject missing partitioner type", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"source\": \"banana\"} ]");
            }
        });
    }

    @Test
    public void testUnknownType() {
        TestHelpers.assertThrows("Should reject unknown partitioner type", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"cats\", \"source\": \"banana\"} ]");
            }
        });
    }

    @Test
    public void testJsonObject() {
        TestHelpers.assertThrows("Should reject non-array strategy", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"{\"type\": \"year\", \"source\": \"banana\"}");
            }
        });
    }

    @Test
    public void testNonRecordPartitioner() {
        TestHelpers.assertThrows("Should reject JSON string partitioner", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"year\", \"source\": \"time\"},\"cheese!\" ]");
            }
        });
        TestHelpers.assertThrows("Should reject JSON number partitioner", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"year\", \"source\": \"time\"},34 ]");
            }
        });
        TestHelpers.assertThrows("Should reject JSON array partitioner", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\": \"year\", \"source\": \"time\"},[ 1, 2, 3 ] ]");
            }
        });
    }

    @Test
    public void testInvalidJson() {
        TestHelpers.assertThrows("Should reject bad JSON", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((String)"[ {\"type\", \"year\", \"source\": \"banana\"} ]");
            }
        });
    }

    @Test
    public void testInputStreamIOException() {
        TestHelpers.assertThrows("Should pass DatasetIOException", DatasetIOException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((InputStream)new InputStream(){

                    @Override
                    public int read() throws IOException {
                        throw new IOException("InputStream angry.");
                    }
                });
            }
        });
    }

    @Test
    public void testMissingFile() {
        TestHelpers.assertThrows("Should pass DatasetIOException", DatasetIOException.class, new Runnable(){

            @Override
            public void run() {
                PartitionStrategyParser.parse((File)new File("target/missing.json"));
            }
        });
    }

    @Test
    public void testAddEmbeddedPartitionStrategy() {
        PartitionStrategy strategy = new PartitionStrategy.Builder().hash("username", 16).identity("username", "u").build();
        Schema original = new Schema.Parser().parse("{  \"type\": \"record\",  \"name\": \"User\",  \"fields\": [    {\"name\": \"id\", \"type\": \"long\"},    {\"name\": \"username\", \"type\": \"string\"},    {\"name\": \"real_name\", \"type\": \"string\"}  ]}");
        Schema embedded = PartitionStrategyParser.embedPartitionStrategy((Schema)original, (PartitionStrategy)strategy);
        Assert.assertTrue((boolean)PartitionStrategyParser.hasEmbeddedStrategy((Schema)embedded));
        Assert.assertEquals((Object)strategy, (Object)PartitionStrategyParser.parseFromSchema((Schema)embedded));
    }

    @Test
    public void testReplaceEmbeddedPartitionStrategy() {
        PartitionStrategy strategy = new PartitionStrategy.Builder().hash("username", 16).identity("username", "u").build();
        Schema original = new Schema.Parser().parse("{  \"type\": \"record\",  \"name\": \"User\",  \"partitions\": [    {\"type\": \"hash\", \"source\": \"real_name\", \"buckets\": 64},    {\"type\": \"identity\", \"source\": \"real_name\", \"name\": \"r\"}  ],  \"fields\": [    {\"name\": \"id\", \"type\": \"long\"},    {\"name\": \"username\", \"type\": \"string\"},    {\"name\": \"real_name\", \"type\": \"string\"}  ]}");
        Assert.assertTrue((boolean)PartitionStrategyParser.hasEmbeddedStrategy((Schema)original));
        Assert.assertFalse((boolean)PartitionStrategyParser.parseFromSchema((Schema)original).equals((Object)strategy));
        Schema embedded = PartitionStrategyParser.embedPartitionStrategy((Schema)original, (PartitionStrategy)strategy);
        Assert.assertTrue((boolean)PartitionStrategyParser.hasEmbeddedStrategy((Schema)embedded));
        Assert.assertEquals((Object)strategy, (Object)PartitionStrategyParser.parseFromSchema((Schema)embedded));
    }
}

