/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.StorageKey;

public class TestNestedFieldPartitioning {
    private static final Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Station").fields().requiredString("name").name("position").type().record("Position").namespace("org.kitesdk.data.spi.TestNestedFieldPartitioning$Station$")).fields().requiredDouble("latitude").requiredDouble("longitude").endRecord()).noDefault().endRecord();
    private static final PartitionStrategy strategy = new PartitionStrategy.Builder().identity("position.latitude", "lat").identity("position.longitude", "long").build();

    @Test
    public void testDescriptorValidationPasses() {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(schema).partitionStrategy(strategy).build();
        Assert.assertEquals((String)"Descriptor should have correct schema", (Object)schema, (Object)descriptor.getSchema());
        Assert.assertEquals((String)"Descriptor should have correct strategy", (Object)strategy, (Object)descriptor.getPartitionStrategy());
    }

    @Test
    public void testDescriptorValidationFails() {
        final PartitionStrategy missingStartField = new PartitionStrategy.Builder().identity("p.latitude").identity("p.longitude").build();
        TestHelpers.assertThrows("Should complain that p is missing", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().schema(schema).partitionStrategy(missingStartField).build();
            }
        });
        final PartitionStrategy missingLongField = new PartitionStrategy.Builder().identity("position.latitude").identity("position.long").build();
        TestHelpers.assertThrows("Should complain that position.long is missing", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().schema(schema).partitionStrategy(missingLongField).build();
            }
        });
        final PartitionStrategy badExpectedType = new PartitionStrategy.Builder().identity("position.latitude").year("position.longitude").build();
        TestHelpers.assertThrows("Should complain about mismatched expected type", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().schema(schema).partitionStrategy(badExpectedType).build();
            }
        });
    }

    @Test
    public void testStorageKeyForGenericEntity() {
        GenericData.Record position = new GenericData.Record(schema.getField("position").schema());
        position.put("latitude", (Object)37.776);
        position.put("longitude", (Object)-122.418);
        GenericData.Record generic = new GenericData.Record(schema);
        generic.put("name", (Object)"KCASANFR291");
        generic.put("position", (Object)position);
        StorageKey key = new StorageKey.Builder(strategy).add("position.latitude", (Object)0).add("position.longitude", (Object)0).build();
        StorageKey expected = StorageKey.copy((StorageKey)key);
        expected.replace(0, (Object)37.776);
        expected.replace(1, (Object)-122.418);
        key.reuseFor((Object)generic, DataModelUtil.accessor(GenericRecord.class, (Schema)schema));
        Assert.assertEquals((Object)expected, (Object)key);
    }

    @Test
    public void testStorageKeyForReflectedEntity() {
        Station station = new Station("KCASANFR291", 37.776, -122.418);
        StorageKey key = new StorageKey.Builder(strategy).add("position.latitude", (Object)0).add("position.longitude", (Object)0).build();
        StorageKey expected = StorageKey.copy((StorageKey)key);
        expected.replace(0, (Object)37.776);
        expected.replace(1, (Object)-122.418);
        key.reuseFor((Object)station, DataModelUtil.accessor(Station.class, (Schema)schema));
        Assert.assertEquals((Object)expected, (Object)key);
    }

    private static class Station {
        private Position position;
        private String name;

        private Station(String name, double lat, double lon) {
            this.name = name;
            this.position = new Position();
            this.position.latitude = lat;
            this.position.longitude = lon;
        }

        private static class Position {
            private double latitude;
            private double longitude;

            private Position() {
            }
        }
    }
}

