/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.collect.ImmutableMultiset;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetExistsException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.Formats;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.MetadataProvider;

@RunWith(value=Parameterized.class)
public abstract class TestMetadataProviders
extends MiniDFSTest {
    protected static final String NAMESPACE = "ns1";
    protected static final String NAME = "provider_test1";
    protected boolean distributed;
    protected Configuration conf;
    protected DatasetDescriptor testDescriptor;
    protected DatasetDescriptor anotherDescriptor;
    protected MetadataProvider provider;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public abstract MetadataProvider newProvider(Configuration var1);

    public TestMetadataProviders(boolean distributed) {
        this.distributed = distributed;
    }

    @Before
    public void setUp() throws IOException, URISyntaxException {
        this.conf = this.distributed ? MiniDFSTest.getConfiguration() : new Configuration();
        this.testDescriptor = new DatasetDescriptor.Builder().format(Formats.AVRO).schema((Schema)SchemaBuilder.record((String)"Event").fields().requiredLong("timestamp").requiredString("message").endRecord()).partitionStrategy(new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build()).build();
        this.anotherDescriptor = new DatasetDescriptor.Builder().format(Formats.PARQUET).schema((Schema)SchemaBuilder.record((String)"Record").fields().requiredBytes("some_field").requiredString("another_field").endRecord()).partitionStrategy(new PartitionStrategy.Builder().hash("some_field", 20000).build()).build();
        this.provider = this.newProvider(this.conf);
    }

    @Test
    public void testCreate() {
        Assert.assertFalse((String)"Sanity check", (boolean)this.provider.exists(NAMESPACE, NAME));
        DatasetDescriptor created = this.provider.create(NAMESPACE, NAME, this.testDescriptor);
        Assert.assertNotNull((String)"Descriptor should be returned", (Object)created);
        Assert.assertTrue((String)"Descriptor should exist", (boolean)this.provider.exists(NAMESPACE, NAME));
        Assert.assertEquals((String)"Schema should match", (Object)this.testDescriptor.getSchema(), (Object)created.getSchema());
        Assert.assertEquals((String)"PartitionStrategy should match", (Object)this.testDescriptor.getPartitionStrategy(), (Object)created.getPartitionStrategy());
        Assert.assertEquals((String)"Format should match", (Object)this.testDescriptor.getFormat(), (Object)created.getFormat());
    }

    @Test
    public void testCreateWithLocation() throws URISyntaxException {
        DatasetDescriptor created;
        Assert.assertFalse((String)"Sanity check", (boolean)this.provider.exists(NAMESPACE, NAME));
        String auth = TestMetadataProviders.getDFS().getUri().getAuthority();
        URI requestedLocation = new URI("hdfs://" + auth + "/tmp/data/my_data_set");
        DatasetDescriptor requested = new DatasetDescriptor.Builder(this.testDescriptor).location(requestedLocation).build();
        try {
            created = this.provider.create(NAMESPACE, NAME, requested);
        }
        catch (UnsupportedOperationException ex) {
            return;
        }
        Assert.assertNotNull((String)"Descriptor should be returned", (Object)created);
        Assert.assertTrue((String)"Descriptor should exist", (boolean)this.provider.exists(NAMESPACE, NAME));
        Assert.assertEquals((String)"Requested locations should match", (Object)requestedLocation, (Object)created.getLocation());
    }

    public void ensureCreated() {
        this.testCreate();
        Assert.assertTrue((String)"Sanity check", (boolean)this.provider.exists(NAMESPACE, NAME));
    }

    @Test(expected=DatasetExistsException.class)
    public void testCreateAlreadyExists() {
        this.ensureCreated();
        this.provider.create(NAMESPACE, NAME, this.anotherDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateFailsNullNamespace() {
        this.provider.create(null, NAME, this.testDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateFailsNullName() {
        this.provider.create(NAMESPACE, null, this.testDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateFailsNullDescriptor() {
        this.provider.create(NAMESPACE, NAME, null);
    }

    @Test
    public void testLoad() {
        this.ensureCreated();
        DatasetDescriptor loaded = this.provider.load(NAMESPACE, NAME);
        Assert.assertNotNull((String)"DatasetDescriptor should be returned", (Object)loaded);
        Assert.assertEquals((String)"Schema should match", (Object)this.testDescriptor.getSchema(), (Object)loaded.getSchema());
        Assert.assertEquals((String)"PartitionStrategy should match", (Object)this.testDescriptor.getPartitionStrategy(), (Object)loaded.getPartitionStrategy());
        Assert.assertEquals((String)"Format should match", (Object)this.testDescriptor.getFormat(), (Object)loaded.getFormat());
    }

    @Test(expected=DatasetNotFoundException.class)
    public void testLoadNoDataset() {
        Assert.assertFalse((String)"Sanity check", (boolean)this.provider.exists(NAMESPACE, NAME));
        this.provider.load(NAMESPACE, NAME);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadFailsNullNamespace() {
        this.provider.load(null, NAME);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadFailsNullName() {
        this.provider.load(NAMESPACE, null);
    }

    public void testUpdate() {
        this.ensureCreated();
        DatasetDescriptor saved = this.provider.update(NAMESPACE, NAME, this.anotherDescriptor);
        Assert.assertNotNull((String)"Updated Descriptor should be returned", (Object)saved);
        Assert.assertEquals((String)"Schema should match update", (Object)this.anotherDescriptor.getSchema(), (Object)saved.getSchema());
        Assert.assertEquals((String)"PartitionStrategy should match update", (Object)this.anotherDescriptor.getPartitionStrategy(), (Object)saved.getPartitionStrategy());
        Assert.assertEquals((String)"Format should match update", (Object)this.anotherDescriptor.getFormat(), (Object)saved.getFormat());
    }

    @Test(expected=DatasetNotFoundException.class)
    public void testUpdateFailsNoDataset() {
        this.provider.update(NAMESPACE, NAME, this.testDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testUpdateFailsNullNamespace() {
        this.provider.update(null, NAME, this.testDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testUpdateFailsNullName() {
        this.provider.update(NAMESPACE, null, this.testDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testUpdateFailsNullDescriptor() {
        this.provider.update(NAMESPACE, NAME, null);
    }

    public void testDelete() {
        this.ensureCreated();
        boolean result = this.provider.delete(NAMESPACE, NAME);
        Assert.assertTrue((String)"Delete descriptor should return true", (boolean)result);
        result = this.provider.delete(NAMESPACE, NAME);
        Assert.assertFalse((String)"Delete non-existent descriptor should return false", (boolean)result);
    }

    @Test(expected=NullPointerException.class)
    public void testDeleteFailsNullNamespace() {
        this.provider.delete(null, NAME);
    }

    @Test(expected=NullPointerException.class)
    public void testDeleteFailsNullName() {
        this.provider.delete(NAMESPACE, null);
    }

    @Test
    public void testExists() {
        Assert.assertFalse((boolean)this.provider.exists(NAMESPACE, NAME));
        this.provider.create(NAMESPACE, NAME, this.testDescriptor);
        Assert.assertTrue((boolean)this.provider.exists(NAMESPACE, NAME));
        this.provider.delete(NAMESPACE, NAME);
        Assert.assertFalse((boolean)this.provider.exists(NAMESPACE, NAME));
    }

    @Test(expected=NullPointerException.class)
    public void testExistsNullNamespace() {
        this.provider.exists(null, NAME);
    }

    @Test(expected=NullPointerException.class)
    public void testExistsNullName() {
        this.provider.exists(NAMESPACE, null);
    }

    @Test
    public void testListDatasets() {
        Assert.assertEquals((Object)ImmutableMultiset.of(), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.datasets(NAMESPACE)));
        this.provider.create(NAMESPACE, "test1", this.testDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.datasets(NAMESPACE)));
        this.provider.create(NAMESPACE, "test2", this.testDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1", (Object)"test2"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.datasets(NAMESPACE)));
        this.provider.create(NAMESPACE, "test3", this.testDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1", (Object)"test2", (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.datasets(NAMESPACE)));
        this.provider.delete(NAMESPACE, "test2");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1", (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.datasets(NAMESPACE)));
        this.provider.delete(NAMESPACE, "test3");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.datasets(NAMESPACE)));
        this.provider.delete(NAMESPACE, "test1");
        Assert.assertEquals((Object)ImmutableMultiset.of(), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.datasets(NAMESPACE)));
    }

    @Test
    public void testListNamespaces() {
        Assert.assertEquals((Object)ImmutableMultiset.of(), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.namespaces()));
        this.provider.create("test1", "d1", this.testDescriptor);
        this.provider.create("test1", "d2", this.anotherDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.namespaces()));
        this.provider.create("test2", "d1", this.testDescriptor);
        this.provider.create("test2", "d2", this.anotherDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1", (Object)"test2"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.namespaces()));
        this.provider.create("test3", "d1", this.testDescriptor);
        this.provider.create("test3", "d2", this.anotherDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1", (Object)"test2", (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.namespaces()));
        this.provider.delete("test2", "d2");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1", (Object)"test2", (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.namespaces()));
        this.provider.delete("test2", "d1");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1", (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.namespaces()));
        this.provider.delete("test3", "d2");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1", (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.namespaces()));
        this.provider.delete("test3", "d1");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.namespaces()));
        this.provider.delete("test1", "d1");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)"test1"), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.namespaces()));
        this.provider.delete("test1", "d2");
        Assert.assertEquals((Object)ImmutableMultiset.of(), (Object)ImmutableMultiset.copyOf((Iterable)this.provider.namespaces()));
    }

    @Test
    public void testCustomProperties() {
        String propName = "my.custom.property";
        String propValue = "string";
        DatasetDescriptor descriptorWithProp = new DatasetDescriptor.Builder(this.testDescriptor).property("my.custom.property", "string").build();
        DatasetDescriptor created = this.provider.create(NAMESPACE, NAME, descriptorWithProp);
        Assert.assertTrue((String)"Should have custom property", (boolean)created.hasProperty("my.custom.property"));
        Assert.assertEquals((String)"Should have correct custom property value", (Object)"string", (Object)created.getProperty("my.custom.property"));
        Assert.assertTrue((String)"List should contain property name", (boolean)created.listProperties().contains("my.custom.property"));
        DatasetDescriptor loaded = this.provider.load(NAMESPACE, NAME);
        Assert.assertTrue((String)"Should have custom property", (boolean)loaded.hasProperty("my.custom.property"));
        Assert.assertEquals((String)"Should have correct custom property value", (Object)"string", (Object)loaded.getProperty("my.custom.property"));
        Assert.assertTrue((String)"List should contain property name", (boolean)created.listProperties().contains("my.custom.property"));
    }

    @Test
    public void testLargeSchema() {
        Assume.assumeTrue((boolean)this.distributed);
        Assert.assertFalse((String)"Sanity check", (boolean)this.provider.exists(NAMESPACE, "large_schema_test"));
        SchemaBuilder.FieldAssembler fields = SchemaBuilder.record((String)"Event").fields();
        for (int i = 0; i < 1000; ++i) {
            fields.requiredString("field_" + i);
        }
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().format(Formats.AVRO).schema((Schema)fields.endRecord()).build();
        DatasetDescriptor created = this.provider.create(NAMESPACE, "large_schema_test", descriptor);
        Assert.assertEquals((String)"Large schemas should match", (Object)descriptor.getSchema(), (Object)created.getSchema());
    }
}

