/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.Marker;
import org.kitesdk.data.spi.MarkerComparator;
import org.kitesdk.data.spi.MarkerRange;

public class TestMarkerRange {
    private static Marker OCT_12;
    private static Marker OCT_15;
    private static Marker SEPT_30;
    private static Marker NOV_1;
    private static MarkerComparator comparator;

    @BeforeClass
    public static void setup() {
        OCT_12 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)10).add("day", (Object)12).build();
        OCT_15 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)10).add("day", (Object)15).build();
        SEPT_30 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)30).build();
        NOV_1 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)1).build();
        PartitionStrategy strategy = new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build();
        comparator = new MarkerComparator(strategy);
    }

    @Test
    public void testIntersection() {
        MarkerRange unbounded = new MarkerRange(comparator);
        MarkerRange unboundedToNov1 = new MarkerRange(comparator).to(NOV_1);
        MarkerRange oct12ToOct15 = new MarkerRange(comparator).from(OCT_12).to(OCT_15);
        final MarkerRange sept30ToOct15 = new MarkerRange(comparator).from(SEPT_30).to(OCT_15);
        MarkerRange oct12ToNov1 = new MarkerRange(comparator).from(OCT_12).to(NOV_1);
        MarkerRange sept30ToNov1 = new MarkerRange(comparator).from(SEPT_30).to(NOV_1);
        MarkerRange sept30ToUnbounded = new MarkerRange(comparator).from(SEPT_30);
        final MarkerRange nov1ToUnbounded = new MarkerRange(comparator).from(NOV_1);
        Assert.assertEquals((Object)unbounded, (Object)unbounded.intersection(unbounded));
        Assert.assertEquals((Object)oct12ToOct15, (Object)oct12ToOct15.intersection(oct12ToOct15));
        Assert.assertEquals((Object)unboundedToNov1, (Object)unboundedToNov1.intersection(unboundedToNov1));
        Assert.assertEquals((Object)sept30ToUnbounded, (Object)sept30ToUnbounded.intersection(sept30ToUnbounded));
        Assert.assertEquals((Object)oct12ToOct15, (Object)unbounded.intersection(oct12ToOct15));
        Assert.assertEquals((Object)oct12ToOct15, (Object)oct12ToOct15.intersection(unbounded));
        Assert.assertEquals((Object)oct12ToOct15, (Object)unboundedToNov1.intersection(oct12ToOct15));
        Assert.assertEquals((Object)oct12ToOct15, (Object)sept30ToUnbounded.intersection(oct12ToOct15));
        Assert.assertEquals((Object)nov1ToUnbounded, (Object)nov1ToUnbounded.intersection(sept30ToUnbounded));
        Assert.assertEquals((Object)nov1ToUnbounded, (Object)sept30ToUnbounded.intersection(nov1ToUnbounded));
        Assert.assertEquals((Object)oct12ToOct15, (Object)sept30ToNov1.intersection(oct12ToOct15));
        Assert.assertEquals((Object)oct12ToOct15, (Object)oct12ToOct15.intersection(sept30ToNov1));
        Assert.assertEquals((Object)oct12ToOct15, (Object)sept30ToOct15.intersection(oct12ToNov1));
        Assert.assertEquals((Object)oct12ToOct15, (Object)oct12ToNov1.intersection(sept30ToOct15));
        TestHelpers.assertThrows("Can't find intersection when no overlap.", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                sept30ToOct15.intersection(nov1ToUnbounded);
            }
        });
        TestHelpers.assertThrows("Can't find intersection when no overlap.", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                nov1ToUnbounded.intersection(sept30ToOct15);
            }
        });
    }

    @Test
    public void testSpan() {
        MarkerRange unbounded = new MarkerRange(comparator);
        MarkerRange unboundedToNov1 = new MarkerRange(comparator).to(NOV_1);
        MarkerRange oct12ToOct15 = new MarkerRange(comparator).from(OCT_12).to(OCT_15);
        MarkerRange sept30ToOct15 = new MarkerRange(comparator).from(SEPT_30).to(OCT_15);
        MarkerRange oct12ToNov1 = new MarkerRange(comparator).from(OCT_12).to(NOV_1);
        MarkerRange sept30ToNov1 = new MarkerRange(comparator).from(SEPT_30).to(NOV_1);
        MarkerRange sept30ToUnbounded = new MarkerRange(comparator).from(SEPT_30);
        MarkerRange nov1ToUnbounded = new MarkerRange(comparator).from(NOV_1);
        Assert.assertEquals((Object)unbounded, (Object)unbounded.span(unbounded));
        Assert.assertEquals((Object)oct12ToOct15, (Object)oct12ToOct15.span(oct12ToOct15));
        Assert.assertEquals((Object)unboundedToNov1, (Object)unboundedToNov1.span(unboundedToNov1));
        Assert.assertEquals((Object)sept30ToUnbounded, (Object)sept30ToUnbounded.span(sept30ToUnbounded));
        Assert.assertEquals((Object)unbounded, (Object)unbounded.span(oct12ToOct15));
        Assert.assertEquals((Object)unbounded, (Object)oct12ToOct15.span(unbounded));
        Assert.assertEquals((Object)unboundedToNov1, (Object)unboundedToNov1.span(oct12ToOct15));
        Assert.assertEquals((Object)sept30ToUnbounded, (Object)sept30ToUnbounded.span(oct12ToOct15));
        Assert.assertEquals((Object)sept30ToUnbounded, (Object)nov1ToUnbounded.span(sept30ToUnbounded));
        Assert.assertEquals((Object)sept30ToUnbounded, (Object)sept30ToUnbounded.span(nov1ToUnbounded));
        Assert.assertEquals((Object)sept30ToNov1, (Object)sept30ToNov1.span(oct12ToOct15));
        Assert.assertEquals((Object)sept30ToNov1, (Object)oct12ToOct15.span(sept30ToNov1));
        Assert.assertEquals((Object)sept30ToNov1, (Object)sept30ToOct15.span(oct12ToNov1));
        Assert.assertEquals((Object)sept30ToNov1, (Object)oct12ToNov1.span(sept30ToOct15));
        Assert.assertEquals((Object)sept30ToUnbounded, (Object)sept30ToOct15.span(nov1ToUnbounded));
        Assert.assertEquals((Object)sept30ToUnbounded, (Object)nov1ToUnbounded.span(sept30ToOct15));
    }

    @Test
    public void testComplement() {
        final MarkerRange unbounded = new MarkerRange(comparator);
        MarkerRange unboundedToNov1 = new MarkerRange(comparator).to(NOV_1);
        MarkerRange oct12ToOct15 = new MarkerRange(comparator).from(OCT_12).to(OCT_15);
        MarkerRange afterNov1ToUnbounded = new MarkerRange(comparator).fromAfter(NOV_1);
        TestHelpers.assertThrows("Can't find complement of unbounded range.", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                unbounded.complement();
            }
        });
        Assert.assertEquals((Object)afterNov1ToUnbounded, (Object)unboundedToNov1.complement());
        Assert.assertEquals((Object)unboundedToNov1, (Object)afterNov1ToUnbounded.complement());
        Assert.assertEquals((Object)unbounded, (Object)oct12ToOct15.complement());
    }
}

