/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.Marker;
import org.kitesdk.data.spi.MarkerComparator;
import org.kitesdk.data.spi.MarkerRange;

public class TestMarkerBoundary {
    private static Marker YEAR;
    private static Marker OCT;
    private static Marker OCT_12;
    private static Marker SEPT;
    private static Marker SEPT_30;
    private static Marker NOV;
    private static Marker NOV_1;
    private static MarkerComparator comparator;

    @BeforeClass
    public static void setup() {
        YEAR = new Marker.Builder("year", (Object)2013).build();
        OCT = new Marker.Builder().add("year", (Object)2013).add("month", (Object)10).build();
        OCT_12 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)10).add("day", (Object)12).build();
        SEPT = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).build();
        SEPT_30 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)30).build();
        NOV = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).build();
        NOV_1 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)1).build();
        PartitionStrategy strategy = new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build();
        comparator = new MarkerComparator(strategy);
    }

    @Test
    public void testInclusiveLowerBound() {
        MarkerRange.Boundary bound = new MarkerRange.Boundary(comparator, OCT, true);
        Assert.assertFalse((boolean)bound.isLessThan(YEAR));
        Assert.assertFalse((boolean)bound.isLessThan(SEPT));
        Assert.assertFalse((boolean)bound.isLessThan(SEPT_30));
        Assert.assertTrue((boolean)bound.isLessThan(OCT_12));
        Assert.assertTrue((boolean)bound.isLessThan(OCT));
        Assert.assertTrue((boolean)bound.isLessThan(NOV_1));
        Assert.assertTrue((boolean)bound.isLessThan(NOV));
    }

    @Test
    public void testInclusiveUpperBound() {
        MarkerRange.Boundary bound = new MarkerRange.Boundary(comparator, OCT, true);
        Assert.assertFalse((boolean)bound.isGreaterThan(YEAR));
        Assert.assertTrue((boolean)bound.isGreaterThan(SEPT));
        Assert.assertTrue((boolean)bound.isGreaterThan(SEPT_30));
        Assert.assertTrue((boolean)bound.isGreaterThan(OCT_12));
        Assert.assertTrue((boolean)bound.isGreaterThan(OCT));
        Assert.assertFalse((boolean)bound.isGreaterThan(NOV_1));
        Assert.assertFalse((boolean)bound.isGreaterThan(NOV));
    }

    @Test
    public void testExclusiveLowerBound() {
        MarkerRange.Boundary bound = new MarkerRange.Boundary(comparator, OCT, false);
        Assert.assertFalse((boolean)bound.isLessThan(YEAR));
        Assert.assertFalse((boolean)bound.isLessThan(SEPT));
        Assert.assertFalse((boolean)bound.isLessThan(SEPT_30));
        Assert.assertFalse((boolean)bound.isLessThan(OCT_12));
        Assert.assertFalse((boolean)bound.isLessThan(OCT));
        Assert.assertTrue((boolean)bound.isLessThan(NOV_1));
        Assert.assertTrue((boolean)bound.isLessThan(NOV));
    }

    @Test
    public void testExclusiveUpperBound() {
        MarkerRange.Boundary bound = new MarkerRange.Boundary(comparator, OCT, false);
        Assert.assertFalse((boolean)bound.isGreaterThan(YEAR));
        Assert.assertTrue((boolean)bound.isGreaterThan(SEPT));
        Assert.assertTrue((boolean)bound.isGreaterThan(SEPT_30));
        Assert.assertFalse((boolean)bound.isGreaterThan(OCT_12));
        Assert.assertFalse((boolean)bound.isGreaterThan(OCT));
        Assert.assertFalse((boolean)bound.isGreaterThan(NOV_1));
        Assert.assertFalse((boolean)bound.isGreaterThan(NOV));
    }

    @Test
    public void testNegativeInfinity() {
        MarkerRange.Boundary bound = MarkerRange.Boundary.NEGATIVE_INFINITY;
        Assert.assertTrue((boolean)bound.isLessThan(YEAR));
        Assert.assertTrue((boolean)bound.isLessThan(SEPT));
        Assert.assertTrue((boolean)bound.isLessThan(SEPT_30));
        Assert.assertTrue((boolean)bound.isLessThan(OCT_12));
        Assert.assertTrue((boolean)bound.isLessThan(OCT));
        Assert.assertTrue((boolean)bound.isLessThan(NOV_1));
        Assert.assertTrue((boolean)bound.isLessThan(NOV));
    }

    @Test
    public void testPositiveInfinity() {
        MarkerRange.Boundary bound = MarkerRange.Boundary.POSITIVE_INFINITY;
        Assert.assertTrue((boolean)bound.isGreaterThan(YEAR));
        Assert.assertTrue((boolean)bound.isGreaterThan(SEPT));
        Assert.assertTrue((boolean)bound.isGreaterThan(SEPT_30));
        Assert.assertTrue((boolean)bound.isGreaterThan(OCT_12));
        Assert.assertTrue((boolean)bound.isGreaterThan(OCT));
        Assert.assertTrue((boolean)bound.isGreaterThan(NOV_1));
        Assert.assertTrue((boolean)bound.isGreaterThan(NOV));
    }
}

