/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.Marker;
import org.kitesdk.data.spi.MarkerComparator;
import org.kitesdk.data.spi.MarkerRange;

public class TestKeyRangeIterable {
    public static final Constraints emptyConstraints = new Constraints((Schema)SchemaBuilder.record((String)"Event").fields().requiredString("id").requiredLong("timestamp").optionalString("component").optionalInt("number").optionalInt("number2").endRecord());
    public static final PartitionStrategy id = new PartitionStrategy.Builder().identity("component", "id_component").build();
    public static final MarkerComparator idCmp = new MarkerComparator(id);
    public static final PartitionStrategy hash = new PartitionStrategy.Builder().hash("id", 64).identity("id").build();
    public static final MarkerComparator hashCmp = new MarkerComparator(hash);
    public static final PartitionStrategy num = new PartitionStrategy.Builder().identity("number", "id_number").build();
    public static final MarkerComparator numCmp = new MarkerComparator(num);
    public static final PartitionStrategy num2 = new PartitionStrategy.Builder().identity("number", "id_number").identity("number2", "id_number2").build();
    public static final MarkerComparator num2Cmp = new MarkerComparator(num2);
    public static final PartitionStrategy time = new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build();
    public static final MarkerComparator timeCmp = new MarkerComparator(time);
    public static final PartitionStrategy strategy = new PartitionStrategy.Builder().hash("id", "id_hash", 64).year("timestamp").month("timestamp").day("timestamp").identity("component", "id_component").identity("id").build();
    public static final MarkerComparator cmp = new MarkerComparator(strategy);

    @Test
    public void testUnbounded() {
        Constraints c = emptyConstraints.partitionedBy(id);
        TestKeyRangeIterable.assertIterableEquals(Sets.newHashSet((Object[])new MarkerRange[]{new MarkerRange(idCmp)}), c.toKeyRanges());
    }

    @Test
    public void testSingleSet() {
        Constraints c = emptyConstraints.partitionedBy(id).with("component", new Object[]{"com.company.Main"});
        Marker main = new Marker.Builder("id_component", (Object)"com.company.Main").build();
        MarkerRange actual = (MarkerRange)Iterables.getOnlyElement((Iterable)c.toKeyRanges());
        Assert.assertEquals((Object)main, (Object)actual.getStart().getBound());
        Assert.assertEquals((Object)main, (Object)actual.getEnd().getBound());
        Assert.assertEquals((Object)new MarkerRange(idCmp).of(main), (Object)actual);
        c = emptyConstraints.partitionedBy(id).with("component", new Object[]{"com.company.Main", "com.company.SomeClass"});
        Marker sc = new Marker.Builder("id_component", (Object)"com.company.SomeClass").build();
        TestKeyRangeIterable.assertIterableEquals(Sets.newHashSet((Object[])new MarkerRange[]{new MarkerRange(idCmp).of(main), new MarkerRange(idCmp).of(sc)}), c.toKeyRanges());
    }

    @Test
    public void testGroupSet() {
        String[] ids = new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString()};
        FieldPartitioner hashFunc = (FieldPartitioner)Accessor.getDefault().getFieldPartitioners(hash).get(0);
        Constraints c = emptyConstraints.partitionedBy(hash).with("id", new Object[]{ids[0]});
        Marker marker0 = new Marker.Builder().add("id_hash", hashFunc.apply((Object)ids[0])).add("id_copy", (Object)ids[0]).build();
        MarkerRange actual = (MarkerRange)Iterables.getOnlyElement((Iterable)c.toKeyRanges());
        Assert.assertEquals((Object)marker0, (Object)actual.getStart().getBound());
        Assert.assertEquals((Object)marker0, (Object)actual.getEnd().getBound());
        c = emptyConstraints.partitionedBy(hash).with("id", (Object[])ids);
        Marker marker1 = new Marker.Builder().add("id_hash", hashFunc.apply((Object)ids[1])).add("id_copy", (Object)ids[1]).build();
        TestKeyRangeIterable.assertIterableEquals(Sets.newHashSet((Object[])new MarkerRange[]{new MarkerRange(hashCmp).of(marker0), new MarkerRange(hashCmp).of(marker1)}), c.toKeyRanges());
    }

    @Test
    public void testSingleRange() {
        Constraints c = emptyConstraints.partitionedBy(num2).from("number", (Comparable)Integer.valueOf(5)).toBefore("number", (Comparable)Integer.valueOf(18)).to("number2", (Comparable)Integer.valueOf(9));
        Marker start = new Marker.Builder("id_number", (Object)5).build();
        Marker stop = new Marker.Builder().add("id_number", (Object)18).add("id_number2", (Object)9).build();
        Assert.assertEquals((Object)new MarkerRange(num2Cmp).from(start).to(stop), (Object)Iterables.getOnlyElement((Iterable)c.toKeyRanges()));
    }

    @Test
    public void testHashRange() {
        Constraints c = emptyConstraints.partitionedBy(hash).from("id", (Comparable)((Object)"0000")).toBefore("id", (Comparable)((Object)"0001"));
        Marker start = new Marker.Builder("id_copy", (Object)"0000").build();
        Marker stop = new Marker.Builder("id_copy", (Object)"0001").build();
        Assert.assertEquals((Object)new MarkerRange(hashCmp).from(start).to(stop), (Object)Iterables.getOnlyElement((Iterable)c.toKeyRanges()));
    }

    @Test
    public void testGroupRange() {
        Constraints c = emptyConstraints.partitionedBy(num).from("number", (Comparable)Integer.valueOf(5)).toBefore("number", (Comparable)Integer.valueOf(18));
        Marker start = new Marker.Builder("id_number", (Object)5).build();
        Marker stop = new Marker.Builder("id_number", (Object)18).build();
        Assert.assertEquals((Object)new MarkerRange(numCmp).from(start).to(stop), (Object)Iterables.getOnlyElement((Iterable)c.toKeyRanges()));
    }

    @Test
    public void testTimeSet() {
        Long[] timestamps = new Long[]{1379020547042L, 1381612547042L, 1384204547042L};
        Constraints c = emptyConstraints.partitionedBy(time).with("timestamp", (Object[])timestamps);
        Marker sep = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)12).build();
        Marker oct = new Marker.Builder().add("year", (Object)2013).add("month", (Object)10).add("day", (Object)12).build();
        Marker nov = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)11).build();
        TestKeyRangeIterable.assertIterableEquals(Sets.newHashSet((Object[])new MarkerRange[]{new MarkerRange(timeCmp).of(sep), new MarkerRange(timeCmp).of(oct), new MarkerRange(timeCmp).of(nov)}), c.toKeyRanges());
    }

    @Test
    public void testTimeRange() {
        Long[] timestamps = new Long[]{1379020547042L, 1381612547042L, 1384204547042L};
        Constraints c = emptyConstraints.partitionedBy(time).from("timestamp", (Comparable)timestamps[0]).to("timestamp", (Comparable)timestamps[2]);
        Marker sep = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)12).build();
        Marker nov = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)11).build();
        Assert.assertEquals((Object)new MarkerRange(timeCmp).from(sep).to(nov), (Object)Iterables.getOnlyElement((Iterable)c.toKeyRanges()));
    }

    @Test
    public void testCombined() {
        Long[] timestamps = new Long[]{1379020547042L, 1384204547042L};
        String[] ids = new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString()};
        FieldPartitioner hashFunc = (FieldPartitioner)Accessor.getDefault().getFieldPartitioners(hash).get(0);
        Constraints c = emptyConstraints.partitionedBy(strategy).from("timestamp", (Comparable)timestamps[0]).to("timestamp", (Comparable)timestamps[1]).with("id", (Object[])ids);
        Marker sep0 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)12).add("id_hash", hashFunc.apply((Object)ids[0])).add("id_copy", (Object)ids[0]).build();
        Marker nov0 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)11).add("id_hash", hashFunc.apply((Object)ids[0])).add("id_copy", (Object)ids[0]).build();
        Marker sep1 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)12).add("id_hash", hashFunc.apply((Object)ids[1])).add("id_copy", (Object)ids[1]).build();
        Marker nov1 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)11).add("id_hash", hashFunc.apply((Object)ids[1])).add("id_copy", (Object)ids[1]).build();
        TestKeyRangeIterable.assertIterableEquals(Sets.newHashSet((Object[])new MarkerRange[]{new MarkerRange(cmp).from(sep0).to(nov0), new MarkerRange(cmp).from(sep1).to(nov1)}), c.toKeyRanges());
        Marker sep2 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)12).add("id_hash", hashFunc.apply((Object)ids[0])).add("id_copy", (Object)ids[0]).add("id_component", (Object)"com.company.Main").build();
        Marker nov2 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)11).add("id_hash", hashFunc.apply((Object)ids[0])).add("id_copy", (Object)ids[0]).add("id_component", (Object)"com.company.Main").build();
        Marker sep3 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)12).add("id_hash", hashFunc.apply((Object)ids[1])).add("id_copy", (Object)ids[1]).add("id_component", (Object)"com.company.Main").build();
        Marker nov3 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)11).add("id_hash", hashFunc.apply((Object)ids[1])).add("id_copy", (Object)ids[1]).add("id_component", (Object)"com.company.Main").build();
        Marker sep4 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)12).add("id_hash", hashFunc.apply((Object)ids[0])).add("id_copy", (Object)ids[0]).add("id_component", (Object)"com.company.SomeClass").build();
        Marker nov4 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)11).add("id_hash", hashFunc.apply((Object)ids[0])).add("id_copy", (Object)ids[0]).add("id_component", (Object)"com.company.SomeClass").build();
        Marker sep5 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)12).add("id_hash", hashFunc.apply((Object)ids[1])).add("id_copy", (Object)ids[1]).add("id_component", (Object)"com.company.SomeClass").build();
        Marker nov5 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)11).add("id_hash", hashFunc.apply((Object)ids[1])).add("id_copy", (Object)ids[1]).add("id_component", (Object)"com.company.SomeClass").build();
        TestKeyRangeIterable.assertIterableEquals(Sets.newHashSet((Object[])new MarkerRange[]{new MarkerRange(cmp).from(sep2).to(nov2), new MarkerRange(cmp).from(sep3).to(nov3), new MarkerRange(cmp).from(sep4).to(nov4), new MarkerRange(cmp).from(sep5).to(nov5)}), c.with("component", new Object[]{"com.company.Main", "com.company.SomeClass"}).toKeyRanges());
    }

    @Test
    public void testOneSidedRange() {
        Constraints c = emptyConstraints.partitionedBy(time).from("timestamp", (Comparable)Long.valueOf(1379020547042L));
        Marker sep = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)12).build();
        TestKeyRangeIterable.assertIterableEquals(Sets.newHashSet((Object[])new MarkerRange[]{new MarkerRange(timeCmp).from(sep)}), c.toKeyRanges());
    }

    public static <T> void assertIterableEquals(Iterable<T> expected, Iterable<T> actualIterable) {
        HashSet expectedSet = Sets.newHashSet(expected);
        for (T actual : actualIterable) {
            Assert.assertTrue((String)("Unexpected record: " + actual + " expected: " + expectedSet), (boolean)expectedSet.remove(actual));
        }
        Assert.assertEquals((String)("Not all expected records were present: " + expectedSet), (long)0L, (long)expectedSet.size());
    }
}

