/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.spi.JsonUtil;
import org.kitesdk.data.spi.SchemaUtil;

public class TestJsonUtil {
    @Test
    public void testConvertToAvroNull() {
        Assert.assertNull((String)"Avro null", (Object)JsonUtil.convertToAvro((GenericData)GenericData.get(), null, (Schema)Schema.create((Schema.Type)Schema.Type.NULL)));
        Assert.assertNull((String)"Avro nullable long", (Object)JsonUtil.convertToAvro((GenericData)GenericData.get(), null, (Schema)((Schema)SchemaBuilder.nullable().longType())));
        Assert.assertNull((String)"Avro long", (Object)JsonUtil.convertToAvro((GenericData)GenericData.get(), null, (Schema)((Schema)SchemaBuilder.builder().longType())));
    }

    @Test
    public void testSchemaInferencePrimitiveTypes() throws Exception {
        Schema recordSchema = (Schema)SchemaBuilder.record((String)"Test").fields().requiredBoolean("aBool").requiredString("aString").requiredInt("anInt").requiredLong("aLong").requiredDouble("aDouble").requiredString("bytes").endRecord();
        String encoded = BinaryNode.valueOf((byte[])"soap".getBytes("utf-8")).toString();
        String jsonSample = "{\"aBool\": false,\"aString\": \"triangle\",\"anInt\": 34,\"aLong\": 1420502567564,\"aDouble\": 1420502567564.9,\"bytes\": " + encoded + "}";
        JsonNode datum = JsonUtil.parse((String)jsonSample);
        Assert.assertEquals((String)"Should produce expected schema", (Object)recordSchema, (Object)JsonUtil.inferSchema((JsonNode)datum, (String)"Test"));
        GenericData.Record expected = new GenericData.Record(recordSchema);
        expected.put("aBool", (Object)false);
        expected.put("aString", (Object)"triangle");
        expected.put("anInt", (Object)34);
        expected.put("aLong", (Object)1420502567564L);
        expected.put("aDouble", (Object)1.4205025675649E12);
        expected.put("bytes", (Object)encoded.substring(1, encoded.length() - 1));
        Assert.assertEquals((String)"Should convert to record", (Object)expected, (Object)TestJsonUtil.convertGeneric(datum, recordSchema));
    }

    @Test
    public void testSchemaInferencePrimitiveArray() throws Exception {
        Schema recordSchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"Test").fields().requiredString("aString").name("anArray").type().array().items().intType()).noDefault().endRecord();
        String jsonSample = "{\"aString\": \"triangle\",\"anArray\": [ 1, 2, 3, 4 ]}";
        JsonNode datum = JsonUtil.parse((String)jsonSample);
        Assert.assertEquals((String)"Should produce expected schema", (Object)recordSchema, (Object)JsonUtil.inferSchema((JsonNode)datum, (String)"Test"));
        GenericData.Record expected = new GenericData.Record(recordSchema);
        expected.put("aString", (Object)"triangle");
        expected.put("anArray", (Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4}));
        Assert.assertEquals((String)"Should convert to record", (Object)expected, (Object)TestJsonUtil.convertGeneric(datum, recordSchema));
    }

    @Test
    public void testSchemaInferenceNullablePrimitiveArray() throws Exception {
        Schema recordSchema = (Schema)((SchemaBuilder.ArrayDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"Test").fields().requiredString("aString").name("anArray").type().array().items().unionOf().nullType()).and().intType()).endUnion()).noDefault().endRecord();
        String jsonSample = "{\"aString\": \"triangle\",\"anArray\": [ null, 1, 2, 3, 4 ]}";
        JsonNode datum = JsonUtil.parse((String)jsonSample);
        Assert.assertEquals((String)"Should produce expected schema", (Object)recordSchema, (Object)JsonUtil.inferSchema((JsonNode)datum, (String)"Test"));
        GenericData.Record expected = new GenericData.Record(recordSchema);
        expected.put("aString", (Object)"triangle");
        expected.put("anArray", (Object)Lists.newArrayList((Object[])new Integer[]{null, 1, 2, 3, 4}));
        Assert.assertEquals((String)"Should convert to record", (Object)expected, (Object)TestJsonUtil.convertGeneric(datum, recordSchema));
    }

    @Test
    public void testSchemaInferenceMultipleTypes() throws Exception {
        Schema recordSchema = (Schema)((SchemaBuilder.ArrayDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"Test").fields().requiredString("aString").name("anArray").type().array().items().unionOf().nullType()).and().intType()).and().stringType()).endUnion()).noDefault().endRecord();
        String jsonSample = "{\"aString\": \"triangle\",\"anArray\": [ null, 1, 2, 3, \"winter\" ]}";
        JsonNode datum = JsonUtil.parse((String)jsonSample);
        Assert.assertEquals((String)"Should produce expected schema", (Object)recordSchema, (Object)JsonUtil.inferSchema((JsonNode)datum, (String)"Test"));
        GenericData.Record expected = new GenericData.Record(recordSchema);
        expected.put("aString", (Object)"triangle");
        expected.put("anArray", (Object)Lists.newArrayList((Object[])new Serializable[]{null, Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), "winter"}));
        Assert.assertEquals((String)"Should convert to record", (Object)expected, (Object)TestJsonUtil.convertGeneric(datum, recordSchema));
    }

    @Test
    public void testSchemaInferenceRecord() throws Exception {
        Schema recordSchema = (Schema)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"Test").fields().requiredString("aString").name("aRecord").type().record("aRecord").fields().requiredString("left").requiredString("right").endRecord()).noDefault().endRecord();
        String jsonSample = "{\"aString\": \"triangle\",\"aRecord\": { \"left\": \"timid\", \"right\": \"dictionary\" }}";
        JsonNode datum = JsonUtil.parse((String)jsonSample);
        Assert.assertEquals((String)"Should produce expected schema", (Object)recordSchema, (Object)JsonUtil.inferSchema((JsonNode)datum, (String)"Test"));
        GenericData.Record aRecord = new GenericData.Record(recordSchema.getField("aRecord").schema());
        aRecord.put("left", (Object)"timid");
        aRecord.put("right", (Object)"dictionary");
        GenericData.Record expected = new GenericData.Record(recordSchema);
        expected.put("aString", (Object)"triangle");
        expected.put("aRecord", (Object)aRecord);
        Assert.assertEquals((String)"Should convert to record", (Object)expected, (Object)TestJsonUtil.convertGeneric(datum, recordSchema));
    }

    @Test
    public void testSchemaInferenceMap() throws Exception {
        Schema recordSchema = (Schema)((SchemaBuilder.MapDefault)SchemaBuilder.record((String)"Test").fields().requiredString("aString").name("aMap").type().map().values().stringType()).noDefault().endRecord();
        String jsonSample = "{\"aString\": \"triangle\",\"aMap\": { \"left\": \"timid\", \"right\": \"dictionary\" }}";
        JsonNode datum = JsonUtil.parse((String)jsonSample);
        Assert.assertEquals((String)"Should produce expected schema", (Object)recordSchema, (Object)JsonUtil.inferSchemaWithMaps((JsonNode)datum, (String)"Test"));
        LinkedHashMap aMap = Maps.newLinkedHashMap();
        aMap.put("left", "timid");
        aMap.put("right", "dictionary");
        GenericData.Record expected = new GenericData.Record(recordSchema);
        expected.put("aString", (Object)"triangle");
        expected.put("aMap", (Object)aMap);
        Assert.assertEquals((String)"Should convert to record", (Object)expected, (Object)TestJsonUtil.convertGeneric(datum, recordSchema));
    }

    @Test
    public void testSchemaInferenceNullableMap() throws Exception {
        Schema recordSchema = (Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"Test").fields().requiredString("aString").name("aMap").type().map().values().unionOf().nullType()).and().stringType()).endUnion()).noDefault().endRecord();
        String jsonSample = "{\"aString\": \"triangle\",\"aMap\": { \"left\": null, \"right\": \"dictionary\" }}";
        JsonNode datum = JsonUtil.parse((String)jsonSample);
        Assert.assertEquals((String)"Should produce expected schema", (Object)recordSchema, (Object)JsonUtil.inferSchemaWithMaps((JsonNode)datum, (String)"Test"));
        LinkedHashMap aMap = Maps.newLinkedHashMap();
        aMap.put("left", null);
        aMap.put("right", "dictionary");
        GenericData.Record expected = new GenericData.Record(recordSchema);
        expected.put("aString", (Object)"triangle");
        expected.put("aMap", (Object)aMap);
        Assert.assertEquals((String)"Should convert to record", (Object)expected, (Object)TestJsonUtil.convertGeneric(datum, recordSchema));
    }

    @Test
    public void testJsonStream() throws Exception {
        String jsonSample = "{\"id\": 1}\n{\"id\": 2}";
        Iterator iter = JsonUtil.parser((InputStream)new ByteArrayInputStream(jsonSample.getBytes("utf-8")));
        Assert.assertEquals((String)"Should produce 2 records", (long)2L, (long)Lists.newArrayList((Iterator)iter).size());
        jsonSample = "{\"id\": 1}{\"id\": 2}";
        iter = JsonUtil.parser((InputStream)new ByteArrayInputStream(jsonSample.getBytes("utf-8")));
        Assert.assertEquals((String)"Should produce 2 records", (long)2L, (long)Lists.newArrayList((Iterator)iter).size());
        jsonSample = "{\"id\": 1} {\"id\": 2}";
        iter = JsonUtil.parser((InputStream)new ByteArrayInputStream(jsonSample.getBytes("utf-8")));
        Assert.assertEquals((String)"Should produce 2 records", (long)2L, (long)Lists.newArrayList((Iterator)iter).size());
        jsonSample = "{\"id\": 1}\t{\"id\": 2}";
        iter = JsonUtil.parser((InputStream)new ByteArrayInputStream(jsonSample.getBytes("utf-8")));
        Assert.assertEquals((String)"Should produce 2 records", (long)2L, (long)Lists.newArrayList((Iterator)iter).size());
    }

    @Test
    public void testSimpleSchemaMerge() throws Exception {
        String jsonSample = "{\"id\": 1}\n{\"id\": 2}";
        Schema schema = (Schema)SchemaBuilder.record((String)"Test").fields().requiredInt("id").endRecord();
        Assert.assertEquals((String)"Should match expected schema", (Object)schema, (Object)TestJsonUtil.mergeSchemas(jsonSample));
    }

    @Test
    public void testSchemaMergeRecords() throws Exception {
        String jsonSample = "{\"id\": 1, \"record\": {\"jam\": -6.5}}{\"id\": 2, \"record\": {\"heist\": 10.0}}";
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"Test").fields().requiredInt("id").name("record").type().record("record").fields().optionalDouble("jam").optionalDouble("heist").endRecord()).noDefault().endRecord();
        Assert.assertEquals((String)"Should match expected schema", (Object)schema, (Object)TestJsonUtil.mergeSchemas(jsonSample));
    }

    @Test
    public void testSchemaMergeUnionPrimitiveTypes() throws Exception {
        String jsonSample = "{\"id\": 1}\n{\"id\": 2}{\"id\": \"socket\"}";
        Schema schema = (Schema)((SchemaBuilder.IntDefault)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"Test").fields().name("id").type().unionOf().intType().and().stringType()).endUnion()).noDefault().endRecord();
        Assert.assertEquals((String)"Should match expected schema", (Object)schema, (Object)TestJsonUtil.mergeSchemas(jsonSample));
    }

    @Test
    public void testSchemaMergeAddsNullableFields() throws Exception {
        String jsonSample = "{\"id\": 1}\n{\"id\": 2}{\"id\": \"socket\", \"sparse\": \"tenfold\"}";
        Schema schema = (Schema)((SchemaBuilder.IntDefault)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"Test").fields().name("id").type().unionOf().intType().and().stringType()).endUnion()).noDefault().optionalString("sparse").endRecord();
        Assert.assertEquals((String)"Should match expected schema", (Object)schema, (Object)TestJsonUtil.mergeSchemas(jsonSample));
    }

    @Test
    public void testSchemaMergeArrayTypes() throws Exception {
        String jsonSample = "{\"id\": 1}\n{\"id\": 2}{\"id\": \"socket\", \"anArray\": [33, 34, 35]}{\"id\": 3, \"anArray\": [\"badger\", \"porcupine\"]}";
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.IntDefault)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"Test").fields().name("id").type().unionOf().intType().and().stringType()).endUnion()).noDefault().name("anArray").type().optional().array().items().unionOf().intType()).and().stringType()).endUnion()).endRecord();
        Assert.assertEquals((String)"Should match expected schema", (Object)schema, (Object)TestJsonUtil.mergeSchemas(jsonSample));
    }

    @Test
    public void testSchemaMergeMapTypes() throws Exception {
        String jsonSample = "{\"id\": 1}\n{\"id\": 2}{\"id\": \"socket\", \"aMap\": {\"coffee\": 17}}{\"id\": 3, \"aMap\": {\"badger\": \"porcupine\"}}";
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.IntDefault)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"Test").fields().name("id").type().unionOf().intType().and().stringType()).endUnion()).noDefault().name("aMap").type().optional().map().values().unionOf().intType()).and().stringType()).endUnion()).endRecord();
        Assert.assertEquals((String)"Should match expected schema", (Object)schema, (Object)TestJsonUtil.mergeSchemasWithMaps(jsonSample));
    }

    @Test
    public void testSchemaMergeUnionTypes() throws Exception {
        String jsonArraySample = "{\"id\": 1}\n{\"id\": 2}{\"id\": \"socket\", \"union\": [33, 34, 35]}{\"id\": 3, \"union\": [\"badger\", \"porcupine\"]}";
        String jsonMapSample = "{\"id\": 1}\n{\"id\": 2}{\"id\": \"socket\", \"union\": {\"coffee\": 17}}{\"id\": 3, \"union\": {\"badger\": \"porcupine\"}}";
        Schema schema = (Schema)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.IntDefault)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"Test").fields().name("id").type().unionOf().intType().and().stringType()).endUnion()).noDefault().name("union").type().unionOf().nullType().and().array().items().unionOf().intType()).and().stringType()).endUnion()).and().map().values().unionOf().intType()).and().stringType()).endUnion()).endUnion()).nullDefault().endRecord();
        Assert.assertEquals((String)"Should match expected schema", (Object)schema, (Object)SchemaUtil.merge((Schema)TestJsonUtil.mergeSchemas(jsonArraySample), (Schema)TestJsonUtil.mergeSchemasWithMaps(jsonMapSample)));
    }

    private static Schema mergeSchemas(String jsonSample) throws Exception {
        return TestJsonUtil.merge(Iterators.transform((Iterator)JsonUtil.parser((InputStream)new ByteArrayInputStream(jsonSample.getBytes("utf-8"))), (Function)new Function<JsonNode, Schema>(){

            public Schema apply(JsonNode node) {
                return JsonUtil.inferSchema((JsonNode)node, (String)"Test");
            }
        }));
    }

    private static Schema mergeSchemasWithMaps(String jsonSample) throws Exception {
        return TestJsonUtil.merge(Iterators.transform((Iterator)JsonUtil.parser((InputStream)new ByteArrayInputStream(jsonSample.getBytes("utf-8"))), (Function)new Function<JsonNode, Schema>(){

            public Schema apply(JsonNode node) {
                return JsonUtil.inferSchemaWithMaps((JsonNode)node, (String)"Test");
            }
        }));
    }

    private static Schema merge(Iterator<Schema> schemas) {
        if (!schemas.hasNext()) {
            return null;
        }
        Schema result = schemas.next();
        while (schemas.hasNext()) {
            result = SchemaUtil.merge((Schema)result, (Schema)schemas.next());
        }
        return result;
    }

    private static Object convertGeneric(JsonNode datum, Schema schema) {
        return JsonUtil.convertToAvro((GenericData)GenericData.get(), (JsonNode)datum, (Schema)schema);
    }
}

