/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.partition.HashFieldPartitioner;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.Ranges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConstraints {
    private static final Schema schema = (Schema)SchemaBuilder.record((String)"Event").fields().requiredString("id").requiredLong("timestamp").requiredString("color").endRecord();
    private static PartitionStrategy timeOnly = new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build();
    private static PartitionStrategy strategy = new PartitionStrategy.Builder().hash("id", "id_hash", 64).year("timestamp").month("timestamp").day("timestamp").identity("id").build();
    private static final Constraints emptyConstraints = new Constraints(schema, strategy);
    private static final Logger LOG = LoggerFactory.getLogger(TestConstraints.class);
    public static final long START = System.currentTimeMillis();
    public static final Random RANDOM = new Random(1234L);
    public static final long ONE_DAY_MILLIS = 86400000L;
    public static final EntityAccessor<GenericEvent> accessor = DataModelUtil.accessor(GenericEvent.class, (Schema)schema);

    @Test
    public void testEmptyConstraintsEntityPredicate() {
        Assert.assertNotNull((String)"Empty constraints should produce an entity predicate", (Object)emptyConstraints.toEntityPredicate(accessor));
        Assert.assertTrue((String)"Should match event", (boolean)emptyConstraints.toEntityPredicate(accessor).apply((Object)new GenericEvent()));
        Assert.assertFalse((String)"Should not match null", (boolean)emptyConstraints.toEntityPredicate(accessor).apply(null));
        Assert.assertNotNull((String)"Should produce an unbound key range", (Object)emptyConstraints.toKeyRanges());
        Assert.assertTrue((String)"Empty constraints should be unbounded", (boolean)emptyConstraints.isUnbounded());
    }

    @Test
    public void testEmptyConstraintsKeyPredicateRequiresStrategy() {
        TestHelpers.assertThrows("Cannot produce a key Predicate without strategy", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                new Constraints(schema).toKeyPredicate();
            }
        });
    }

    @Test
    public void testEmptyConstraintsKeyPredicate() {
        Constraints constraints = emptyConstraints.partitionedBy(strategy);
        Constraints.KeyPredicate keyPredicate = constraints.toKeyPredicate();
        Assert.assertNotNull((String)"Should produce a key Predicate", (Object)keyPredicate);
        Assert.assertFalse((String)"Should not match a null key", (boolean)keyPredicate.apply(null));
        Assert.assertTrue((String)"Should match empty key", (boolean)keyPredicate.apply((Object)new StorageKey(strategy)));
    }

    @Test
    public void testExists() {
        Constraints exists = emptyConstraints.with("id", new Object[0]);
        Assert.assertEquals((String)"Should be Predicates.exists()", (Object)Predicates.exists(), (Object)exists.get("id"));
        GenericEvent event = new GenericEvent();
        Assert.assertTrue((String)"Should match event with non-null id", (boolean)exists.toEntityPredicate(accessor).apply((Object)event));
        event.id = null;
        Assert.assertFalse((String)"Should not match event with null id", (boolean)exists.toEntityPredicate(accessor).apply((Object)event));
        Assert.assertNotNull((String)"Should produce a key range", (Object)exists.toKeyRanges());
        Assert.assertFalse((String)"Non-empty constraints (exists) should not be unbounded", (boolean)exists.isUnbounded());
    }

    @Test
    public void testExistsRefinement() {
        Constraints exists = emptyConstraints.with("id", new Object[0]);
        String id = UUID.randomUUID().toString();
        Assert.assertNotNull((String)"Refine with exists should work", (Object)exists.with("id", new Object[0]));
        Assert.assertEquals((String)"Refine with exists should do nothing", (Object)exists, (Object)exists.with("id", new Object[0]));
        Assert.assertNotNull((String)"Refine with with should work", (Object)exists.with("id", new Object[]{id}));
        Assert.assertEquals((String)"Refine with with should produce with", (Object)Predicates.in((Set)Sets.newHashSet((Object[])new String[]{id})), (Object)exists.with("id", new Object[]{id}).get("id"));
        Assert.assertNotNull((String)"Refine with from should work", (Object)exists.from("id", (Comparable)((Object)"0")));
        Assert.assertEquals((String)"Refine with from should produce Range", (Object)Ranges.atLeast((Object)"0"), (Object)exists.from("id", (Comparable)((Object)"0")).get("id"));
        Assert.assertNotNull((String)"Refine with fromAfter should work", (Object)exists.fromAfter("id", (Comparable)((Object)"0")));
        Assert.assertEquals((String)"Refine with fromAfter should produce Range", (Object)Ranges.greaterThan((Object)"0"), (Object)exists.fromAfter("id", (Comparable)((Object)"0")).get("id"));
        Assert.assertNotNull((String)"Refine with to should work", (Object)exists.to("id", (Comparable)((Object)"0")));
        Assert.assertEquals((String)"Refine with to should produce Range", (Object)Ranges.atMost((Object)"0"), (Object)exists.to("id", (Comparable)((Object)"0")).get("id"));
        Assert.assertNotNull((String)"Refine with toBefore should work", (Object)exists.toBefore("id", (Comparable)((Object)"0")));
        Assert.assertEquals((String)"Refine with toBefore should produce Range", (Object)Ranges.lessThan((Object)"0"), (Object)exists.toBefore("id", (Comparable)((Object)"0")).get("id"));
    }

    @Test(expected=NullPointerException.class)
    public void testWithNull() {
        emptyConstraints.with("id", new Object[]{null});
    }

    @Test
    public void testWithSingle() {
        String id = UUID.randomUUID().toString();
        Constraints withSingle = emptyConstraints.with("id", new Object[]{id});
        Assert.assertNotNull((Object)withSingle);
        Assert.assertEquals((String)"Should produce In(single)", (Object)Predicates.in((Set)Sets.newHashSet((Object[])new String[]{id})), (Object)withSingle.get("id"));
        GenericEvent event = new GenericEvent();
        Assert.assertFalse((String)"Should not match event with incorrect id", (boolean)withSingle.toEntityPredicate(accessor).apply((Object)event));
        event.id = id;
        Assert.assertTrue((String)"Should match event with correct id", (boolean)withSingle.toEntityPredicate(accessor).apply((Object)event));
        Assert.assertFalse((String)"Non-empty constraints (with) should not be unbounded", (boolean)withSingle.isUnbounded());
    }

    @Test
    public void testWithMultiple() {
        String[] ids = new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString()};
        Constraints withMultiple = emptyConstraints.with("id", (Object[])ids);
        Assert.assertNotNull((Object)withMultiple);
        Assert.assertEquals((String)"Should produce In(id0, id1)", (Object)Predicates.in((Set)Sets.newHashSet((Object[])new String[]{ids[0], ids[1]})), (Object)withMultiple.get("id"));
        GenericEvent event = new GenericEvent();
        Assert.assertFalse((String)"Should not match event with incorrect id", (boolean)withMultiple.toEntityPredicate(accessor).apply((Object)event));
        event.id = ids[0];
        Assert.assertTrue((String)"Should match event with correct id", (boolean)withMultiple.toEntityPredicate(accessor).apply((Object)event));
        event.id = ids[1];
        Assert.assertTrue((String)"Should match event with correct id", (boolean)withMultiple.toEntityPredicate(accessor).apply((Object)event));
        Assert.assertFalse((String)"Non-empty constraints (with) should not be unbounded", (boolean)withMultiple.isUnbounded());
    }

    @Test
    public void testWithRefinementUsingRange() {
        String[] ids = new String[]{"a", "b", "c"};
        final Constraints with = emptyConstraints.with("id", (Object[])ids);
        Assert.assertNotNull((Object)with);
        Assert.assertNotNull((String)"Refine with from should work", (Object)with.from("id", (Comparable)((Object)"b")));
        Assert.assertEquals((String)"Refine with from should produce subset", (Object)Predicates.in((Set)Sets.newHashSet((Object[])new String[]{"b", "c"})), (Object)with.from("id", (Comparable)((Object)"b")).get("id"));
        Assert.assertNotNull((String)"Refine with fromAfter should work", (Object)with.fromAfter("id", (Comparable)((Object)"b")));
        Assert.assertEquals((String)"Refine with fromAfter should produce subset", (Object)Predicates.in((Set)Sets.newHashSet((Object[])new String[]{"c"})), (Object)with.fromAfter("id", (Comparable)((Object)"b")).get("id"));
        Assert.assertNotNull((String)"Refine with to should work", (Object)with.to("id", (Comparable)((Object)"b")));
        Assert.assertEquals((String)"Refine with to should produce subset", (Object)Predicates.in((Set)Sets.newHashSet((Object[])new String[]{"a", "b"})), (Object)with.to("id", (Comparable)((Object)"b")).get("id"));
        Assert.assertNotNull((String)"Refine with toBefore should work", (Object)with.toBefore("id", (Comparable)((Object)"b")));
        Assert.assertEquals((String)"Refine with toBefore should produce subset", (Object)Predicates.in((Set)Sets.newHashSet((Object[])new String[]{"a"})), (Object)with.toBefore("id", (Comparable)((Object)"b")).get("id"));
        TestHelpers.assertThrows("Should fail if endpoint not in set", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                with.to("id", (Comparable)((Object)"d"));
            }
        });
    }

    @Test
    public void testWithRefinementUsingWith() {
        String[] ids = new String[]{"a", "b", "c"};
        final Constraints with = emptyConstraints.with("id", (Object[])ids);
        Assert.assertNotNull((Object)with);
        Assert.assertEquals((String)"Exists should not change constraints", (Object)with, (Object)with.with("id", new Object[0]));
        Assert.assertNotNull((String)"Should be able to refine with matching item", (Object)with.with("id", new Object[]{"a"}));
        Assert.assertEquals((Object)Predicates.in((Set)Sets.newHashSet((Object[])new String[]{"a"})), (Object)with.with("id", new Object[]{"a"}).get("id"));
        Assert.assertNotNull((String)"Should be able to refine with subset", (Object)with.with("id", new Object[]{"b", "c"}));
        Assert.assertEquals((Object)Predicates.in((Set)Sets.newHashSet((Object[])new String[]{"b", "c"})), (Object)with.with("id", new Object[]{"b", "c"}).get("id"));
        TestHelpers.assertThrows("Should reject refinement outside set", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                with.with("id", new Object[]{"d"});
            }
        });
    }

    @Test
    public void testRangeMethodsNull() {
        TestHelpers.assertThrows("from should fail with null value", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.from("id", null);
            }
        });
        TestHelpers.assertThrows("fromAfter should fail with null value", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.fromAfter("id", null);
            }
        });
        TestHelpers.assertThrows("to should fail with null value", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.to("id", null);
            }
        });
        TestHelpers.assertThrows("toBefore should fail with null value", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.toBefore("id", null);
            }
        });
    }

    @Test
    public void testBasicRanges() {
        Assert.assertEquals((String)"Should be closed to pos-infinity", (Object)Ranges.atLeast((Object)2013), (Object)emptyConstraints.from("year", (Comparable)Integer.valueOf(2013)).get("year"));
        Assert.assertEquals((String)"Should be open to pos-infinity", (Object)Ranges.greaterThan((Object)2013), (Object)emptyConstraints.fromAfter("year", (Comparable)Integer.valueOf(2013)).get("year"));
        Assert.assertEquals((String)"Should be neg-infinity to closed", (Object)Ranges.atMost((Object)2013), (Object)emptyConstraints.to("year", (Comparable)Integer.valueOf(2013)).get("year"));
        Assert.assertEquals((String)"Should be neg-infinity to open", (Object)Ranges.lessThan((Object)2013), (Object)emptyConstraints.toBefore("year", (Comparable)Integer.valueOf(2013)).get("year"));
        Assert.assertFalse((String)"Non-empty constraints (from) should not be unbounded", (boolean)emptyConstraints.from("year", (Comparable)Integer.valueOf(2013)).isUnbounded());
        Assert.assertFalse((String)"Non-empty constraints (fromAfter) should not be unbounded", (boolean)emptyConstraints.fromAfter("year", (Comparable)Integer.valueOf(2013)).isUnbounded());
        Assert.assertFalse((String)"Non-empty constraints (to) should not be unbounded", (boolean)emptyConstraints.to("year", (Comparable)Integer.valueOf(2013)).isUnbounded());
        Assert.assertFalse((String)"Non-empty constraints (toBefore) should not be unbounded", (boolean)emptyConstraints.toBefore("year", (Comparable)Integer.valueOf(2013)).isUnbounded());
    }

    @Test
    public void testBasicRangeRefinement() {
        Assert.assertEquals((String)"Should be closed to closed", (Object)Ranges.closed((Object)2012, (Object)2014), (Object)emptyConstraints.from("year", (Comparable)Integer.valueOf(2012)).to("year", (Comparable)Integer.valueOf(2014)).get("year"));
        Assert.assertEquals((String)"Should be closed to closed", (Object)Ranges.closed((Object)2012, (Object)2014), (Object)emptyConstraints.to("year", (Comparable)Integer.valueOf(2014)).from("year", (Comparable)Integer.valueOf(2012)).get("year"));
        Assert.assertEquals((String)"Should be closed to open", (Object)Ranges.closedOpen((Object)2012, (Object)2014), (Object)emptyConstraints.from("year", (Comparable)Integer.valueOf(2012)).toBefore("year", (Comparable)Integer.valueOf(2014)).get("year"));
        Assert.assertEquals((String)"Should be closed to open", (Object)Ranges.closedOpen((Object)2012, (Object)2014), (Object)emptyConstraints.toBefore("year", (Comparable)Integer.valueOf(2014)).from("year", (Comparable)Integer.valueOf(2012)).get("year"));
        Assert.assertEquals((String)"Should be open to open", (Object)Ranges.open((Object)2012, (Object)2014), (Object)emptyConstraints.fromAfter("year", (Comparable)Integer.valueOf(2012)).toBefore("year", (Comparable)Integer.valueOf(2014)).get("year"));
        Assert.assertEquals((String)"Should be open to open", (Object)Ranges.open((Object)2012, (Object)2014), (Object)emptyConstraints.toBefore("year", (Comparable)Integer.valueOf(2014)).fromAfter("year", (Comparable)Integer.valueOf(2012)).get("year"));
        Assert.assertEquals((String)"Should be open to closed", (Object)Ranges.openClosed((Object)2012, (Object)2014), (Object)emptyConstraints.fromAfter("year", (Comparable)Integer.valueOf(2012)).to("year", (Comparable)Integer.valueOf(2014)).get("year"));
        Assert.assertEquals((String)"Should be open to closed", (Object)Ranges.openClosed((Object)2012, (Object)2014), (Object)emptyConstraints.to("year", (Comparable)Integer.valueOf(2014)).fromAfter("year", (Comparable)Integer.valueOf(2012)).get("year"));
    }

    @Test
    public void testRangeEndpointRefinementUsingRange() {
        final Constraints startRange = emptyConstraints.from("year", (Comparable)Integer.valueOf(2012)).to("year", (Comparable)Integer.valueOf(2014));
        Assert.assertEquals((Object)Ranges.closed((Object)2012, (Object)2014), (Object)startRange.to("year", (Comparable)Integer.valueOf(2014)).get("year"));
        Assert.assertEquals((Object)Ranges.closedOpen((Object)2012, (Object)2014), (Object)startRange.toBefore("year", (Comparable)Integer.valueOf(2014)).get("year"));
        Assert.assertEquals((Object)Ranges.closed((Object)2012, (Object)2014), (Object)startRange.from("year", (Comparable)Integer.valueOf(2012)).get("year"));
        Assert.assertEquals((Object)Ranges.openClosed((Object)2012, (Object)2014), (Object)startRange.fromAfter("year", (Comparable)Integer.valueOf(2012)).get("year"));
        TestHelpers.assertThrows("Cannot change closed endpoint to open", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                startRange.toBefore("year", (Comparable)Integer.valueOf(2014)).to("year", (Comparable)Integer.valueOf(2014));
            }
        });
        TestHelpers.assertThrows("Cannot change closed endpoint to open", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                startRange.fromAfter("year", (Comparable)Integer.valueOf(2012)).from("year", (Comparable)Integer.valueOf(2012));
            }
        });
    }

    @Test
    public void testRangeMidpointRefinementUsingRange() {
        Constraints startRange = emptyConstraints.from("year", (Comparable)Integer.valueOf(2012)).toBefore("year", (Comparable)Integer.valueOf(2014));
        Assert.assertEquals((String)"Can refine using from", (Object)Ranges.closedOpen((Object)2013, (Object)2014), (Object)startRange.from("year", (Comparable)Integer.valueOf(2013)).get("year"));
        Assert.assertEquals((String)"Can refine using fromAfter", (Object)Ranges.open((Object)2013, (Object)2014), (Object)startRange.fromAfter("year", (Comparable)Integer.valueOf(2013)).get("year"));
        Assert.assertEquals((String)"Can refine using to", (Object)Ranges.closed((Object)2012, (Object)2013), (Object)startRange.to("year", (Comparable)Integer.valueOf(2013)).get("year"));
        Assert.assertEquals((String)"Can refine using toBefore", (Object)Ranges.closedOpen((Object)2012, (Object)2013), (Object)startRange.toBefore("year", (Comparable)Integer.valueOf(2013)).get("year"));
    }

    @Test
    public void testRangeRefinementUsingWith() {
        final Constraints startRange = emptyConstraints.from("year", (Comparable)Integer.valueOf(2012)).toBefore("year", (Comparable)Integer.valueOf(2014));
        Assert.assertEquals((String)"Refinement with a set produces a set", (Object)Predicates.in((Set)Sets.newHashSet((Object[])new Integer[]{2012, 2013})), (Object)startRange.with("year", new Object[]{2013, 2012}).get("year"));
        TestHelpers.assertThrows("Cannot refine with a value outside the range", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                startRange.with("year", new Object[]{2014});
            }
        });
    }

    @Test
    public void testRangeRefinementUsingExists() {
        Constraints startRange = emptyConstraints.from("year", (Comparable)Integer.valueOf(2012)).toBefore("year", (Comparable)Integer.valueOf(2014));
        Assert.assertEquals((Object)startRange, (Object)startRange.with("year", new Object[0]));
    }

    @Test
    public void testBasicMatches() {
        GenericEvent e = new GenericEvent();
        StorageKey key = accessor.keyFor((Object)e, new StorageKey(strategy));
        Constraints time = emptyConstraints.partitionedBy(strategy).from("timestamp", (Comparable)Long.valueOf(START)).to("timestamp", (Comparable)Long.valueOf(START + 100000L));
        Constraints.KeyPredicate matchKeys = time.toKeyPredicate();
        Predicate matchEvents = time.toEntityPredicate(accessor);
        Assert.assertTrue((boolean)matchKeys.apply((Object)key));
        Assert.assertTrue((boolean)matchEvents.apply((Object)e));
        Constraints timeAndUUID = time.with("id", new Object[]{e.getId()});
        Assert.assertTrue((boolean)timeAndUUID.toKeyPredicate().apply(key));
        Assert.assertTrue((boolean)timeAndUUID.toEntityPredicate(accessor).apply((Object)e));
        e.timestamp = START - 1L;
        key = accessor.keyFor((Object)e, key);
        Assert.assertFalse((boolean)time.toEntityPredicate(accessor).apply((Object)e));
        Assert.assertFalse((boolean)timeAndUUID.toEntityPredicate(accessor).apply((Object)e));
        Assert.assertTrue((boolean)time.toKeyPredicate().apply(key));
        Assert.assertTrue((boolean)timeAndUUID.toKeyPredicate().apply(key));
        e.timestamp = START - 100001L;
        key = accessor.keyFor((Object)e, key);
        Assert.assertFalse((boolean)time.toEntityPredicate(accessor).apply((Object)e));
        Assert.assertFalse((boolean)timeAndUUID.toEntityPredicate(accessor).apply((Object)e));
        Assert.assertTrue((boolean)time.toKeyPredicate().apply(key));
        Assert.assertTrue((boolean)timeAndUUID.toKeyPredicate().apply(key));
        e.timestamp = START - 86400000L;
        key = accessor.keyFor((Object)e, key);
        Assert.assertFalse((boolean)time.toEntityPredicate(accessor).apply((Object)e));
        Assert.assertFalse((boolean)timeAndUUID.toEntityPredicate(accessor).apply((Object)e));
        Assert.assertFalse((boolean)time.toKeyPredicate().apply(key));
        Assert.assertFalse((boolean)timeAndUUID.toKeyPredicate().apply(key));
    }

    @Test
    public void testBasicKeyMinimization() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().requiredLong("created_at").requiredString("color").optionalInt("number").endRecord();
        HashFieldPartitioner hash50 = new HashFieldPartitioner("name", 50);
        Constraints c = new Constraints(schema).with("number", new Object[]{7, 14, 21, 28, 35, 42, 49}).with("color", new Object[]{"green", "orange"}).from("created_at", (Comparable)Long.valueOf(new DateTime(2013, 1, 1, 0, 0, DateTimeZone.UTC).getMillis())).toBefore("created_at", (Comparable)Long.valueOf(new DateTime(2014, 1, 1, 0, 0, DateTimeZone.UTC).getMillis()));
        PartitionStrategy strategy = new PartitionStrategy.Builder().hash("color", "hash", 50).year("created_at").month("created_at").day("created_at").identity("color").build();
        StorageKey key = new StorageKey(strategy);
        key.replaceValues((List)Lists.newArrayList((Object[])new Object[]{hash50.apply((Object)"green"), 2013, 9, 1, "green"}));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"number"}), c.minimizeFor(key).keySet());
        Constraints c2 = c.toBefore("created_at", (Comparable)Long.valueOf(new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis()));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"number"}), c2.minimizeFor(key).keySet());
        Constraints c3 = c.to("created_at", (Comparable)Long.valueOf(new DateTime(2013, 9, 1, 12, 0, DateTimeZone.UTC).getMillis()));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"number", "created_at"}), c3.minimizeFor(key).keySet());
    }

    @Test
    public void testAlignedWithPartitionBoundaries() {
        PartitionStrategy hashStrategy = new PartitionStrategy.Builder().hash("id", "bucket", 32).build();
        PartitionStrategy withColor = new PartitionStrategy.Builder().range("color", new String[]{"blue", "green", "red"}).year("timestamp").month("timestamp").day("timestamp").identity("id").build();
        Constraints c = emptyConstraints.with("id", new Object[]{"a", "b", "c"});
        Assert.assertFalse((String)"Cannot be satisfied by partition unless partitioned", (boolean)c.with("color", new Object[]{"orange"}).partitionedBy(strategy).alignedWithBoundaries());
        Assert.assertFalse((String)"Cannot be satisfied by hash partition filtering", (boolean)c.partitionedBy(hashStrategy).alignedWithBoundaries());
        Assert.assertFalse((String)"Cannot be satisfied by time filtering for timestamp", (boolean)c.with("timestamp", new Object[]{new DateTime(2013, 9, 1, 12, 0, DateTimeZone.UTC).getMillis()}).partitionedBy(strategy).alignedWithBoundaries());
        Assert.assertFalse((String)"Cannot be satisfied because equality doesn't hold", (boolean)c.with("color", new Object[]{"green", "brown"}).partitionedBy(withColor).alignedWithBoundaries());
        Assert.assertFalse((String)"Cannot be satisfied because equality doesn't hold", (boolean)c.fromAfter("color", (Comparable)((Object)"blue")).to("color", (Comparable)((Object)"red")).partitionedBy(withColor).alignedWithBoundaries());
        Assert.assertTrue((String)"Should be satisfied by partition filtering on id", (boolean)c.partitionedBy(strategy).alignedWithBoundaries());
        Assert.assertTrue((String)"Should be aligned for partition field predicates", (boolean)c.with("year", new Object[]{2013}).with("month", new Object[]{9}).with("day", new Object[]{1}).partitionedBy(strategy).alignedWithBoundaries());
        Assert.assertFalse((String)"Should not ignore other constraints", (boolean)c.with("year", new Object[]{2013}).with("month", new Object[]{9}).with("day", new Object[]{1}).from("timestamp", (Comparable)Long.valueOf(new DateTime(2013, 9, 1, 12, 0, DateTimeZone.UTC).getMillis())).partitionedBy(strategy).alignedWithBoundaries());
    }

    @Test
    public void testTimeAlignedWithPartitionBoundaries() {
        Constraints c = emptyConstraints.partitionedBy(strategy);
        Assert.assertFalse((String)"Cannot be satisfied because timestamp is in middle of partition", (boolean)c.from("timestamp", (Comparable)Long.valueOf(new DateTime(2013, 9, 1, 12, 0, DateTimeZone.UTC).getMillis())).alignedWithBoundaries());
        Assert.assertTrue((String)"Should be satisfied because 'from' timestamp is on inclusive partition boundary", (boolean)c.from("timestamp", (Comparable)Long.valueOf(new DateTime(2013, 9, 1, 0, 0, DateTimeZone.UTC).getMillis())).alignedWithBoundaries());
        Assert.assertFalse((String)"Cannot be satisfied because 'from' timestamp is on exclusive partition boundary", (boolean)c.fromAfter("timestamp", (Comparable)Long.valueOf(new DateTime(2013, 9, 1, 0, 0, DateTimeZone.UTC).getMillis())).alignedWithBoundaries());
        Assert.assertTrue((String)"Should be satisfied because 'to' timestamp is on exclusive partition boundary", (boolean)c.toBefore("timestamp", (Comparable)Long.valueOf(new DateTime(2013, 9, 1, 0, 0, DateTimeZone.UTC).getMillis())).alignedWithBoundaries());
        Assert.assertFalse((String)"Cannot be satisfied because 'to' timestamp is on inclusive partition boundary", (boolean)c.to("timestamp", (Comparable)Long.valueOf(new DateTime(2013, 9, 1, 0, 0, DateTimeZone.UTC).getMillis())).alignedWithBoundaries());
        Assert.assertTrue((String)"Should be satisfied because 'from' timestamp is on inclusive partition boundary and 'to' timestamp is on exclusive partition boundary", (boolean)c.from("timestamp", (Comparable)Long.valueOf(new DateTime(2013, 9, 1, 0, 0, DateTimeZone.UTC).getMillis())).toBefore("timestamp", (Comparable)Long.valueOf(new DateTime(2013, 9, 2, 0, 0, DateTimeZone.UTC).getMillis())).alignedWithBoundaries());
    }

    @Test
    public void testTimeRangeEdgeCases() {
        long oct_24_2013 = new DateTime(2013, 10, 24, 0, 0, DateTimeZone.UTC).getMillis();
        long oct_25_2013 = new DateTime(2013, 10, 25, 0, 0, DateTimeZone.UTC).getMillis();
        long oct_24_2013_end = new DateTime(2013, 10, 24, 23, 59, 59, 999, DateTimeZone.UTC).getMillis();
        GenericEvent e = new GenericEvent();
        e.timestamp = oct_25_2013;
        StorageKey key = accessor.keyFor((Object)e, new StorageKey(timeOnly));
        Constraints empty = emptyConstraints.partitionedBy(timeOnly);
        Constraints c = empty.with("timestamp", new Object[]{oct_24_2013});
        Assert.assertFalse((String)"Should not match", (boolean)c.toKeyPredicate().apply(key));
        c = empty.toBefore("timestamp", (Comparable)Long.valueOf(oct_24_2013_end));
        LOG.info("Constraints: {}", (Object)c);
        e.timestamp = oct_25_2013;
        key = accessor.keyFor((Object)e, key);
        Assert.assertFalse((String)"Should not match toBefore", (boolean)c.toKeyPredicate().apply(key));
    }

    @Test
    public void testRejectsNonSchemaOrPartitionFields() {
        TestHelpers.assertThrows("Should reject unknown field name", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("prescription", new Object[]{34});
            }
        });
    }

    @Test
    public void testRejectsFieldSchemaMismatch() {
        TestHelpers.assertThrows("Should reject incorrect schema, string for long", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("timestamp", new Object[]{"boat"});
            }
        });
        TestHelpers.assertThrows("Should reject incorrect schema, int for string", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("color", new Object[]{34});
            }
        });
    }

    @Test
    public void testRejectsPartitionFieldSchemaMismatch() {
        TestHelpers.assertThrows("Should reject incorrect schema, string for int", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("year", new Object[]{"joker"});
            }
        });
        TestHelpers.assertThrows("Should reject incorrect schema, int for string", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("id", new Object[]{34});
            }
        });
    }

    @Test
    public void testPartitionFieldConstraints() {
        GenericEvent e = new GenericEvent();
        DateTime eventDateTime = new Instant(e.getTimestamp()).toDateTime(DateTimeZone.UTC);
        Constraints eventDay = emptyConstraints.with("year", new Object[]{eventDateTime.getYear()}).with("month", new Object[]{eventDateTime.getMonthOfYear()}).with("day", new Object[]{eventDateTime.getDayOfMonth()});
        StorageKey eventKey = new StorageKey.Builder(strategy).add("timestamp", (Object)e.getTimestamp()).add("id", (Object)e.getId()).build();
        Constraints.KeyPredicate keyPredicate = eventDay.toKeyPredicate();
        Assert.assertNotNull((String)"Should produce a KeyPredicate", (Object)keyPredicate);
        Assert.assertTrue((String)"Should match key", (boolean)keyPredicate.apply((Object)eventKey));
        Predicate entityPredicate = eventDay.toEntityPredicate(accessor);
        Assert.assertNotNull((String)"Should produce an EntityPredicate", (Object)entityPredicate);
        Assert.assertTrue((String)"Should match entity", (boolean)entityPredicate.apply((Object)e));
    }

    @Test
    public void testPartitionFieldConstraintsMinimized() {
        GenericEvent e = new GenericEvent();
        DateTime eventDateTime = new Instant(e.getTimestamp()).toDateTime(DateTimeZone.UTC);
        Constraints green = emptyConstraints.from("year", (Comparable)Integer.valueOf(eventDateTime.getYear())).with("month", new Object[]{eventDateTime.getMonthOfYear()}).with("color", new Object[]{"green"});
        StorageKey eventKey = new StorageKey.Builder(strategy).add("timestamp", (Object)e.getTimestamp()).add("id", (Object)e.getId()).build();
        Map minimized = green.minimizeFor(eventKey);
        Assert.assertEquals((String)"Should have one unsatisfied constraint", (long)1L, (long)minimized.size());
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(minimized.entrySet());
        Assert.assertEquals((String)"Should be the color constraint", (Object)"color", entry.getKey());
        Assert.assertEquals((String)"Should match green", (Object)Predicates.in((Object[])new String[]{"green"}), entry.getValue());
    }

    @Test
    public void testQueryMapConversion() {
        String id1 = UUID.randomUUID().toString();
        String id2 = UUID.randomUUID().toString();
        String color = "red";
        Constraints with = emptyConstraints.with("id", new Object[]{id1, id2}).with("color", new Object[]{color});
        Map queryMap = with.toQueryMap();
        Assert.assertEquals((long)2L, (long)queryMap.size());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{id1, id2}), (Object)Sets.newHashSet((Iterable)Splitter.on((char)',').split((CharSequence)queryMap.get("id"))));
        Assert.assertEquals((Object)color, queryMap.get("color"));
        Assert.assertEquals((Object)with, (Object)Constraints.fromQueryMap((Schema)schema, (PartitionStrategy)strategy, (Map)queryMap));
    }

    @Test
    public void testQueryMapConversionWithEncodedCharacters() {
        Constraints with = emptyConstraints.with("id", new Object[]{"a/b,c"});
        Map queryMap = with.toQueryMap();
        Assert.assertEquals((long)1L, (long)queryMap.size());
        Assert.assertEquals((Object)"a%2Fb%2Cc", queryMap.get("id"));
        Assert.assertEquals((Object)with, (Object)Constraints.fromQueryMap((Schema)schema, (PartitionStrategy)strategy, (Map)queryMap));
    }

    @Test
    public void testMultiValueQueryMapConversionWithEncodedCharacters() {
        Constraints with = emptyConstraints.with("id", new Object[]{"a,b", "c"});
        Map queryMap = with.toQueryMap();
        Assert.assertEquals((long)1L, (long)queryMap.size());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"a%2Cb", "c"}), (Object)Sets.newHashSet((Iterable)Splitter.on((char)',').split((CharSequence)queryMap.get("id"))));
        Assert.assertEquals((Object)with, (Object)Constraints.fromQueryMap((Schema)schema, (PartitionStrategy)strategy, (Map)queryMap));
    }

    public static class GenericEvent {
        public String id = UUID.randomUUID().toString();
        public long timestamp = START + (long)RANDOM.nextInt(100000);

        public String getId() {
            return this.id;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

