/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.Compatibility;

public class TestCompatibilityChecks {
    public static final Schema PROVIDED_TEST_SCHEMA = (Schema)SchemaBuilder.record((String)"Test").fields().requiredLong("l").requiredInt("i").requiredString("s").endRecord();
    private static final Schema schema = (Schema)SchemaBuilder.record((String)"Record").fields().requiredString("message").requiredBoolean("bool").requiredLong("timestamp").requiredInt("number").requiredDouble("double").requiredFloat("float").requiredBytes("payload").endRecord();

    @Test
    public void testIsCompatibleName() {
        Assert.assertTrue((boolean)Compatibility.isCompatibleName((String)"foo"));
        Assert.assertTrue((boolean)Compatibility.isCompatibleName((String)"Foo"));
        Assert.assertTrue((boolean)Compatibility.isCompatibleName((String)"bAr"));
        Assert.assertTrue((boolean)Compatibility.isCompatibleName((String)"3foo"));
        Assert.assertTrue((boolean)Compatibility.isCompatibleName((String)"_foo"));
        Assert.assertTrue((boolean)Compatibility.isCompatibleName((String)"foo3"));
        Assert.assertTrue((boolean)Compatibility.isCompatibleName((String)"foo_"));
        Assert.assertTrue((boolean)Compatibility.isCompatibleName((String)"foo_bar"));
        Assert.assertFalse((boolean)Compatibility.isCompatibleName((String)"foo.bar"));
        Assert.assertFalse((boolean)Compatibility.isCompatibleName((String)"foo-bar"));
        Assert.assertFalse((boolean)Compatibility.isCompatibleName((String)"foo*"));
    }

    @Test
    public void testAllowedPartitionSchemaCombinations() {
        Compatibility.checkDescriptor((DatasetDescriptor)new DatasetDescriptor.Builder().schema(schema).partitionStrategy(new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").hour("timestamp").minute("timestamp").identity("message", "message_copy").identity("timestamp", "ts").identity("number", "num").hash("message", 48).hash("timestamp", 48).hash("number", 48).hash("payload", 48).hash("float", 48).hash("double", 48).hash("bool", 48).range("number", new int[]{5, 10, 15, 20}).range("message", new String[]{"m", "z", "M", "Z"}).build()).build());
    }

    @Test
    public void testNullDescriptor() {
        TestHelpers.assertThrows("Should reject null descriptor", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkDescriptor(null);
            }
        });
    }

    @Test
    public void testIllegalPartitionNames() {
        TestHelpers.assertThrows("Should reject '-' in partition name", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkDescriptor((DatasetDescriptor)new DatasetDescriptor.Builder().schema(schema).partitionStrategy(new PartitionStrategy.Builder().identity("day_of_month", "day-of-month").build()).build());
            }
        });
        TestHelpers.assertThrows("Should reject '.' in partition name", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkDescriptor((DatasetDescriptor)new DatasetDescriptor.Builder().schema(schema).partitionStrategy(new PartitionStrategy.Builder().identity("number", "day.of.month").build()).build());
            }
        });
    }

    @Test
    public void testDuplicatePartitionNames() {
        TestHelpers.assertThrows("Should reject partition names that duplicate partition names", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkDescriptor((DatasetDescriptor)new DatasetDescriptor.Builder().schema(schema).partitionStrategy(new PartitionStrategy.Builder().day("timestamp").identity("number", "day").build()).build());
            }
        });
        TestHelpers.assertThrows("Should reject partition names that duplicate source names", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkDescriptor((DatasetDescriptor)new DatasetDescriptor.Builder().schema(schema).partitionStrategy(new PartitionStrategy.Builder().day("timestamp").identity("number", "timestamp").build()).build());
            }
        });
    }

    @Test
    public void testProvidedPartitionIntUpdate() {
        PartitionStrategy provided = new PartitionStrategy.Builder().provided("part", "int").build();
        Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().hash("s", "part", 16).build(), (Schema)PROVIDED_TEST_SCHEMA);
        Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("l", "part").build(), (Schema)PROVIDED_TEST_SCHEMA);
        Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("s", "part").build(), (Schema)PROVIDED_TEST_SCHEMA);
    }

    @Test
    public void testProvidedPartitionLongUpdate() {
        final PartitionStrategy provided = new PartitionStrategy.Builder().provided("part", "long").build();
        Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("l", "part").build(), (Schema)PROVIDED_TEST_SCHEMA);
        Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("s", "part").build(), (Schema)PROVIDED_TEST_SCHEMA);
        TestHelpers.assertThrows("Should not allow long to int update", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("i", "part").build(), (Schema)PROVIDED_TEST_SCHEMA);
            }
        });
    }

    @Test
    public void testProvidedPartitionStringUpdate() {
        final PartitionStrategy provided = new PartitionStrategy.Builder().provided("part", "string").build();
        Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("s", "part").build(), (Schema)PROVIDED_TEST_SCHEMA);
        TestHelpers.assertThrows("Should not allow string to int update", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("i", "part").build(), (Schema)PROVIDED_TEST_SCHEMA);
            }
        });
        TestHelpers.assertThrows("Should not allow string to long update", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("i", "part").build(), (Schema)PROVIDED_TEST_SCHEMA);
            }
        });
    }

    @Test
    public void testProvidedPartitionNameUpdate() {
        final PartitionStrategy provided = new PartitionStrategy.Builder().provided("part", "string").build();
        TestHelpers.assertThrows("Should not allow changing the partition name", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("s", "other").build(), (Schema)PROVIDED_TEST_SCHEMA);
            }
        });
    }

    @Test
    public void testProvidedPartitionSizeChange() {
        final PartitionStrategy provided = new PartitionStrategy.Builder().provided("part", "string").provided("part2", "string").build();
        TestHelpers.assertThrows("Should not allow fewer partitions", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("s", "part").build(), (Schema)PROVIDED_TEST_SCHEMA);
            }
        });
        Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("s", "part").identity("s", "part2").build(), (Schema)PROVIDED_TEST_SCHEMA);
        TestHelpers.assertThrows("Should not allow more partitions", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().identity("s", "part").identity("s", "part2").identity("s", "part3").build(), (Schema)PROVIDED_TEST_SCHEMA);
            }
        });
    }

    @Test
    public void testUpdateNonProvided() {
        final PartitionStrategy provided = new PartitionStrategy.Builder().identity("s", "part").build();
        TestHelpers.assertThrows("Should not allow replacing if not provided", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                Compatibility.checkStrategyUpdate((PartitionStrategy)provided, (PartitionStrategy)new PartitionStrategy.Builder().dateFormat("l", "part", "yyyy-MM-dd").build(), (Schema)PROVIDED_TEST_SCHEMA);
            }
        });
    }
}

