/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import java.net.URI;
import java.net.URLEncoder;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.spi.Constraints;

public class TestURIBuilder {
    private static final Schema SCHEMA = (Schema)SchemaBuilder.record((String)"Event").fields().requiredString("id").requiredLong("timestamp").requiredString("color").endRecord();
    private static final PartitionStrategy STRATEGY = new PartitionStrategy.Builder().hash("id", "id-hash", 64).year("timestamp").month("timestamp").day("timestamp").identity("id").build();
    private static final String ID = UUID.randomUUID().toString();
    private static final Constraints empty = new Constraints(SCHEMA, STRATEGY);

    @Test
    public void testRepoUriAndNameToDatasetUri() {
        Assert.assertEquals((String)"Should construct the correct dataset URI", (Object)URI.create("dataset:file:/datasets/ns/test-name"), (Object)new URIBuilder("repo:file:/datasets", "ns", "test-name").build());
    }

    @Test
    public void testRepoUriAndNameConstructorRejectsBadUris() {
        TestHelpers.assertThrows("Should reject dataset: URI", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                new URIBuilder("dataset:file:/datasets/test-name", "ns", "test-name-2").build();
            }
        });
        TestHelpers.assertThrows("Should reject view: URI", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                new URIBuilder("view:file:/datasets/test-name?n=34", "ns", "test-name-2").build();
            }
        });
        TestHelpers.assertThrows("Should reject null URI", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                new URIBuilder((String)null, "ns", "test-name").build();
            }
        });
        TestHelpers.assertThrows("Should reject null URI", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                new URIBuilder((URI)null, "ns", "test-name").build();
            }
        });
        TestHelpers.assertThrows("Should reject null namespace", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                new URIBuilder("repo:file:/datasets", null, "test-name").build();
            }
        });
        TestHelpers.assertThrows("Should reject null name", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                new URIBuilder("repo:file:/datasets", "ns", null).build();
            }
        });
    }

    @Test
    public void testRepoUriAndNameToDatasetUriPreservesOptions() {
        Assert.assertEquals((String)"Should construct the correct dataset URI", (Object)URI.create("dataset:file:/datasets/ns/test-name?hdfs:port=1080"), (Object)new URIBuilder("repo:file:/datasets?hdfs:port=1080", "ns", "test-name").build());
    }

    @Test
    public void testRepoUriAndNameAddEquals() {
        Assert.assertEquals((String)"Should construct the correct dataset URI", (Object)URI.create("view:file:/datasets/ns/test-name?prop=value"), (Object)new URIBuilder("repo:file:/datasets", "ns", "test-name").with("prop", (Object)"value").build());
        Assert.assertEquals((String)"Should construct the correct dataset URI", (Object)URI.create("view:file:/datasets/ns/test-name?prop=value&num=34"), (Object)new URIBuilder("repo:file:/datasets", "ns", "test-name").with("prop", (Object)"value").with("num", (Object)34).build());
    }

    @Test
    public void testDatasetUriToDatasetUri() {
        Assert.assertEquals((String)"Should produce an equivalent dataset URI", (Object)URI.create("dataset:file:/datasets/test-name"), (Object)new URIBuilder("dataset:file:/datasets/test-name").build());
    }

    @Test
    public void testDatasetUriConstructorRejectsBadUris() {
        TestHelpers.assertThrows("Should reject repo: URI", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                new URIBuilder("repo:file:/datasets/test-name").build();
            }
        });
        TestHelpers.assertThrows("Should reject null URI", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                new URIBuilder((String)null).build();
            }
        });
        TestHelpers.assertThrows("Should reject null URI", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                new URIBuilder((URI)null).build();
            }
        });
    }

    @Test
    public void testDatasetUriToDatasetUriPreservesOptions() {
        Assert.assertEquals((String)"Should construct the correct dataset URI", (Object)URI.create("dataset:file:/datasets/test-name?hdfs:port=1080"), (Object)new URIBuilder("dataset:file:/datasets/test-name?hdfs:port=1080").build());
    }

    @Test
    public void testDatasetUriAddEquals() {
        Assert.assertEquals((String)"Should produce an equivalent dataset URI", (Object)URI.create("view:file:/datasets/test-name?prop=value"), (Object)new URIBuilder("dataset:file:/datasets/test-name").with("prop", (Object)"value").build());
        Assert.assertEquals((String)"Should produce an equivalent dataset URI", (Object)URI.create("view:file:/datasets/test-name?prop=value&num=34"), (Object)new URIBuilder("dataset:file:/datasets/test-name").with("prop", (Object)"value").with("num", (Object)34).build());
    }

    @Test
    public void testViewUriToViewUri() {
        Assert.assertEquals((String)"Should produce an equivalent view URI", (Object)URI.create("view:file:/datasets/test-name?prop=value"), (Object)new URIBuilder("view:file:/datasets/test-name?prop=value").build());
    }

    @Test
    public void testViewUriAddEquals() throws Exception {
        Assert.assertEquals((String)"Should produce an equivalent dataset URI", (Object)URI.create("view:file:/datasets/test-name?prop=value&field=v2"), (Object)new URIBuilder("view:file:/datasets/test-name?prop=value").with("field", (Object)"v2").build());
        Assert.assertEquals((String)"Should produce an equivalent dataset URI", (Object)URI.create("view:file:/datasets/test-name?prop=value&field=v2&num=34"), (Object)new URIBuilder("view:file:/datasets/test-name?prop=value").with("field", (Object)"v2").with("num", (Object)34).build());
        Assert.assertEquals((String)"Should produce an equivalent dataset URI", (Object)URI.create("view:file:/datasets/test-name?field=a/b"), (Object)new URIBuilder("view:file:/datasets/test-name").with("field", (Object)"a/b").build());
        Assert.assertEquals((String)"Should produce an equivalent dataset URI", (Object)URI.create("view:file:/datasets/test-name?field=a%2Fb"), (Object)new URIBuilder("view:file:/datasets/test-name").with("field", (Object)URLEncoder.encode("a/b", "UTF-8")).build());
    }

    @Test
    public void testAddEqualityConstraints() {
        Assert.assertEquals((String)"Should add equality constraints", (Object)URI.create("view:file:/datasets/test?id=" + ID), (Object)new URIBuilder("dataset:file:/datasets/test").constraints(empty.with("id", new Object[]{new Utf8(ID)})).build());
        Assert.assertEquals((String)"Should add equality constraints", (Object)URI.create("view:file:/datasets/test?id=a,b"), (Object)new URIBuilder("dataset:file:/datasets/test").constraints(empty.with("id", new Object[]{new Utf8("a"), new Utf8("b")})).build());
        Assert.assertEquals((String)"Should add equality constraints", (Object)URI.create("view:file:/datasets/test?id=" + ID + "&timestamp=1405720705333"), (Object)new URIBuilder("dataset:file:/datasets/test").constraints(empty.with("id", new Object[]{new Utf8(ID)}).with("timestamp", new Object[]{1405720705333L})).build());
        Assert.assertEquals((String)"Should add encoded equality constraints", (Object)URI.create("view:file:/datasets/test?id=a%2Fb"), (Object)new URIBuilder("dataset:file:/datasets/test").constraints(empty.with("id", new Object[]{new Utf8("a/b")})).build());
    }

    @Test
    public void testAddExistsConstraints() {
        Assert.assertEquals((String)"Should add equality constraints", (Object)URI.create("view:file:/datasets/test?id="), (Object)new URIBuilder("dataset:file:/datasets/test").constraints(empty.with("id", new Object[0])).build());
        Assert.assertEquals((String)"Should add equality constraints", (Object)URI.create("view:file:/datasets/test?id=&timestamp="), (Object)new URIBuilder("dataset:file:/datasets/test").constraints(empty.with("id", new Object[0]).with("timestamp", new Object[0])).build());
    }

    @Test
    public void testAddRangeConstraints() {
        Assert.assertEquals((String)"Should add equality constraints", (Object)URI.create("view:file:/datasets/test?color=[green,)"), (Object)new URIBuilder("dataset:file:/datasets/test").constraints(empty.from("color", (Comparable)((Object)"green"))).build());
        Assert.assertEquals((String)"Should add equality constraints", (Object)URI.create("view:file:/datasets/test?color=(,green]"), (Object)new URIBuilder("dataset:file:/datasets/test").constraints(empty.to("color", (Comparable)((Object)"green"))).build());
        Assert.assertEquals((String)"Should add equality constraints", (Object)URI.create("view:file:/datasets/test?timestamp=[0,1405720705333)&color=(green,red]"), (Object)new URIBuilder("dataset:file:/datasets/test").constraints(empty.from("timestamp", (Comparable)Long.valueOf(0L)).toBefore("timestamp", (Comparable)Long.valueOf(1405720705333L)).fromAfter("color", (Comparable)((Object)"green")).to("color", (Comparable)((Object)"red"))).build());
    }

    @Test
    public void testEmptyConstraints() {
        Assert.assertEquals((String)"Empty constraints should produce dataset URI", (Object)URI.create("dataset:file:/datasets/test"), (Object)new URIBuilder("dataset:file:/datasets/test").constraints(empty).build());
    }
}

