/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.FieldPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPartitionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TestPartitionStrategy.class);

    @Test
    public void test() throws Exception {
        PartitionStrategy p = new PartitionStrategy.Builder().identity("month", "month_ordinal", 12).hash("userId", 7).build();
        List fieldPartitioners = p.getFieldPartitioners();
        Assert.assertEquals((long)2L, (long)fieldPartitioners.size());
        FieldPartitioner fp0 = (FieldPartitioner)fieldPartitioners.get(0);
        Assert.assertEquals((Object)"month_ordinal", (Object)fp0.getName());
        Assert.assertEquals((long)12L, (long)fp0.getCardinality());
        FieldPartitioner fp1 = (FieldPartitioner)fieldPartitioners.get(1);
        Assert.assertEquals((Object)"userId_hash", (Object)fp1.getName());
        Assert.assertEquals((long)7L, (long)fp1.getCardinality());
        Assert.assertEquals((long)84L, (long)p.getCardinality());
    }

    @Test
    @Ignore
    public void testDuplicateFieldNames() {
        Assert.assertNotNull((String)"Should allow duplicate source fields", (Object)new PartitionStrategy.Builder().year("timestamp").month("timestamp").build());
        TestHelpers.assertThrows("Should reject duplicate partition fields", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new PartitionStrategy.Builder().identity("number", "num").identity("number2", "num").build();
            }
        });
    }

    static class Entity {
        int month;
        int userId;

        Entity() {
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getUserId() {
            return this.userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }
    }
}

