/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kitesdk.data.PartitionExpression;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.partition.HashFieldPartitioner;
import org.kitesdk.data.spi.partition.MinuteFieldPartitioner;
import org.kitesdk.data.spi.partition.YearFieldPartitioner;

public class TestPartitionExpression {
    @Test
    public void testPartitionStrategy() {
        String expr = "hash(\"username\", \"username_part\", 2)";
        PartitionExpression expression = new PartitionExpression(expr, true);
        PartitionStrategy strategy = expression.evaluate();
        List fieldPartitioners = Accessor.getDefault().getFieldPartitioners(strategy);
        Assert.assertEquals((long)1L, (long)fieldPartitioners.size());
        FieldPartitioner fp = (FieldPartitioner)fieldPartitioners.get(0);
        Assert.assertEquals(HashFieldPartitioner.class, fp.getClass());
        Assert.assertEquals((Object)"username", (Object)fp.getSourceName());
        Assert.assertEquals((Object)"username_part", (Object)fp.getName());
        Assert.assertEquals((long)2L, (long)fp.getCardinality());
        Assert.assertEquals((Object)expr, (Object)PartitionExpression.toExpression((PartitionStrategy)strategy));
    }

    @Test
    public void testSubpartitionStrategy() {
        String expr = "[hash(\"username\", \"username_part\", 2), hash(\"username2\", \"username2_part\", 3)]";
        PartitionExpression expression = new PartitionExpression(expr, true);
        PartitionStrategy strategy = expression.evaluate();
        List fieldPartitioners = Accessor.getDefault().getFieldPartitioners(strategy);
        Assert.assertEquals((long)2L, (long)fieldPartitioners.size());
        FieldPartitioner fp0 = (FieldPartitioner)fieldPartitioners.get(0);
        Assert.assertEquals(HashFieldPartitioner.class, fp0.getClass());
        Assert.assertEquals((Object)"username_part", (Object)fp0.getName());
        Assert.assertEquals((long)2L, (long)fp0.getCardinality());
        FieldPartitioner fp1 = (FieldPartitioner)fieldPartitioners.get(1);
        Assert.assertEquals(HashFieldPartitioner.class, fp1.getClass());
        Assert.assertEquals((Object)"username2_part", (Object)fp1.getName());
        Assert.assertEquals((long)3L, (long)fp1.getCardinality());
        Assert.assertEquals((Object)expr, (Object)PartitionExpression.toExpression((PartitionStrategy)strategy));
    }

    @Test
    public void testMixedSubpartitionStrategy() {
        String expr = "[year(\"timestamp\", \"year\"), minute(\"timestamp\", \"minute\")]";
        PartitionExpression expression = new PartitionExpression(expr, true);
        PartitionStrategy strategy = expression.evaluate();
        List fieldPartitioners = Accessor.getDefault().getFieldPartitioners(strategy);
        Assert.assertEquals((long)2L, (long)fieldPartitioners.size());
        FieldPartitioner fp0 = (FieldPartitioner)fieldPartitioners.get(0);
        Assert.assertEquals(YearFieldPartitioner.class, fp0.getClass());
        Assert.assertEquals((Object)"timestamp", (Object)fp0.getSourceName());
        Assert.assertEquals((Object)"year", (Object)fp0.getName());
        FieldPartitioner fp1 = (FieldPartitioner)fieldPartitioners.get(1);
        Assert.assertEquals(MinuteFieldPartitioner.class, fp1.getClass());
        Assert.assertEquals((Object)"timestamp", (Object)fp1.getSourceName());
        Assert.assertEquals((Object)"minute", (Object)fp1.getName());
        Assert.assertEquals((Object)expr, (Object)PartitionExpression.toExpression((PartitionStrategy)strategy));
    }

    @Test
    public void testRange() {
        PartitionStrategy rangeStrategy = new PartitionStrategy.Builder().range("color", new String[]{"blue", "green", "orange", "red", "white"}).build();
        PartitionStrategy copy = new PartitionExpression(PartitionExpression.toExpression((PartitionStrategy)rangeStrategy), true).evaluate();
        Assert.assertEquals((Object)rangeStrategy, (Object)copy);
    }

    @Test
    public void testIntRange() {
        PartitionStrategy intRangeStrategy = new PartitionStrategy.Builder().range("intField", new int[]{5, 10, 15, 20, 25}).build();
        PartitionStrategy copy = new PartitionExpression(PartitionExpression.toExpression((PartitionStrategy)intRangeStrategy), true).evaluate();
        Assert.assertEquals((Object)intRangeStrategy, (Object)copy);
    }

    @Test
    public void testIntIdentity() {
        PartitionStrategy intIdStrategy = new PartitionStrategy.Builder().identity("intField").build();
        PartitionStrategy copy = new PartitionExpression(PartitionExpression.toExpression((PartitionStrategy)intIdStrategy), true).evaluate();
        Assert.assertEquals((Object)intIdStrategy, (Object)copy);
    }

    @Test
    @Ignore
    public void testList() {
        PartitionStrategy listStrategy = new PartitionStrategy.Builder().build();
        PartitionStrategy copy = new PartitionExpression(PartitionExpression.toExpression((PartitionStrategy)listStrategy), true).evaluate();
        Assert.assertEquals((Object)listStrategy, (Object)copy);
    }
}

