/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.io.Files;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetExistsException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.MemoryMetadataProvider;
import org.kitesdk.data.spi.MetadataProvider;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;

@RunWith(value=Parameterized.class)
public abstract class TestDatasetRepositories
extends MiniDFSTest {
    protected static final String NAMESPACE = "ns1";
    protected static final String NAME = "test1";
    private boolean distributed;
    protected Configuration conf;
    protected FileSystem fileSystem;
    protected Path testDirectory;
    protected DatasetDescriptor testDescriptor;
    protected MetadataProvider testProvider;
    protected Schema testSchema;
    protected DatasetRepository repo;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public abstract DatasetRepository newRepo(MetadataProvider var1);

    public MetadataProvider newProvider(Configuration conf) {
        return new MemoryMetadataProvider(conf){

            @Override
            protected URI newLocation(String name) {
                return new Path(TestDatasetRepositories.this.testDirectory, name).toUri();
            }
        };
    }

    public TestDatasetRepositories(boolean distributed) {
        this.distributed = distributed;
    }

    @Before
    public void setUp() throws IOException {
        this.testSchema = DatasetTestUtilities.USER_SCHEMA;
        this.conf = this.distributed ? MiniDFSTest.getConfiguration() : new Configuration();
        this.fileSystem = FileSystem.get((Configuration)this.conf);
        this.testDirectory = this.fileSystem.makeQualified(new Path(Files.createTempDir().getAbsolutePath()));
        this.testDescriptor = new DatasetDescriptor.Builder().schema(this.testSchema).build();
        this.testProvider = this.newProvider(this.conf);
        this.repo = this.newRepo(this.testProvider);
    }

    @After
    public void tearDown() throws IOException {
        this.fileSystem.delete(this.testDirectory, true);
    }

    @Test
    public void testCreate() {
        Assert.assertFalse((String)"Sanity check", (boolean)this.testProvider.exists(NAMESPACE, NAME));
        Dataset dataset = this.repo.create(NAMESPACE, NAME, this.testDescriptor);
        Assert.assertNotNull((String)"Dataset should be returned", (Object)dataset);
        Assert.assertTrue((String)"Dataset should exist", (boolean)this.repo.exists(NAMESPACE, NAME));
        DatasetDescriptor saved = this.testProvider.load(NAMESPACE, NAME);
        Assert.assertNotNull((String)"Dataset metadata is stored under name", (Object)saved);
        Assert.assertEquals((String)"Saved metadata is returned", (Object)saved, (Object)dataset.getDescriptor());
        Assert.assertEquals((String)"Dataset name is propagated", (Object)NAME, (Object)dataset.getName());
        Assert.assertEquals((String)"Dataset schema is propagated", (Object)this.testDescriptor.getSchema(), (Object)saved.getSchema());
        Assert.assertNotNull((String)"Dataset should have a URI location", (Object)saved.getLocation());
        Assert.assertNotNull((String)"Dataset location should have a scheme", (Object)saved.getLocation().getScheme());
    }

    public void ensureCreated() {
        this.testCreate();
        Assert.assertTrue((String)"Sanity check", (boolean)this.testProvider.exists(NAMESPACE, NAME));
    }

    @Test(expected=NullPointerException.class)
    public void testCreateNullNamespace() {
        this.repo.create(null, NAME, this.testDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateNullName() {
        this.repo.create(NAMESPACE, null, this.testDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateNullDescriptor() {
        this.repo.create(NAMESPACE, NAME, null);
    }

    @Test
    public void testCreatePartitioned() throws IOException {
        DatasetDescriptor requested = new DatasetDescriptor.Builder(this.testDescriptor).partitionStrategy(new PartitionStrategy.Builder().hash("username", 3).build()).build();
        Assert.assertFalse((String)"Sanity check", (boolean)this.testProvider.exists(NAMESPACE, "test2"));
        Dataset dataset = this.repo.create(NAMESPACE, "test2", requested);
        DatasetDescriptor saved = this.testProvider.load(NAMESPACE, "test2");
        Assert.assertNotNull((String)"Dataset metadata is stored under name", (Object)saved);
        Assert.assertEquals((String)"Saved metadata is returned", (Object)saved, (Object)dataset.getDescriptor());
        Assert.assertEquals((String)"Dataset name is propagated", (Object)"test2", (Object)dataset.getName());
        Assert.assertEquals((String)"Dataset schema is propagated", (Object)requested.getSchema(), (Object)saved.getSchema());
        Assert.assertEquals((String)"Dataset partition strategy propagated", (Object)requested.getPartitionStrategy(), (Object)saved.getPartitionStrategy());
    }

    @Test(expected=DatasetExistsException.class)
    public void testCreateAlreadyExists() {
        this.ensureCreated();
        this.repo.create(NAMESPACE, NAME, new DatasetDescriptor.Builder().schema(this.testSchema).build());
    }

    @Test
    public void testUpdateSuccessWithoutChanges() {
        this.ensureCreated();
        this.repo.update(NAMESPACE, NAME, this.testProvider.load(NAMESPACE, NAME));
    }

    @Test(expected=DatasetNotFoundException.class)
    public void testUpdateNoDataset() {
        Assert.assertFalse((String)"Sanity check", (boolean)this.testProvider.exists(NAMESPACE, NAME));
        this.repo.update(NAMESPACE, NAME, this.testDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testUpdateNullNamespace() {
        this.ensureCreated();
        this.repo.update(null, NAME, this.testDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testUpdateNullName() {
        this.ensureCreated();
        this.repo.update(NAMESPACE, null, this.testDescriptor);
    }

    @Test(expected=NullPointerException.class)
    public void testUpdateNullDescriptor() {
        this.ensureCreated();
        this.repo.update(NAMESPACE, NAME, null);
    }

    @Test
    public void testListDatasets() {
        Assert.assertEquals((Object)ImmutableMultiset.of(), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.datasets(NAMESPACE)));
        this.repo.create(NAMESPACE, NAME, this.testDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.datasets(NAMESPACE)));
        this.repo.create(NAMESPACE, "test2", this.testDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME, (Object)"test2"), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.datasets(NAMESPACE)));
        this.repo.create(NAMESPACE, "test3", this.testDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME, (Object)"test2", (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.datasets(NAMESPACE)));
        this.repo.delete(NAMESPACE, "test2");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME, (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.datasets(NAMESPACE)));
        this.repo.delete(NAMESPACE, "test3");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.datasets(NAMESPACE)));
        this.repo.delete(NAMESPACE, NAME);
        Assert.assertEquals((Object)ImmutableMultiset.of(), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.datasets(NAMESPACE)));
    }

    @Test
    public void testListNamespaces() {
        DatasetDescriptor anotherDescriptor = new DatasetDescriptor.Builder(this.testDescriptor).property("prop", "value").build();
        Assert.assertEquals((Object)ImmutableMultiset.of(), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.namespaces()));
        this.repo.create(NAME, "d1", this.testDescriptor);
        this.repo.create(NAME, "d2", anotherDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.namespaces()));
        this.repo.create("test2", "d1", this.testDescriptor);
        this.repo.create("test2", "d2", anotherDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME, (Object)"test2"), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.namespaces()));
        this.repo.create("test3", "d1", this.testDescriptor);
        this.repo.create("test3", "d2", anotherDescriptor);
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME, (Object)"test2", (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.namespaces()));
        this.repo.delete("test2", "d2");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME, (Object)"test2", (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.namespaces()));
        this.repo.delete("test2", "d1");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME, (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.namespaces()));
        this.repo.delete("test3", "d2");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME, (Object)"test3"), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.namespaces()));
        this.repo.delete("test3", "d1");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.namespaces()));
        this.repo.delete(NAME, "d1");
        Assert.assertEquals((Object)ImmutableMultiset.of((Object)NAME), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.namespaces()));
        this.repo.delete(NAME, "d2");
        Assert.assertEquals((Object)ImmutableMultiset.of(), (Object)ImmutableMultiset.copyOf((Iterable)this.repo.namespaces()));
    }

    @Test
    public void testExists() {
        Assert.assertFalse((boolean)this.repo.exists(NAMESPACE, NAME));
        this.repo.create(NAMESPACE, NAME, new DatasetDescriptor.Builder().schema(this.testSchema).build());
        Assert.assertTrue((boolean)this.repo.exists(NAMESPACE, NAME));
        this.repo.delete(NAMESPACE, NAME);
        Assert.assertFalse((boolean)this.repo.exists(NAMESPACE, NAME));
    }

    @Test(expected=NullPointerException.class)
    public void testExistsNullNamespace() {
        this.repo.exists(null, NAME);
    }

    @Test(expected=NullPointerException.class)
    public void testExistsNullName() {
        this.repo.exists(NAMESPACE, null);
    }

    @Test
    public void testLoad() {
        this.ensureCreated();
        Dataset dataset = this.repo.load(NAMESPACE, NAME);
        Assert.assertNotNull((String)"Dataset is loaded and produced", (Object)dataset);
        Assert.assertEquals((String)"Dataset name is propagated", (Object)NAME, (Object)dataset.getName());
        Assert.assertEquals((String)"Dataset schema is loaded", (Object)this.testSchema, (Object)dataset.getDescriptor().getSchema());
    }

    @Test(expected=DatasetNotFoundException.class)
    public void testLoadNoDataset() {
        Assert.assertFalse((String)"Santity check", (boolean)this.testProvider.exists(NAMESPACE, NAME));
        Dataset dataset = this.repo.load(NAMESPACE, NAME);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadNullNamespace() {
        this.repo.load(null, NAME);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadNullName() {
        this.repo.load(NAMESPACE, (String)null);
    }

    @Test
    public void testDelete() {
        this.ensureCreated();
        boolean result = this.repo.delete(NAMESPACE, NAME);
        Assert.assertTrue((String)"Delete dataset should return true", (boolean)result);
        result = this.repo.delete(NAMESPACE, NAME);
        Assert.assertFalse((String)"Delete nonexistent dataset should return false", (boolean)result);
    }
}

