/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.kitesdk.data.spi.DatasetRepositories;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.OptionBuilder;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.data.spi.URIPattern;
import org.mockito.Mockito;

public class MockRepositories {
    private static final AtomicInteger ids = new AtomicInteger(0);
    private static final Map<String, DatasetRepository> repos = Maps.newHashMap();
    private static boolean registered = false;

    private static void registerMockRepoBuilder() {
        final URIPattern mockPattern = new URIPattern("mock::id");
        Registration.register((URIPattern)mockPattern, (URIPattern)mockPattern, (OptionBuilder)new OptionBuilder<DatasetRepository>(){

            public DatasetRepository getFromOptions(Map<String, String> options) {
                DatasetRepository repo = (DatasetRepository)repos.get(options.get("id"));
                if (repo == null) {
                    repo = (DatasetRepository)Mockito.mock(DatasetRepository.class);
                    Mockito.when((Object)repo.getUri()).thenReturn((Object)URI.create("repo:" + mockPattern.construct(options)));
                    repos.put(options.get("id"), repo);
                }
                return repo;
            }
        });
    }

    private static void ensureRegistered() {
        if (!registered) {
            MockRepositories.registerMockRepoBuilder();
        }
    }

    public static DatasetRepository newMockRepository() {
        MockRepositories.ensureRegistered();
        String uri = "repo:mock:" + Integer.toString(ids.incrementAndGet());
        return DatasetRepositories.repositoryFor((String)uri);
    }
}

