/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Predicate;

@SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE", "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="False positive due to generics.")
@Immutable
public class HashFieldPartitioner
extends FieldPartitioner<Object, Integer> {
    public HashFieldPartitioner(String sourceName, int buckets) {
        this(sourceName, null, buckets);
    }

    public HashFieldPartitioner(String sourceName, @Nullable String name, int buckets) {
        super(sourceName, name == null ? sourceName + "_hash" : name, Object.class, Integer.class, buckets);
        Preconditions.checkArgument(buckets > 0, "Number of hash buckets is negative: %s", buckets);
    }

    @Override
    public Integer apply(Object value) {
        return (value.hashCode() & Integer.MAX_VALUE) % this.getCardinality();
    }

    @Override
    public Predicate<Integer> project(Predicate<Object> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            return ((In)predicate).transform(this);
        }
        return null;
    }

    @Override
    public Predicate<Integer> projectStrict(Predicate<Object> predicate) {
        return null;
    }

    @Override
    @SuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Default annotation is not correct for equals")
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        HashFieldPartitioner that = (HashFieldPartitioner)o;
        return Objects.equal(this.getSourceName(), that.getSourceName()) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getCardinality(), that.getCardinality());
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceName(), this.getName(), this.getCardinality());
    }

    public String toString() {
        return Objects.toStringHelper(this).add("sourceName", this.getSourceName()).add("name", this.getName()).add("cardinality", this.getCardinality()).toString();
    }
}

