/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.Pair;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.MultiLevelIterator;
import org.kitesdk.data.spi.filesystem.PathConversion;
import org.kitesdk.data.spi.filesystem.PathFilters;
import org.kitesdk.shaded.com.google.common.base.Function;
import org.kitesdk.shaded.com.google.common.base.Joiner;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.kitesdk.shaded.com.google.common.collect.Iterators;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.kitesdk.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSystemPartitionIterator
implements Iterator<Pair<StorageKey, Path>>,
Iterable<Pair<StorageKey, Path>> {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemPartitionIterator.class);
    private static final Joiner PATH_JOINER = Joiner.on("/");
    private final FileSystem fs;
    private final Path rootDirectory;
    private final Iterator<Pair<StorageKey, Path>> iterator;

    FileSystemPartitionIterator(FileSystem fs, Path root, PartitionStrategy strategy, Schema schema, Constraints constraints) throws IOException {
        Preconditions.checkArgument(fs.isDirectory(root));
        this.fs = fs;
        this.rootDirectory = root;
        this.iterator = Iterators.filter(Iterators.transform(new FileSystemIterator(Accessor.getDefault().getFieldPartitioners(strategy).size()), new MakeKey(strategy, schema)), new KeyPredicate(constraints.toKeyPredicate()));
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Pair<StorageKey, Path> next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public Iterator<Pair<StorageKey, Path>> iterator() {
        return this;
    }

    private static class KeyPredicate
    implements Predicate<Pair<StorageKey, Path>> {
        private final Predicate<StorageKey> predicate;

        private KeyPredicate(Predicate<StorageKey> predicate) {
            LOG.debug("StorageKey predicate: {}", predicate);
            this.predicate = predicate;
        }

        @Override
        @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Non-null @Nullable parameter inherited from Function")
        public boolean apply(@Nullable Pair<StorageKey, Path> pair) {
            LOG.debug("Applying predicate {} to key {}", this.predicate, (Object)pair.first());
            return this.predicate.apply(pair.first());
        }
    }

    private static class MakeKey
    implements Function<List<String>, Pair<StorageKey, Path>> {
        private final List<FieldPartitioner> partitioners;
        private final StorageKey reusableKey;
        private final PathConversion convert;

        public MakeKey(PartitionStrategy strategy, Schema schema) {
            this.partitioners = Accessor.getDefault().getFieldPartitioners(strategy);
            this.reusableKey = new StorageKey(strategy);
            this.convert = new PathConversion(schema);
        }

        @Override
        @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Non-null @Nullable parameter inherited from Function")
        public Pair<StorageKey, Path> apply(List<String> dirs) {
            ArrayList<Object> values = Lists.newArrayListWithCapacity(dirs.size());
            int n = this.partitioners.size();
            for (int i = 0; i < n; ++i) {
                values.add(this.convert.valueForDirname(this.partitioners.get(i), dirs.get(i)));
            }
            this.reusableKey.replaceValues(values);
            return Pair.of(this.reusableKey, new Path(PATH_JOINER.join(dirs)));
        }
    }

    class FileSystemIterator
    extends MultiLevelIterator<String> {
        public FileSystemIterator(int depth) throws IOException {
            super(depth);
        }

        @Override
        public Iterable<String> getLevel(List<String> current) {
            LinkedHashSet<String> dirs = Sets.newLinkedHashSet();
            Path dir = FileSystemPartitionIterator.this.rootDirectory;
            int n = current.size();
            for (int i = 0; i < n; ++i) {
                dir = new Path(dir, current.get(i));
            }
            try {
                for (FileStatus stat : FileSystemPartitionIterator.this.fs.listStatus(dir, PathFilters.notHidden())) {
                    if (!stat.isDir()) continue;
                    dirs.add(stat.getPath().getName());
                }
            }
            catch (IOException ex) {
                throw new DatasetException("Cannot list directory:" + dir, ex);
            }
            return dirs;
        }
    }
}

