/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.Conversions;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.collect.ImmutableMap;
import org.kitesdk.shaded.com.google.common.collect.Maps;

public abstract class Marker {
    public abstract boolean has(String var1);

    public abstract Object get(String var1);

    public <T> T getAs(String name, Class<T> returnType) {
        return Conversions.convert(this.get(name), returnType);
    }

    @Nullable
    public <S, T> T valueFor(FieldPartitioner<S, T> fp) {
        if (this.has(fp.getName())) {
            return this.getAs(fp.getName(), fp.getType());
        }
        if (this.has(fp.getSourceName())) {
            return fp.apply(this.getAs(fp.getSourceName(), fp.getSourceType()));
        }
        return null;
    }

    public static class Builder {
        private final Map<String, Object> content;

        public Builder(ImmutableMarker toCopy) {
            this(toCopy.values);
        }

        public Builder(Builder toCopy) {
            this(toCopy.content);
        }

        public Builder(Map<String, Object> content) {
            this.content = Maps.newHashMap(content);
        }

        public Builder(String name, Object value) {
            this.content = Maps.newHashMapWithExpectedSize(1);
            this.content.put(name, value);
        }

        public Builder() {
            this.content = Maps.newHashMap();
        }

        public Builder add(String name, Object value) {
            this.content.put(name, value);
            return this;
        }

        public Marker build() {
            return new ImmutableMarker(this.content);
        }
    }

    @Immutable
    static class ImmutableMarker
    extends Marker {
        final Map<String, Object> values;

        ImmutableMarker(Map<String, Object> content) {
            this.values = ImmutableMap.copyOf(content);
        }

        @Override
        public boolean has(String name) {
            return this.values.containsKey(name);
        }

        @Override
        public Object get(String name) {
            return this.values.get(name);
        }

        public String toString() {
            return Objects.toStringHelper(this).add("values", this.values).toString();
        }

        public int hashCode() {
            return Objects.hashCode(this.values);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            return Objects.equal(this.values, ((ImmutableMarker)obj).values);
        }
    }
}

