/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.SchemaValidationUtil;
import org.kitesdk.shaded.com.google.common.base.Joiner;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.kitesdk.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Compatibility {
    private static final Logger LOG = LoggerFactory.getLogger(Compatibility.class);
    private static Pattern hiveCompatible = Pattern.compile("[a-zA-Z0-9_]+");
    private static Pattern avroCompatible = Pattern.compile("^[A-Za-z_][A-Za-z\\d_]*$");

    public static void check(String namespace, String name, DatasetDescriptor descriptor) {
        Compatibility.checkDatasetName(namespace, name);
        Compatibility.checkDescriptor(descriptor);
    }

    public static void checkAndWarn(String namespace, String datasetName, Schema schema) {
        try {
            Compatibility.checkDatasetName(namespace, datasetName);
            Compatibility.checkSchema(schema);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage());
        }
        catch (IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
    }

    public static void checkDatasetName(String namespace, String name) {
        Preconditions.checkNotNull(namespace, "Namespace cannot be null");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        ValidationException.check(Compatibility.isCompatibleName(namespace), "Namespace %s is not alphanumeric (plus '_')", namespace);
        ValidationException.check(Compatibility.isCompatibleName(name), "Dataset name %s is not alphanumeric (plus '_')", name);
    }

    public static void checkSchema(Schema schema) {
        Preconditions.checkNotNull(schema, "Schema cannot be null");
        List<String> incompatible = Compatibility.getIncompatibleNames(schema);
        ValidationException.check(incompatible.isEmpty(), "Field names are not alphanumeric (plus '_'): %s", Joiner.on(", ").join(incompatible));
    }

    public static void checkDescriptor(DatasetDescriptor descriptor) {
        Preconditions.checkNotNull(descriptor, "Descriptor cannot be null");
        Schema schema = descriptor.getSchema();
        Compatibility.checkSchema(schema);
        if (descriptor.isPartitioned()) {
            Preconditions.checkArgument(schema.getType() == Schema.Type.RECORD, "[BUG] Partitioned datasets must have record schemas");
            HashSet<String> names = Sets.newHashSet();
            for (Schema.Field field : schema.getFields()) {
                names.add(field.name());
            }
            ArrayList<String> incompatible = Lists.newArrayList();
            ArrayList<String> duplicates = Lists.newArrayList();
            for (FieldPartitioner fp : Accessor.getDefault().getFieldPartitioners(descriptor.getPartitionStrategy())) {
                String name = fp.getName();
                if (!Compatibility.isCompatibleName(name)) {
                    incompatible.add(name);
                    continue;
                }
                if (names.contains(name)) {
                    duplicates.add(name);
                    continue;
                }
                names.add(name);
            }
            ValidationException.check(incompatible.isEmpty(), "Partition names are not alphanumeric (plus '_'): %s", Joiner.on(", ").join(incompatible));
            ValidationException.check(duplicates.isEmpty(), "Partition names duplicate data fields: %s", Joiner.on(", ").join(duplicates));
        }
    }

    public static boolean isCompatibleName(String name) {
        return hiveCompatible.matcher(name).matches();
    }

    private static List<String> getIncompatibleNames(Schema schema) {
        NameValidation validation = new NameValidation();
        SchemaUtil.visit(schema, validation);
        return validation.getIncompatibleNames();
    }

    public static boolean isAvroCompatibleName(String name) {
        return avroCompatible.matcher(name).matches();
    }

    public static void checkUpdate(DatasetDescriptor existing, DatasetDescriptor updated) {
        Compatibility.checkNotChanged("location", existing.getLocation(), updated.getLocation());
        Compatibility.checkCompatible(existing, updated);
    }

    public static void checkCompatible(DatasetDescriptor existing, DatasetDescriptor test) {
        Schema testSchema;
        Schema oldSchema;
        Compatibility.checkNotChanged("format", existing.getFormat(), test.getFormat());
        Compatibility.checkNotChanged("partitioning", existing.isPartitioned(), test.isPartitioned());
        if (existing.isPartitioned()) {
            Compatibility.checkNotChanged("partition strategy", existing.getPartitionStrategy(), test.getPartitionStrategy());
        }
        if (!SchemaValidationUtil.canRead(oldSchema = existing.getSchema(), testSchema = test.getSchema())) {
            throw new IncompatibleSchemaException("Schema cannot read data written using existing schema. Schema: " + testSchema.toString(true) + "\nExisting schema: " + oldSchema.toString(true));
        }
    }

    private static void checkNotChanged(String what, @Nullable Object existing, @Nullable Object test) {
        ValidationException.check(existing == test || existing != null && existing.equals(test), "Dataset %s is not compatible with existing: %s != %s", what, String.valueOf(existing), String.valueOf(test));
    }

    private static class NameValidation
    extends SchemaUtil.SchemaVisitor<Void> {
        private List<String> incompatible = Lists.newArrayList();

        private NameValidation() {
        }

        @Override
        public Void record(Schema record, List<String> names, List<Void> fields) {
            String recordName = record.getName();
            for (String name : names) {
                if (Compatibility.isCompatibleName(name)) continue;
                this.incompatible.add(recordName + "." + name);
            }
            return null;
        }

        public List<String> getIncompatibleNames() {
            return this.incompatible;
        }
    }
}

