/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.postgresql;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.airlift.command.Command;
import io.airlift.command.CommandFailedException;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KillBillEmbeddedPostgreSql
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(KillBillEmbeddedPostgreSql.class);
    private static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%s/%s?user=%s";
    private static final String PG_SUPERUSER = "postgres";
    private static final Duration PG_STARTUP_WAIT = new Duration(10.0, TimeUnit.SECONDS);
    private static final Duration COMMAND_TIMEOUT = new Duration(30.0, TimeUnit.SECONDS);
    private final ExecutorService executor = Executors.newCachedThreadPool(KillBillEmbeddedPostgreSql.daemonThreadsNamed("testing-postgresql-server-%s"));
    private final Path serverDirectory;
    private final Path dataDirectory;
    private final int port;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Map<String, String> postgresConfig;
    private final Process postmaster;

    public KillBillEmbeddedPostgreSql() throws IOException {
        this(KillBillEmbeddedPostgreSql.randomPort());
    }

    public KillBillEmbeddedPostgreSql(int port) throws IOException {
        this.port = port;
        this.serverDirectory = Files.createTempDirectory("testing-postgresql-server", new FileAttribute[0]);
        this.dataDirectory = this.serverDirectory.resolve("data");
        this.postgresConfig = ImmutableMap.builder().put((Object)"timezone", (Object)"UTC").put((Object)"synchronous_commit", (Object)"off").put((Object)"checkpoint_segments", (Object)"64").put((Object)"max_connections", (Object)"300").build();
        try {
            this.unpackPostgres(this.serverDirectory);
            this.initdb();
            this.postmaster = this.startPostmaster();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private static int randomPort() throws IOException {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    private static void checkSql(boolean expression, String message) throws SQLException {
        if (!expression) {
            throw new SQLException(message);
        }
    }

    private static String getPlatform() {
        return (StandardSystemProperty.OS_NAME.value() + "-" + StandardSystemProperty.OS_ARCH.value()).replace(' ', '_');
    }

    public String getJdbcUrl(String userName, String dbName) {
        return String.format(JDBC_FORMAT, this.port, dbName, userName);
    }

    public int getPort() {
        return this.port;
    }

    public Connection getPostgresDatabase() throws SQLException {
        return DriverManager.getConnection(this.getJdbcUrl(PG_SUPERUSER, PG_SUPERUSER));
    }

    @Override
    public void close() {
        block3: {
            if (this.closed.getAndSet(true)) {
                return;
            }
            try {
                this.pgStop();
            }
            catch (Exception e) {
                log.error("could not stop postmaster in " + this.serverDirectory.toString(), (Throwable)e);
                if (this.postmaster == null) break block3;
                this.postmaster.destroy();
            }
        }
        KillBillEmbeddedPostgreSql.deleteRecursively(this.serverDirectory.toAbsolutePath().toFile());
        this.executor.shutdownNow();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serverDirectory", (Object)this.serverDirectory).add("port", this.port).toString();
    }

    private void initdb() {
        this.system(this.pgBin("initdb"), "-A", "trust", "-U", PG_SUPERUSER, "-D", this.dataDirectory.toString(), "-E", "UTF-8");
    }

    private Process startPostmaster() throws IOException {
        ArrayList args = Lists.newArrayList((Object[])new String[]{this.pgBin(PG_SUPERUSER), "-D", this.dataDirectory.toString(), "-p", String.valueOf(this.port), "-i", "-F"});
        for (Map.Entry<String, String> config : this.postgresConfig.entrySet()) {
            args.add("-c");
            args.add(config.getKey() + "=" + config.getValue());
        }
        Process process = new ProcessBuilder(args).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.INHERIT).start();
        log.info("postmaster started on port {}. Waiting up to {} for startup to finish.", (Object)this.port, (Object)PG_STARTUP_WAIT);
        this.waitForServerStartup(process);
        return process;
    }

    private void waitForServerStartup(Process process) throws IOException {
        SQLException lastCause = null;
        long start = System.nanoTime();
        while (Duration.nanosSince((long)start).compareTo(PG_STARTUP_WAIT) <= 0) {
            try {
                this.checkReady();
                log.debug("postmaster startup finished");
                return;
            }
            catch (SQLException e) {
                lastCause = e;
                log.debug("while waiting for postmaster startup", (Throwable)e);
                try {
                    int value = process.exitValue();
                    throw new IOException(String.format("postmaster exited with value %d, check stdout for more detail", value));
                }
                catch (IllegalThreadStateException value) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }
        throw new IOException("postmaster failed to start after " + PG_STARTUP_WAIT, lastCause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReady() throws SQLException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getPostgresDatabase();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT 42");
            KillBillEmbeddedPostgreSql.checkSql(resultSet.next(), "no rows in result set");
            KillBillEmbeddedPostgreSql.checkSql(resultSet.getInt(1) == 42, "wrong result");
            KillBillEmbeddedPostgreSql.checkSql(!resultSet.next(), "multiple rows in result set");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private void pgStop() {
        this.system(this.pgBin("pg_ctl"), "stop", "-D", this.dataDirectory.toString(), "-m", "fast", "-t", "5", "-w");
    }

    private String pgBin(String binaryName) {
        return this.serverDirectory.resolve("bin").resolve(binaryName).toString();
    }

    private String system(String ... command) {
        try {
            return new Command(command).setTimeLimit(COMMAND_TIMEOUT).execute((Executor)this.executor).getCommandOutput();
        }
        catch (CommandFailedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackPostgres(Path target) throws IOException {
        String archiveName = String.format("/postgresql-%s.tar.gz", KillBillEmbeddedPostgreSql.getPlatform());
        URL url = KillBillEmbeddedPostgreSql.class.getResource(archiveName);
        if (url == null) {
            throw new RuntimeException("archive not found: " + archiveName);
        }
        File archive = File.createTempFile("postgresql-", null);
        try {
            InputStream in = null;
            try {
                in = url.openStream();
                Files.copy(in, archive.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.system("tar", "-xzf", archive.getPath(), "-C", target.toString());
        }
        finally {
            if (!archive.delete()) {
                log.warn("failed to delete {}", (Object)archive);
            }
        }
    }

    private static boolean deleteRecursively(File file) {
        boolean success = true;
        if (file.isDirectory()) {
            success = KillBillEmbeddedPostgreSql.deleteDirectoryContents(file);
        }
        return file.delete() && success;
    }

    private static boolean deleteDirectoryContents(File directory) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"Not a directory: %s", (Object)directory);
        if (KillBillEmbeddedPostgreSql.isSymbolicLink(directory)) {
            return false;
        }
        boolean success = true;
        for (File file : KillBillEmbeddedPostgreSql.listFiles(directory)) {
            success = KillBillEmbeddedPostgreSql.deleteRecursively(file) && success;
        }
        return success;
    }

    private static boolean isSymbolicLink(File file) {
        try {
            File canonicalFile = file.getCanonicalFile();
            File absoluteFile = file.getAbsoluteFile();
            return !canonicalFile.getName().equals(absoluteFile.getName()) || !canonicalFile.getParent().equals(absoluteFile.getParentFile().getCanonicalPath());
        }
        catch (IOException e) {
            return true;
        }
    }

    private static ImmutableList<File> listFiles(File dir) {
        Object[] files = dir.listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Object[])files);
    }

    private static ThreadFactory daemonThreadsNamed(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(true).setThreadFactory((ThreadFactory)new ContextClassLoaderThreadFactory(Thread.currentThread().getContextClassLoader())).build();
    }

    private static class ContextClassLoaderThreadFactory
    implements ThreadFactory {
        private final ClassLoader classLoader;

        ContextClassLoaderThreadFactory(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setContextClassLoader(this.classLoader);
            return thread;
        }
    }
}

