/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.postgresql;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.embeddeddb.postgresql.KillBillTestingPostgreSqlServer;
import org.postgresql.ds.PGSimpleDataSource;

public class PostgreSQLEmbeddedDB
extends EmbeddedDB {
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected DataSource dataSource;
    protected int port = this.getPort();
    private KillBillTestingPostgreSqlServer testingPostgreSqlServer;

    public PostgreSQLEmbeddedDB() {
        this("database" + UUID.randomUUID().toString().substring(0, 8), "user" + UUID.randomUUID().toString().substring(0, 8));
    }

    public PostgreSQLEmbeddedDB(String databaseName, String username) {
        super(databaseName, username, null, null);
        this.jdbcConnectionString = String.format("jdbc:postgresql://localhost:%s/%s?user=%s", this.port, databaseName, username);
    }

    public EmbeddedDB.DBEngine getDBEngine() {
        return EmbeddedDB.DBEngine.POSTGRESQL;
    }

    public void initialize() throws IOException {
    }

    public void start() throws IOException {
        if (this.started.get()) {
            throw new IOException("PostgreSQL is already running: " + this.jdbcConnectionString);
        }
        this.startPostgreSql();
        this.createDataSource();
        this.refreshTableNames();
    }

    public void refreshTableNames() throws IOException {
        String query = "select table_name from information_schema.tables where table_schema = current_schema() and table_type = 'BASE TABLE';";
        try {
            this.executeQuery("select table_name from information_schema.tables where table_schema = current_schema() and table_type = 'BASE TABLE';", new EmbeddedDB.ResultSetJob(){

                public void work(ResultSet resultSet) throws SQLException {
                    PostgreSQLEmbeddedDB.this.allTables.clear();
                    while (resultSet.next()) {
                        PostgreSQLEmbeddedDB.this.allTables.add(resultSet.getString(1));
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public DataSource getDataSource() throws IOException {
        if (!this.started.get()) {
            throw new IOException("PostgreSQL is not running");
        }
        return this.dataSource;
    }

    public void stop() throws IOException {
        if (!this.started.get()) {
            throw new IOException("PostgreSQL is not running");
        }
        super.stop();
        this.stopPostgreSql();
    }

    public String getCmdLineConnectionString() {
        return String.format("psql -U%s -p%s %s", this.username, this.port, this.databaseName);
    }

    protected void createDataSource() throws IOException {
        if (this.useConnectionPooling()) {
            this.dataSource = this.createHikariDataSource();
        } else {
            PGSimpleDataSource pgSimpleDataSource = new PGSimpleDataSource();
            pgSimpleDataSource.setDatabaseName(this.databaseName);
            pgSimpleDataSource.setUser(this.username);
            pgSimpleDataSource.setUrl(this.jdbcConnectionString);
            this.dataSource = pgSimpleDataSource;
        }
    }

    private void startPostgreSql() throws IOException {
        try {
            this.testingPostgreSqlServer = new KillBillTestingPostgreSqlServer(this.username, this.port, this.databaseName);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.started.set(true);
        logger.info("PostgreSQL started: " + this.getCmdLineConnectionString());
    }

    private void stopPostgreSql() throws IOException {
        if (this.testingPostgreSqlServer != null) {
            this.testingPostgreSqlServer.close();
            this.started.set(false);
            logger.info("PostgreSQL stopped: " + this.getCmdLineConnectionString());
        }
    }
}

