/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.UIServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class UIServicesClientImpl
extends AbstractKieServicesClientImpl
implements UIServicesClient {
    public UIServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public UIServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public String getProcessForm(String containerId, String processId, String language) {
        return this.getProcessFormByType(containerId, processId, language, "ANY");
    }

    @Override
    public String getProcessFormByType(String containerId, String processId, String language, String formType) {
        return this.getProcessFormByType(containerId, processId, language, formType, true);
    }

    @Override
    public String getProcessRawForm(String containerId, String processId) {
        return this.getProcessFormByType(containerId, processId, null, "ANY", false);
    }

    @Override
    public String getProcessForm(String containerId, String processId) {
        return this.getProcessFormByType(containerId, processId, "ANY");
    }

    @Override
    public String getProcessFormByType(String containerId, String processId, String formType) {
        return this.getProcessFormByType(containerId, processId, null, formType, true);
    }

    private String getProcessFormByType(String containerId, String processId, String language, String formType, boolean marshallContent) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            StringBuffer params = new StringBuffer();
            params.append("type=").append(formType);
            params.append("&marshallContent=").append(marshallContent);
            boolean filter = false;
            if (!StringUtils.isEmpty((CharSequence)language)) {
                params.append("&lang=").append(language);
                filter = true;
            }
            params.append("&filter=").append(filter);
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/forms/processes/{processId}", valuesMap) + "?" + params.toString());
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormService", "getFormDisplayProcess", new Object[]{containerId, processId, StringUtils.defaultString((String)language), !StringUtils.isEmpty((CharSequence)language), formType})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }

    @Override
    public String getTaskForm(String containerId, Long taskId, String language) {
        return this.getTaskFormByType(containerId, taskId, language, "ANY");
    }

    @Override
    public String getTaskFormByType(String containerId, Long taskId, String language, String formType) {
        return this.getTaskFormByType(containerId, taskId, language, formType, true);
    }

    private String getTaskFormByType(String containerId, Long taskId, String language, String formType, boolean marshallContent) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            StringBuffer params = new StringBuffer();
            params.append("type=").append(formType);
            params.append("&marshallContent=").append(marshallContent);
            boolean filter = false;
            if (!StringUtils.isEmpty((CharSequence)language)) {
                params.append("&lang=").append(language);
                filter = true;
            }
            params.append("&filter=").append(filter);
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/forms/tasks/{taskInstanceId}", valuesMap) + "?" + params.toString());
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormService", "getFormDisplayTask", new Object[]{containerId, taskId, StringUtils.defaultString((String)language), !StringUtils.isEmpty((CharSequence)language), formType})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }

    @Override
    public String getTaskForm(String containerId, Long taskId) {
        return this.getTaskFormByType(containerId, taskId, "ANY");
    }

    @Override
    public String getTaskFormByType(String containerId, Long taskId, String formType) {
        return this.getTaskFormByType(containerId, taskId, null, formType, true);
    }

    @Override
    public String getTaskRawForm(String containerId, Long taskId) {
        return this.getTaskFormByType(containerId, taskId, null, "ANY", false);
    }

    @Override
    public String getProcessImage(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/svg+xml");
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/images/processes/{processId}", valuesMap), headers);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ImageService", "getProcessImage", new Object[]{containerId, processId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }

    @Override
    public String getProcessInstanceImage(String containerId, Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/svg+xml");
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{containerId}/images/processes/instances/{processInstanceId}", valuesMap), headers);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ImageService", "getActiveProcessImage", new Object[]{containerId, processInstanceId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }

    @Override
    public String getProcessInstanceImageCustomColor(String containerId, Long processInstanceId, String completeNodeColor, String completeNodeBorderColor, String activeNodeBorderColor) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            StringBuffer params = new StringBuffer();
            params.append("svgCompletedColor=").append(this.encode(completeNodeColor));
            params.append("&svgCompletedBorderColor=").append(this.encode(completeNodeBorderColor));
            params.append("&svgActiveBorderColor=").append(this.encode(activeNodeBorderColor));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/svg+xml");
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)("containers/{containerId}/images/processes/instances/{processInstanceId}?" + params.toString()), valuesMap), headers);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ImageService", "getActiveProcessImage", new Object[]{containerId, processInstanceId, StringUtils.defaultString((String)completeNodeColor), StringUtils.defaultString((String)completeNodeBorderColor), StringUtils.defaultString((String)activeNodeBorderColor)})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }

    @Override
    public String renderProcessForm(String containerId, String processId) {
        return this.renderProcessForm(containerId, processId, "patternfly");
    }

    @Override
    public String renderProcessForm(String containerId, String processId, String renderer) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processId", processId);
            StringBuffer params = new StringBuffer();
            if (renderer != null) {
                params.append("?renderer=").append(renderer);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "text/html");
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)("containers/{containerId}/forms/processes/{processId}/content" + params.toString()), valuesMap), headers);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormRendererService", "getProcessRenderedForm", new Object[]{renderer, containerId, processId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }

    @Override
    public String renderCaseForm(String containerId, String caseDefinitionId) {
        return this.renderCaseForm(containerId, caseDefinitionId, "patternfly");
    }

    @Override
    public String renderCaseForm(String containerId, String caseDefinitionId, String renderer) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("caseDefId", caseDefinitionId);
            StringBuffer params = new StringBuffer();
            if (renderer != null) {
                params.append("?renderer=").append(renderer);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "text/html");
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)("containers/{containerId}/forms/cases/{caseDefId}/content" + params.toString()), valuesMap), headers);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormRendererService", "getCaseRenderedForm", new Object[]{renderer, containerId, caseDefinitionId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }

    @Override
    public String renderTaskForm(String containerId, Long taskId) {
        return this.renderTaskForm(containerId, taskId, "patternfly");
    }

    @Override
    public String renderTaskForm(String containerId, Long taskId, String renderer) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            StringBuffer params = new StringBuffer();
            if (renderer != null) {
                params.append("?renderer=").append(renderer);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "text/html");
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)("containers/{containerId}/forms/tasks/{taskInstanceId}/content" + params.toString()), valuesMap), headers);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormRendererService", "getTaskRenderedForm", new Object[]{renderer, containerId, taskId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }
}

