/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.cases;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="case-file")
public class CaseFile {
    @XmlElement(name="case-data")
    private Map<String, Object> data = new HashMap<String, Object>();
    @XmlElement(name="case-user-assignments")
    private Map<String, String> userAssignments = new HashMap<String, String>();
    @XmlElement(name="case-group-assignments")
    private Map<String, String> groupAssignments = new HashMap<String, String>();
    @XmlElement(name="case-data-restrictions")
    private Map<String, String[]> accessRestrictions = new HashMap<String, String[]>();

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public Map<String, String> getUserAssignments() {
        return this.userAssignments;
    }

    public void setUserAssignments(Map<String, String> userAssignments) {
        this.userAssignments = userAssignments;
    }

    public Map<String, String> getGroupAssignments() {
        return this.groupAssignments;
    }

    public void setGroupAssignments(Map<String, String> groupAssignments) {
        this.groupAssignments = groupAssignments;
    }

    public Map<String, String[]> getAccessRestrictions() {
        return this.accessRestrictions;
    }

    public void setAccessRestrictions(Map<String, String[]> accessRestrictions) {
        this.accessRestrictions = accessRestrictions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "CaseFile{data=" + this.data + ", userAssignments=" + this.userAssignments + ", groupAssignments=" + this.groupAssignments + '}';
    }

    public static class Builder {
        private CaseFile caseFile = new CaseFile();

        public CaseFile build() {
            return this.caseFile;
        }

        public Builder data(Map<String, Object> data) {
            this.caseFile.setData(data);
            return this;
        }

        public Builder userAssignments(Map<String, String> data) {
            this.caseFile.setUserAssignments(data);
            return this;
        }

        public Builder groupAssignments(Map<String, String> data) {
            this.caseFile.setGroupAssignments(data);
            return this;
        }

        public Builder addUserAssignments(String role, String user) {
            this.caseFile.getUserAssignments().put(role, user);
            return this;
        }

        public Builder addGroupAssignments(String role, String group) {
            this.caseFile.getGroupAssignments().put(role, group);
            return this;
        }

        public Builder dataAccessRestrictions(Map<String, String[]> accessRestrictions) {
            this.caseFile.setAccessRestrictions(accessRestrictions);
            return this;
        }

        public Builder addDataAccessRestrictions(String dataItem, String ... roles) {
            String[] existingRestrictions = this.caseFile.getAccessRestrictions().get(dataItem);
            if (existingRestrictions == null) {
                existingRestrictions = roles;
            } else {
                String[] result = new String[existingRestrictions.length + roles.length];
                System.arraycopy(existingRestrictions, 0, result, 0, existingRestrictions.length);
                System.arraycopy(roles, 0, result, existingRestrictions.length, roles.length);
                existingRestrictions = result;
            }
            this.caseFile.getAccessRestrictions().put(dataItem, existingRestrictions);
            return this;
        }
    }
}

