/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kie.server.api.model.Severity;

@XmlRootElement(name="kie-message")
@XmlType(name="kie-message")
@XStreamAlias(value="kie-message")
public class Message {
    private Severity severity;
    private Date timestamp;
    private List<String> messages = new ArrayList<String>();

    public Message() {
    }

    public Message(Severity severity, String message) {
        this.severity = severity;
        this.addMessage(message);
        this.timestamp = new Date();
    }

    public Message(Severity severity, List<String> messages) {
        this.severity = severity;
        this.messages = messages;
        this.timestamp = new Date();
    }

    @XmlElement(name="severity")
    public Severity getSeverity() {
        return this.severity;
    }

    @XmlElement(name="content")
    public Collection<String> getMessages() {
        return this.messages;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    @XmlElement(name="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }
}

