/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

public enum MarshallingFormat {
    XSTREAM(0, "xstream"),
    JAXB(1, "xml"),
    JSON(2, "json");

    private final int id;
    private final String type;

    private MarshallingFormat(int id, String type) {
        this.id = id;
        this.type = type;
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public static MarshallingFormat fromId(int id) {
        switch (id) {
            case 0: {
                return XSTREAM;
            }
            case 1: {
                return JAXB;
            }
            case 2: {
                return JSON;
            }
        }
        return null;
    }

    public static MarshallingFormat fromType(String type) {
        if ("xstream".equalsIgnoreCase(type)) {
            return XSTREAM;
        }
        if ("xml".equalsIgnoreCase(type)) {
            return JAXB;
        }
        if ("json".equalsIgnoreCase(type)) {
            return JSON;
        }
        return null;
    }
}

