/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.deser.std.UntypedObjectDeserializer;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.type.JaxbByteArray;

public class JSONMarshaller
implements Marshaller {
    private final ClassLoader classLoader;
    private final ObjectMapper objectMapper;
    private final ObjectMapper fallbackObjectMapper;

    public JSONMarshaller(Set<Class<?>> classes, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.objectMapper = new ObjectMapper();
        if (classes == null) {
            classes = new HashSet();
        }
        classes.add(JaxbByteArray.class);
        List<NamedType> customClasses = this.prepareCustomClasses(classes);
        ExtendedJaxbAnnotationIntrospector primary = new ExtendedJaxbAnnotationIntrospector(customClasses);
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospector.Pair introspectorPair = new AnnotationIntrospector.Pair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        this.objectMapper.setDeserializationConfig(this.objectMapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspectorPair));
        this.objectMapper.setSerializationConfig(this.objectMapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspectorPair).with(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT}));
        if (classes != null && !classes.isEmpty()) {
            ObjectMapper customObjectMapper = new ObjectMapper();
            customObjectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);
            SimpleModule mod = new SimpleModule("custom-object-mapper", Version.unknownVersion());
            mod.addDeserializer(Object.class, (JsonDeserializer)new CustomObjectDeserializer(classes, customObjectMapper));
            CustomObjectSerializer customObjectSerializer = new CustomObjectSerializer(customObjectMapper);
            for (Class<?> clazz : classes) {
                mod.addSerializer(clazz, (JsonSerializer)customObjectSerializer);
            }
            this.objectMapper.registerModule((Module)mod);
        }
        this.fallbackObjectMapper = new ObjectMapper();
    }

    protected List<NamedType> prepareCustomClasses(Set<Class<?>> classes) {
        ArrayList<NamedType> customClasses = new ArrayList<NamedType>();
        if (classes != null) {
            for (Class<?> clazz : classes) {
                customClasses.add(new NamedType(clazz, clazz.getSimpleName()));
                customClasses.add(new NamedType(clazz, clazz.getName()));
            }
        }
        return customClasses;
    }

    @Override
    public String marshall(Object objectInput) {
        try {
            return this.objectMapper.writeValueAsString(this.wrap(objectInput));
        }
        catch (IOException e) {
            throw new MarshallingException("Error marshalling input", e);
        }
    }

    @Override
    public <T> T unmarshall(String serializedInput, Class<T> type) {
        try {
            return (T)this.unwrap(this.objectMapper.readValue(serializedInput, type));
        }
        catch (JsonMappingException e) {
            try {
                return (T)this.unwrap(this.fallbackObjectMapper.readValue(serializedInput, type));
            }
            catch (IOException ex) {
                throw new MarshallingException("Error unmarshalling input", e);
            }
        }
        catch (IOException e) {
            throw new MarshallingException("Error unmarshalling input", e);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public MarshallingFormat getFormat() {
        return MarshallingFormat.JSON;
    }

    protected Object wrap(Object data) {
        if (data instanceof byte[]) {
            return new JaxbByteArray((byte[])data);
        }
        return data;
    }

    protected Object unwrap(Object data) {
        if (data instanceof Wrapped) {
            return ((Wrapped)data).unwrap();
        }
        return data;
    }

    class CustomObjectDeserializer
    extends UntypedObjectDeserializer {
        private static final long serialVersionUID = 7764405880012867708L;
        private Map<String, Class<?>> classes = new HashMap();
        private ObjectMapper customObjectMapper;

        public CustomObjectDeserializer(Set<Class<?>> classes, ObjectMapper customObjectMapper) {
            this.customObjectMapper = customObjectMapper;
            for (Class<?> c : classes) {
                this.classes.put(c.getSimpleName(), c);
                this.classes.put(c.getName(), c);
            }
        }

        protected Object mapObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.START_OBJECT) {
                t = jp.nextToken();
            }
            if (t != JsonToken.FIELD_NAME) {
                return new LinkedHashMap(4);
            }
            String field1 = jp.getText();
            jp.nextToken();
            if (this.classes.containsKey(field1)) {
                Object value = JSONMarshaller.this.objectMapper.readValue(jp, this.classes.get(field1));
                jp.nextToken();
                return value;
            }
            Object value1 = this.deserialize(jp, ctxt);
            if (jp.nextToken() != JsonToken.FIELD_NAME) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(4);
                result.put(field1, value1);
                return result;
            }
            String field2 = jp.getText();
            jp.nextToken();
            Object value2 = this.deserialize(jp, ctxt);
            if (jp.nextToken() != JsonToken.FIELD_NAME) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(4);
                result.put(field1, value1);
                result.put(field2, value2);
                return result;
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put(field1, value1);
            result.put(field2, value2);
            do {
                String fieldName = jp.getText();
                jp.nextToken();
                result.put(fieldName, this.deserialize(jp, ctxt));
            } while (jp.nextToken() != JsonToken.END_OBJECT);
            return result;
        }
    }

    class CustomObjectSerializer
    extends JsonSerializer<Object> {
        private ObjectMapper customObjectMapper;

        public CustomObjectSerializer(ObjectMapper customObjectMapper) {
            this.customObjectMapper = customObjectMapper;
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String json = this.customObjectMapper.writeValueAsString(value);
            jgen.writeRawValue(json);
        }
    }

    class ExtendedJaxbAnnotationIntrospector
    extends JaxbAnnotationIntrospector {
        private List<NamedType> customClasses;

        public ExtendedJaxbAnnotationIntrospector(List<NamedType> customClasses) {
            this.customClasses = customClasses;
        }

        public List<NamedType> findSubtypes(Annotated a) {
            List base = super.findSubtypes(a);
            ArrayList<NamedType> complete = new ArrayList<NamedType>();
            if (base != null) {
                complete.addAll(base);
            }
            if (this.customClasses != null) {
                complete.addAll(this.customClasses);
            }
            return complete;
        }

        public JsonSerializer<?> findSerializer(Annotated am) {
            XmlJavaTypeAdapter adapterInfo = (XmlJavaTypeAdapter)this.findAnnotation(XmlJavaTypeAdapter.class, am, true, false, false);
            if (adapterInfo != null && adapterInfo.value().isAssignableFrom(JaxbUnknownAdapter.class)) {
                return null;
            }
            return super.findSerializer(am);
        }
    }
}

