/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.timer.impl;

import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.kie.kogito.timer.Trigger;

public class SimpleTimerTrigger
implements Trigger {
    public static final int INDEFINITELY = -1;
    private static final Set<ChronoUnit> ACCEPTED_CHRONO_UNITS = SimpleTimerTrigger.acceptedUnits();
    private Date startTime;
    private long period;
    private ChronoUnit periodUnit = ChronoUnit.MILLIS;
    private int repeatCount;
    private Date endTime;
    private String zoneId;
    private int currentRepeatCount;
    private Date nextFireTime;
    private boolean endTimeReached;

    private static Set<ChronoUnit> acceptedUnits() {
        TreeSet<ChronoUnit> units = new TreeSet<ChronoUnit>(Enum::compareTo);
        units.add(ChronoUnit.MILLIS);
        units.add(ChronoUnit.SECONDS);
        units.add(ChronoUnit.MINUTES);
        units.add(ChronoUnit.HOURS);
        units.add(ChronoUnit.DAYS);
        return units;
    }

    public SimpleTimerTrigger() {
    }

    public SimpleTimerTrigger(Date startTime, long period, ChronoUnit periodUnit, int repeatCount, Date endTime, String zoneId) {
        this.validateStartTime(startTime);
        this.validatePeriod(period);
        this.validatePeriodUnit(periodUnit);
        this.validateRepeatCount(repeatCount);
        this.startTime = startTime;
        this.period = period;
        this.periodUnit = periodUnit;
        this.repeatCount = repeatCount;
        this.endTime = endTime;
        this.zoneId = zoneId;
        int n = this.currentRepeatCount = repeatCount == -1 ? -1 : 0;
        if (endTime != null && startTime.after(endTime)) {
            this.nextFireTime = null;
            this.endTimeReached = true;
        } else {
            this.nextFireTime = startTime;
        }
    }

    public SimpleTimerTrigger(Date startTime, long period, ChronoUnit periodUnit, int repeatCount, String zoneId) {
        this(startTime, period, periodUnit, repeatCount, null, zoneId);
    }

    @Override
    public Date hasNextFireTime() {
        return this.nextFireTime;
    }

    @Override
    public synchronized Date nextFireTime() {
        if (this.nextFireTime == null) {
            return null;
        }
        Date current = this.nextFireTime;
        Date candidateNextFireTime = new Date(current.getTime() + this.getPeriodInMillis());
        if (this.endTime != null && candidateNextFireTime.after(this.endTime)) {
            this.nextFireTime = null;
            this.endTimeReached = true;
        } else if (this.repeatCount == -1) {
            this.nextFireTime = candidateNextFireTime;
        } else if (this.currentRepeatCount == Integer.MAX_VALUE || this.currentRepeatCount + 1 > this.repeatCount) {
            this.nextFireTime = null;
        } else {
            this.nextFireTime = candidateNextFireTime;
            ++this.currentRepeatCount;
        }
        return current;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.validateStartTime(startTime);
        this.startTime = startTime;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.validatePeriod(period);
        this.period = period;
    }

    public ChronoUnit getPeriodUnit() {
        return this.periodUnit;
    }

    public void setPeriodUnit(ChronoUnit periodUnit) {
        this.validatePeriodUnit(periodUnit);
        this.periodUnit = periodUnit;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.validateRepeatCount(repeatCount);
        this.repeatCount = repeatCount;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean isEndTimeReached() {
        return this.endTimeReached;
    }

    public void setEndTimeReached(boolean endTimeReached) {
        this.endTimeReached = endTimeReached;
    }

    public boolean isIndefinitely() {
        return this.repeatCount == -1;
    }

    public int getCurrentRepeatCount() {
        return this.currentRepeatCount;
    }

    public void setCurrentRepeatCount(int currentRepeatCount) {
        this.currentRepeatCount = currentRepeatCount;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    private void validateStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("The startTime must be a non null value.");
        }
    }

    private void validatePeriod(long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("The period must be greater or equal than zero, but is: " + period);
        }
    }

    private void validateRepeatCount(int repeatCount) {
        if (repeatCount < -1) {
            throw new IllegalArgumentException("The repeatCount must be greater or equal than zero, or -1 to indicate an indefinitely repeatCount, but is: " + repeatCount);
        }
    }

    private void validatePeriodUnit(ChronoUnit periodUnit) {
        if (periodUnit == null || !ACCEPTED_CHRONO_UNITS.contains(periodUnit)) {
            throw new IllegalArgumentException("The periodUnit must be one of the following values: " + ACCEPTED_CHRONO_UNITS + ", but is: " + periodUnit);
        }
    }

    private long getPeriodInMillis() {
        return this.periodUnit.getDuration().multipliedBy(this.period).toMillis();
    }
}

