/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs;

import java.util.UUID;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;

public class ProcessInstanceJobDescriptionBuilder {
    private String timerId;
    private ExpirationTime expirationTime;
    private Integer priority = ProcessInstanceJobDescription.DEFAULT_PRIORITY;
    private String processInstanceId;
    private String rootProcessInstanceId;
    private String processId;
    private String rootProcessId;
    private String nodeInstanceId;

    public ProcessInstanceJobDescriptionBuilder timerId(String timerId) {
        this.timerId = timerId;
        return this;
    }

    public ProcessInstanceJobDescriptionBuilder generateTimerId() {
        return this.timerId(UUID.randomUUID().toString());
    }

    public ProcessInstanceJobDescriptionBuilder expirationTime(ExpirationTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public ProcessInstanceJobDescriptionBuilder priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public ProcessInstanceJobDescriptionBuilder processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public ProcessInstanceJobDescriptionBuilder rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    public ProcessInstanceJobDescriptionBuilder processId(String processId) {
        this.processId = processId;
        return this;
    }

    public ProcessInstanceJobDescriptionBuilder rootProcessId(String rootProcessId) {
        this.rootProcessId = rootProcessId;
        return this;
    }

    public ProcessInstanceJobDescriptionBuilder nodeInstanceId(String nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
        return this;
    }

    public ProcessInstanceJobDescription build() {
        return new ProcessInstanceJobDescription(this.timerId, this.expirationTime, this.priority, this.processInstanceId, this.rootProcessInstanceId, this.processId, this.rootProcessId, this.nodeInstanceId);
    }
}

