/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.core.ast.DecisionServiceNodeImpl;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.model.api.DMNElementReference;

public class DMNModelIOSets {
    private final DMNModel model;
    private CompositeTypeImpl inputSet;
    private CompositeTypeImpl outputSet;
    private final Map<String, DSIOSets> dsIOSets = new LinkedHashMap<String, DSIOSets>();
    protected static final String TEMP = "<temp>";

    public DMNModelIOSets(DMNModel model) {
        this.model = model;
        this.buildInputSet();
        this.buildOutputSet();
        for (DecisionServiceNode ds : model.getDecisionServices()) {
            this.dsIOSets.put(ds.getName(), new DSIOSets(model, ds));
        }
    }

    private void buildOutputSet() {
        DMNType idnType;
        CompositeTypeImpl is = new CompositeTypeImpl(this.model.getNamespace(), TEMP, this.model.getDefinitions().getId() + "OutputSet");
        for (DecisionNode dn : this.model.getDecisions()) {
            idnType = dn.getResultType();
            is.addField(dn.getName(), idnType);
        }
        for (InputDataNode idn : this.model.getInputs()) {
            idnType = idn.getType();
            is.addField(idn.getName(), idnType);
        }
        this.outputSet = is;
    }

    private void buildInputSet() {
        CompositeTypeImpl is = new CompositeTypeImpl(this.model.getNamespace(), TEMP, this.model.getDefinitions().getId() + "InputSet");
        for (InputDataNode idn : this.model.getInputs()) {
            DMNType idnType = idn.getType();
            is.addField(idn.getName(), idnType);
        }
        this.inputSet = is;
    }

    public Collection<DSIOSets> getDSIOSets() {
        return this.dsIOSets.values();
    }

    public DSIOSets lookupDSIOSetsByName(String name) {
        return this.dsIOSets.get(name);
    }

    public DMNModel getModel() {
        return this.model;
    }

    public DMNType getInputSet() {
        return this.inputSet;
    }

    public DMNType getOutputSet() {
        return this.outputSet;
    }

    public void setInputSetName(String name) {
        this.inputSet.setName(name);
    }

    public void setOutputSetName(String name) {
        this.outputSet.setName(name);
    }

    public static class DSIOSets {
        private final DMNModel model;
        private final DecisionServiceNode ds;
        private CompositeTypeImpl inputSet;
        private BaseDMNTypeImpl outputSet;

        public DSIOSets(DMNModel model, DecisionServiceNode ds) {
            this.model = model;
            this.ds = ds;
            this.buildInputSet();
            this.buildOutputSet();
        }

        private void buildOutputSet() {
            if (this.ds.getDecisionService().getOutputDecision().size() == 1) {
                String id = DMNCompilerImpl.getId((DMNElementReference)((DMNElementReference)this.ds.getDecisionService().getOutputDecision().get(0)));
                DecisionNode outputDecision = this.model.getDecisionById(id);
                this.outputSet = new SimpleTypeImpl(this.ds.getModelNamespace(), DMNModelIOSets.TEMP, this.ds.getId() + "DSOutputSet", false, null, outputDecision != null ? outputDecision.getResultType() : this.ds.getResultType(), null);
            } else {
                CompositeTypeImpl is = new CompositeTypeImpl(this.ds.getModelNamespace(), DMNModelIOSets.TEMP, this.ds.getId() + "DSOutputSet");
                for (DMNElementReference er : this.ds.getDecisionService().getOutputDecision()) {
                    String id = DMNCompilerImpl.getId((DMNElementReference)er);
                    DecisionNode outputDecision = this.model.getDecisionById(id);
                    if (outputDecision == null) {
                        this.outputSet = new SimpleTypeImpl(this.ds.getModelNamespace(), DMNModelIOSets.TEMP, this.ds.getId() + "DSOutputSet", false, null, this.ds.getResultType(), null);
                        return;
                    }
                    is.addField(outputDecision.getName(), outputDecision.getResultType());
                    this.outputSet = is;
                }
            }
        }

        private void buildInputSet() {
            CompositeTypeImpl is = new CompositeTypeImpl(this.ds.getModelNamespace(), DMNModelIOSets.TEMP, this.ds.getId() + "DSInputSet");
            DecisionServiceNodeImpl dsNodeImpl = (DecisionServiceNodeImpl)this.ds;
            for (DMNNode node : dsNodeImpl.getInputParameters().values()) {
                DMNType idnType;
                if (node instanceof InputDataNode) {
                    InputDataNode idn = (InputDataNode)node;
                    idnType = idn.getType();
                    is.addField(idn.getName(), idnType);
                    continue;
                }
                if (!(node instanceof DecisionNode)) continue;
                DecisionNode dn = (DecisionNode)node;
                idnType = dn.getResultType();
                is.addField(dn.getName(), idnType);
            }
            this.inputSet = is;
        }

        public DecisionServiceNode getDS() {
            return this.ds;
        }

        public DMNType getDSInputSet() {
            return this.inputSet;
        }

        public DMNType getDSOutputSet() {
            return this.outputSet;
        }

        public void setDSInputSetName(String name) {
            this.inputSet.setName(name);
        }

        public void setDSOutputSetName(String name) {
            if (this.outputSet.getName().equals(DMNModelIOSets.TEMP)) {
                this.outputSet.setName(name);
            }
        }
    }
}

