/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.typesafe.DMNTypeUtils;

public class FEELBuiltinTypeSchemas {
    public static Schema from(DMNType t) {
        BuiltInType builtin = DMNTypeUtils.getFEELBuiltInType((DMNType)t);
        if (builtin == BuiltInType.DURATION) {
            return FEELBuiltinTypeSchemas.convertDurationToSchema(t);
        }
        return FEELBuiltinTypeSchemas.convertBuiltInToJavaClass(builtin);
    }

    private static Schema convertDurationToSchema(DMNType t) {
        switch (t.getName()) {
            case "years and months duration": 
            case "yearMonthDuration": {
                return ((Schema)OASFactory.createObject(Schema.class)).description("FEEL:years and months duration").type(Schema.SchemaType.STRING).format("years and months duration").example((Object)"P1Y2M");
            }
            case "days and time duration": 
            case "dayTimeDuration": {
                return ((Schema)OASFactory.createObject(Schema.class)).description("FEEL:days and time duration").type(Schema.SchemaType.STRING).format("days and time duration").example((Object)"P1D");
            }
        }
        throw new IllegalArgumentException();
    }

    private static Schema convertBuiltInToJavaClass(BuiltInType builtin) {
        switch (builtin) {
            case UNKNOWN: {
                return ((Schema)OASFactory.createObject(Schema.class)).description("FEEL:Any");
            }
            case DATE: {
                return ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING).format("date").description("FEEL:date");
            }
            case TIME: {
                return ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING).format("time").description("FEEL:time");
            }
            case DATE_TIME: {
                return ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.OBJECT).format("date-time").description("FEEL:date and time");
            }
            case BOOLEAN: {
                return ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.BOOLEAN).description("FEEL:boolean");
            }
            case NUMBER: {
                return ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.NUMBER).description("FEEL:number");
            }
            case STRING: {
                return ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING).description("FEEL:string");
            }
        }
        throw new IllegalArgumentException();
    }

    private FEELBuiltinTypeSchemas() {
    }
}

