/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.internal.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryImpl {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryImpl.class);
    private static final String CONF_FILE_NAME = "kie.conf";
    private static final String CONF_FILE_PATH = "META-INF/kie.conf";
    private Map<String, Object> services = new HashMap<String, Object>();
    private Map<String, List<?>> childServices = new HashMap();
    private boolean sealed = false;
    private boolean kiecConfDiscoveryAllowed = true;
    private Map<String, Object> cachedServices = new HashMap<String, Object>();

    private ServiceDiscoveryImpl() {
    }

    public static ServiceDiscoveryImpl getInstance() {
        return LazyHolder.INSTANCE;
    }

    public synchronized boolean isKiecConfDiscoveryAllowed() {
        return this.kiecConfDiscoveryAllowed;
    }

    public synchronized void setKiecConfDiscoveryAllowed(boolean kiecConfDiscoveryAllowed) {
        this.kiecConfDiscoveryAllowed = kiecConfDiscoveryAllowed;
    }

    public <T> void addService(Class<T> serviceClass, T service) {
        this.addService(serviceClass.getCanonicalName(), service);
    }

    public synchronized void addService(String serviceName, Object object) {
        if (this.sealed) {
            throw new IllegalStateException("Unable to add service '" + serviceName + "'. Services cannot be added once the ServiceDiscoverys is sealed");
        }
        this.cachedServices.put(serviceName, object);
    }

    public synchronized void reset() {
        this.cachedServices = new HashMap<String, Object>();
        this.sealed = false;
    }

    public synchronized Map<String, Object> getServices() {
        if (!this.sealed) {
            if (this.kiecConfDiscoveryAllowed) {
                this.getKieConfs().ifPresent(kieConfs -> {
                    while (((KieConfs)kieConfs).resources.hasMoreElements()) {
                        this.registerConfs(((KieConfs)kieConfs).classLoader, (URL)((KieConfs)kieConfs).resources.nextElement());
                    }
                });
                this.buildMap();
            }
            this.cachedServices = Collections.unmodifiableMap(this.cachedServices);
            this.sealed = true;
        }
        return this.cachedServices;
    }

    public void registerConfs(ClassLoader classLoader, URL url) {
        log.debug("Loading kie.conf from  " + url + " in classloader " + classLoader);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line = br.readLine();
            while (line != null) {
                if (line.contains("=") && !line.contains("[")) {
                    String[] entry = line.split("=");
                    this.processKieService(classLoader, entry[0].trim(), entry[1].trim());
                }
                line = br.readLine();
            }
        }
        catch (Exception exc) {
            throw new RuntimeException("Unable to build kie service url = " + url.toExternalForm(), exc);
        }
    }

    private void processKieService(ClassLoader classLoader, String key, String values) {
        for (String value : values.split(",")) {
            boolean optional = key.startsWith("?");
            String serviceName = optional ? key.substring(1) : key;
            try {
                if (value.startsWith("+")) {
                    this.childServices.computeIfAbsent(serviceName, k -> new ArrayList()).add(this.newInstance(classLoader, value.substring(1)));
                } else {
                    this.services.put(serviceName, this.newInstance(classLoader, value));
                }
            }
            catch (RuntimeException e) {
                if (optional) {
                    log.info("Cannot load service: " + serviceName);
                }
                System.out.println("Loading failed because " + e.getMessage());
                throw e;
            }
            log.debug("Adding Service {}\n", (Object)value);
        }
    }

    private <T> T newInstance(ClassLoader classLoader, String className) {
        try {
            return (T)Class.forName(className, true, classLoader).newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot create instance of class: " + className, t);
        }
    }

    private Optional<KieConfs> getKieConfs() {
        return Stream.of(this.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()).map(this::loadKieConfs).filter(Objects::nonNull).findFirst();
    }

    private KieConfs loadKieConfs(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        try {
            Enumeration<URL> resources = cl.getResources(CONF_FILE_PATH);
            return resources.hasMoreElements() ? new KieConfs(cl, resources) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void buildMap() {
        for (Map.Entry<String, Object> serviceEntry : this.services.entrySet()) {
            this.cachedServices.put(serviceEntry.getKey(), serviceEntry.getValue());
            List<?> children = this.childServices.remove(serviceEntry.getKey());
            if (children == null) continue;
            for (Object child : children) {
                ((Consumer)serviceEntry.getValue()).accept(child);
            }
        }
        if (!this.childServices.isEmpty()) {
            throw new RuntimeException("Child services " + this.childServices.keySet() + " have no parent");
        }
    }

    private static class KieConfs {
        private final ClassLoader classLoader;
        private final Enumeration<URL> resources;

        private KieConfs(ClassLoader classLoader, Enumeration<URL> confResources) {
            this.classLoader = classLoader;
            this.resources = confResources;
        }
    }

    @FunctionalInterface
    private static interface ServiceProcessor {
        public boolean process(ClassLoader var1, String var2, String var3);
    }

    private static class LazyHolder {
        static final ServiceDiscoveryImpl INSTANCE = new ServiceDiscoveryImpl();

        private LazyHolder() {
        }
    }
}

