/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.executor;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.query.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ExecutorService {
    public static final String EXECUTOR_ID = IdProvider.get();

    public List<RequestInfo> getQueuedRequests(QueryContext var1);

    public List<RequestInfo> getCompletedRequests(QueryContext var1);

    public List<RequestInfo> getInErrorRequests(QueryContext var1);

    public List<RequestInfo> getCancelledRequests(QueryContext var1);

    public List<ErrorInfo> getAllErrors(QueryContext var1);

    public List<RequestInfo> getAllRequests(QueryContext var1);

    public List<RequestInfo> getRequestsByStatus(List<STATUS> var1, QueryContext var2);

    public List<RequestInfo> getRequestsByBusinessKey(String var1, QueryContext var2);

    public List<RequestInfo> getRequestsByBusinessKey(String var1, List<STATUS> var2, QueryContext var3);

    public List<RequestInfo> getRequestsByCommand(String var1, QueryContext var2);

    public List<RequestInfo> getRequestsByCommand(String var1, List<STATUS> var2, QueryContext var3);

    public List<RequestInfo> getRequestsByDeployment(String var1, List<STATUS> var2, QueryContext var3);

    public List<RequestInfo> getRequestsByProcessInstance(Long var1, List<STATUS> var2, QueryContext var3);

    public int clearAllRequests();

    public int clearAllErrors();

    public Long scheduleRequest(String var1, CommandContext var2);

    public void cancelRequest(Long var1);

    public void updateRequestData(Long var1, Map<String, Object> var2);

    public void init();

    public void destroy();

    public boolean isActive();

    public int getInterval();

    public void setInterval(int var1);

    public int getRetries();

    public void setRetries(int var1);

    public int getThreadPoolSize();

    public void setThreadPoolSize(int var1);

    public TimeUnit getTimeunit();

    public void setTimeunit(TimeUnit var1);

    public List<RequestInfo> getPendingRequests(QueryContext var1);

    public List<RequestInfo> getPendingRequestById(Long var1);

    public Long scheduleRequest(String var1, Date var2, CommandContext var3);

    public List<RequestInfo> getRunningRequests(QueryContext var1);

    public List<RequestInfo> getFutureQueuedRequests(QueryContext var1);

    public RequestInfo getRequestById(Long var1);

    public List<ErrorInfo> getErrorsByRequestId(Long var1);

    public static class IdProvider {
        private static boolean initialized = false;
        private static String EXECUTOR_ID;
        private static Logger logger;

        public static String get() {
            if (!initialized) {
                EXECUTOR_ID = IdProvider.create();
            }
            return EXECUTOR_ID;
        }

        private static synchronized String create() {
            initialized = true;
            String idSystemProperty = System.getProperty("org.kie.executor.id", System.getProperty("org.uberfire.cluster.local.id", "default-executor"));
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/jbpm-executor.properties");
                if (is != null) {
                    Properties executorProps = new Properties();
                    executorProps.load(is);
                    return idSystemProperty + "-" + executorProps.getProperty("executor.id");
                }
            }
            catch (Exception e) {
                logger.warn("Unable to find executor id due to '{}', using default...", (Object)e.getMessage());
            }
            return idSystemProperty;
        }

        static {
            logger = LoggerFactory.getLogger(RuntimeManagerFactory.Factory.class);
        }
    }
}

