/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.core.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.efesto.common.api.cache.EfestoClassKey;
import org.kie.efesto.common.api.cache.EfestoIdentifierClassKey;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.service.KieRuntimeService;
import org.kie.efesto.runtimemanager.api.utils.SPIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeManagerUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)RuntimeManagerUtils.class.getName());
    protected static final Map<EfestoClassKey, List<KieRuntimeService>> firstLevelCache = new HashMap<EfestoClassKey, List<KieRuntimeService>>();
    protected static final Map<EfestoIdentifierClassKey, KieRuntimeService> secondLevelCache = new HashMap<EfestoIdentifierClassKey, KieRuntimeService>();

    private RuntimeManagerUtils() {
    }

    static void populateFirstLevelCache(Map<EfestoClassKey, List<KieRuntimeService>> toPopulate) {
        List discoveredKieRuntimeServices = SPIUtils.getDiscoveredKieRuntimeServices();
        RuntimeManagerUtils.populateFirstLevelCache(discoveredKieRuntimeServices, toPopulate);
    }

    static void populateFirstLevelCache(List<KieRuntimeService> discoveredKieRuntimeServices, Map<EfestoClassKey, List<KieRuntimeService>> toPopulate) {
        discoveredKieRuntimeServices.forEach(kieRuntimeService -> {
            EfestoClassKey efestoClassKey = kieRuntimeService.getEfestoClassKeyIdentifier();
            toPopulate.merge(efestoClassKey, List.of(kieRuntimeService), (previous, toAdd) -> {
                ArrayList toReturn = new ArrayList();
                toReturn.addAll(previous);
                toReturn.addAll(toAdd);
                return toReturn;
            });
        });
    }

    static Optional<KieRuntimeService> getKieRuntimeServiceLocal(EfestoRuntimeContext context, EfestoInput input) {
        KieRuntimeService cachedKieRuntimeService = RuntimeManagerUtils.getKieRuntimeServiceFromSecondLevelCache(input);
        if (cachedKieRuntimeService != null) {
            return Optional.of(cachedKieRuntimeService);
        }
        Optional<KieRuntimeService> retrieved = RuntimeManagerUtils.getKieRuntimeServiceFromFirstLevelCache(context, input);
        if (retrieved.isEmpty()) {
            retrieved = RuntimeManagerUtils.getKieRuntimeServiceFromEfestoRuntimeContextLocal(context, input);
        }
        if (retrieved.isEmpty()) {
            logger.warn("Cannot find KieRuntimeService for {}", (Object)input.getModelLocalUriId());
        } else {
            secondLevelCache.put(input.getSecondLevelCacheKey(), retrieved.get());
        }
        return retrieved;
    }

    static KieRuntimeService getKieRuntimeServiceFromSecondLevelCache(EfestoInput input) {
        return secondLevelCache.get(input.getSecondLevelCacheKey());
    }

    static Optional<KieRuntimeService> getKieRuntimeServiceFromFirstLevelCache(EfestoRuntimeContext context, EfestoInput input) {
        List<KieRuntimeService> discoveredServices = firstLevelCache.get(input.getFirstLevelCacheKey());
        return discoveredServices != null && !discoveredServices.isEmpty() ? SPIUtils.getKieRuntimeService(discoveredServices, (EfestoInput)input, (EfestoRuntimeContext)context) : Optional.empty();
    }

    static Optional<KieRuntimeService> getKieRuntimeServiceFromEfestoRuntimeContextLocal(EfestoRuntimeContext context, EfestoInput input) {
        logger.warn("Cannot find KieRuntimeService for {}, looking inside context classloader", (Object)input.getModelLocalUriId());
        Optional retrieved = SPIUtils.getKieRuntimeServiceFromEfestoRuntimeContext((EfestoInput)input, (EfestoRuntimeContext)context);
        if (retrieved.isPresent()) {
            KieRuntimeService toAdd = (KieRuntimeService)retrieved.get();
            List<KieRuntimeService> stored = firstLevelCache.get(input.getFirstLevelCacheKey());
            if (stored == null) {
                stored = new ArrayList<KieRuntimeService>();
                firstLevelCache.put(input.getFirstLevelCacheKey(), stored);
            }
            stored.add(toAdd);
        }
        return retrieved;
    }

    static Optional<EfestoOutput> getOptionalOutput(EfestoRuntimeContext context, EfestoInput input) {
        Optional<KieRuntimeService> retrieved = RuntimeManagerUtils.getKieRuntimeServiceLocal(context, input);
        return retrieved.isPresent() ? retrieved.flatMap(kieRuntimeService -> kieRuntimeService.evaluateInput(input, context)) : Optional.empty();
    }

    static {
        RuntimeManagerUtils.populateFirstLevelCache(firstLevelCache);
    }
}

