/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.core.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.efesto.runtimemanager.api.utils.SPIUtils;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeManagerImpl
implements RuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger((String)RuntimeManagerImpl.class.getName());

    public Collection<EfestoOutput> evaluateInput(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader, EfestoInput ... toEvaluate) {
        LinkedHashSet<EfestoOutput> toReturn = new LinkedHashSet<EfestoOutput>();
        Arrays.stream(toEvaluate).forEach(input -> {
            Optional<EfestoOutput> output = this.getOptionalOutput(memoryCompilerClassLoader, (EfestoInput)input);
            output.ifPresent(toReturn::add);
        });
        return toReturn;
    }

    private Optional<EfestoOutput> getOptionalOutput(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader, EfestoInput input) {
        Optional retrieved = SPIUtils.getKieRuntimeService((EfestoInput)input, (boolean)false, (KieMemoryCompiler.MemoryCompilerClassLoader)memoryCompilerClassLoader);
        if (!retrieved.isPresent()) {
            logger.warn("Cannot find KieRuntimeService for {}", (Object)input.getFRI());
            return Optional.empty();
        }
        return retrieved.flatMap(kieRuntimeService -> kieRuntimeService.evaluateInput(input, memoryCompilerClassLoader));
    }
}

