/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kie.efesto.common.api.cache.EfestoClassKey;
import org.kie.efesto.common.api.cache.EfestoIdentifierClassKey;
import org.kie.efesto.common.api.model.EfestoRuntimeContext;
import org.kie.efesto.common.api.utils.CollectionUtils;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;
import org.kie.efesto.runtimemanager.api.service.KieRuntimeService;
import org.kie.efesto.runtimemanager.api.utils.SPIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeManagerUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)RuntimeManagerUtils.class.getName());
    public static final Map<EfestoClassKey, List<KieRuntimeService>> firstLevelCache = new HashMap<EfestoClassKey, List<KieRuntimeService>>();
    public static final Map<EfestoIdentifierClassKey, KieRuntimeService> secondLevelCache = new HashMap<EfestoIdentifierClassKey, KieRuntimeService>();

    private RuntimeManagerUtils() {
    }

    public static void init() {
        logger.debug("init");
        RuntimeManagerUtils.populateFirstLevelCache(firstLevelCache);
    }

    public static void addKieRuntimeServiceToFirstLevelCache(KieRuntimeService discoveredKieRuntimeService) {
        logger.info("addKieRuntimeServiceToFirstLevelCache");
        logger.debug("{}", (Object)discoveredKieRuntimeService);
        RuntimeManagerUtils.populateFirstLevelCache(discoveredKieRuntimeService, firstLevelCache);
    }

    public static Optional<EfestoOutput> getOptionalOutput(EfestoRuntimeContext context, EfestoInput input) {
        logger.debug("getOptionalOutput");
        logger.trace("{} {}", (Object)context, (Object)input);
        Optional<KieRuntimeService> retrieved = RuntimeManagerUtils.getKieRuntimeServiceLocal(context, input);
        return retrieved.isPresent() ? retrieved.flatMap(kieRuntimeService -> kieRuntimeService.evaluateInput(input, context)) : Optional.empty();
    }

    public static Optional<EfestoInput> getOptionalInput(String modelLocalUriIdString, String inputDataString) {
        logger.debug("getOptionalInput");
        logger.trace("{} {}", (Object)modelLocalUriIdString, (Object)inputDataString);
        List efestoInputs = firstLevelCache.values().stream().flatMap(kieRuntimeServices -> kieRuntimeServices.stream()).map(kieRuntimeService -> kieRuntimeService.parseJsonInput(modelLocalUriIdString, inputDataString)).filter(optional -> optional.isPresent()).map(optional -> (EfestoInput)optional.get()).collect(Collectors.toList());
        return CollectionUtils.findAtMostOne(efestoInputs, (s1, s2) -> new KieRuntimeServiceException("Found more than one EfestoInput: " + s1 + " and " + s2));
    }

    static void populateFirstLevelCache(Map<EfestoClassKey, List<KieRuntimeService>> toPopulate) {
        logger.debug("populateFirstLevelCache");
        logger.trace("{}", toPopulate);
        List<KieRuntimeService> discoveredKieRuntimeServices = RuntimeManagerUtils.getKieRuntimeServiceFromRuntimeServiceProviders();
        logger.trace("discoveredKieRuntimeServices {}", discoveredKieRuntimeServices);
        RuntimeManagerUtils.populateFirstLevelCache(discoveredKieRuntimeServices, toPopulate);
    }

    static void populateFirstLevelCache(List<KieRuntimeService> discoveredKieRuntimeServices, Map<EfestoClassKey, List<KieRuntimeService>> toPopulate) {
        logger.debug("populateFirstLevelCache");
        logger.trace("{} {}", discoveredKieRuntimeServices, toPopulate);
        for (KieRuntimeService kieRuntimeService : discoveredKieRuntimeServices) {
            RuntimeManagerUtils.populateFirstLevelCache(kieRuntimeService, toPopulate);
        }
    }

    static void populateFirstLevelCache(KieRuntimeService kieRuntimeService, Map<EfestoClassKey, List<KieRuntimeService>> toPopulate) {
        logger.debug("populateFirstLevelCache");
        logger.trace("{} {}", (Object)kieRuntimeService, toPopulate);
        EfestoClassKey efestoClassKey = kieRuntimeService.getEfestoClassKeyIdentifier();
        toPopulate.merge(efestoClassKey, new ArrayList<KieRuntimeService>(Collections.singletonList(kieRuntimeService)), (previous, toAdd) -> {
            ArrayList toReturn = new ArrayList();
            toReturn.addAll(previous);
            toReturn.addAll(toAdd);
            return toReturn;
        });
    }

    static Optional<KieRuntimeService> getKieRuntimeServiceLocal(EfestoRuntimeContext context, EfestoInput input) {
        logger.debug("getKieRuntimeServiceLocal");
        logger.trace("{} {}", (Object)context, (Object)input);
        KieRuntimeService cachedKieRuntimeService = RuntimeManagerUtils.getKieRuntimeServiceFromSecondLevelCache(input);
        logger.trace("cachedKieRuntimeService {}", (Object)cachedKieRuntimeService);
        if (cachedKieRuntimeService != null) {
            return Optional.of(cachedKieRuntimeService);
        }
        Optional<KieRuntimeService> retrieved = RuntimeManagerUtils.getKieRuntimeServiceFromFirstLevelCache(context, input);
        if (retrieved.isEmpty()) {
            logger.warn("Cannot find KieRuntimeService for {}", (Object)input.getModelLocalUriId());
        } else {
            secondLevelCache.put(input.getSecondLevelCacheKey(), retrieved.get());
        }
        return retrieved;
    }

    static KieRuntimeService getKieRuntimeServiceFromSecondLevelCache(EfestoInput input) {
        return secondLevelCache.get(input.getSecondLevelCacheKey());
    }

    static Optional<KieRuntimeService> getKieRuntimeServiceFromFirstLevelCache(EfestoRuntimeContext context, EfestoInput input) {
        logger.debug("getKieRuntimeServiceFromFirstLevelCache");
        logger.trace("{} {}", (Object)context, (Object)input);
        List<KieRuntimeService> discoveredServices = firstLevelCache.get(input.getFirstLevelCacheKey());
        logger.trace("firstLevelCache.keySet() {}", firstLevelCache.keySet());
        logger.trace("discoveredServices {}", discoveredServices);
        return discoveredServices != null && !discoveredServices.isEmpty() ? SPIUtils.getKieRuntimeService(discoveredServices, (EfestoInput)input, (EfestoRuntimeContext)context) : Optional.empty();
    }

    static List<KieRuntimeService> getKieRuntimeServiceFromRuntimeServiceProviders() {
        logger.debug("getKieRuntimeServiceFromRuntimeServiceProviders");
        List runtimeServiceProviders = SPIUtils.getRuntimeServiceProviders((boolean)true);
        logger.trace("runtimeServiceProviders {}", (Object)runtimeServiceProviders);
        return runtimeServiceProviders.stream().flatMap(runtimeServiceProvider -> runtimeServiceProvider.getKieRuntimeServices().stream()).collect(Collectors.toList());
    }

    static void addKieRuntimeServiceToFirstLevelCache(KieRuntimeService toAdd, EfestoClassKey firstLevelClassKey) {
        logger.debug("addKieRuntimeServiceToFirstLevelCache");
        logger.trace("{} {}", (Object)toAdd, (Object)firstLevelClassKey);
        List<KieRuntimeService> stored = firstLevelCache.get(firstLevelClassKey);
        if (stored == null) {
            stored = new ArrayList<KieRuntimeService>();
            firstLevelCache.put(firstLevelClassKey, stored);
        }
        stored.add(toAdd);
    }

    static {
        RuntimeManagerUtils.init();
    }
}

