/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.api.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.common.api.model.GeneratedClassResource;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.common.api.model.GeneratedRedirectResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.api.utils.FileUtils;
import org.kie.efesto.common.api.utils.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratedResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)GeneratedResourceUtils.class.getName());

    private GeneratedResourceUtils() {
    }

    public static boolean isPresentExecutableOrRedirect(FRI fri, String modelType) {
        return Stream.of(GeneratedResourceUtils.getGeneratedExecutableResource(fri, modelType), GeneratedResourceUtils.getGeneratedRedirectResource(fri, modelType)).anyMatch(Optional::isPresent);
    }

    public static Optional<GeneratedExecutableResource> getGeneratedExecutableResource(FRI fri, String modelType) {
        return GeneratedResourceUtils.getIndexFile(modelType).flatMap(indexFile -> {
            try {
                GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                return generatedResources.stream().filter(generatedResource -> generatedResource instanceof GeneratedExecutableResource && ((GeneratedExecutableResource)generatedResource).getFri().equals((Object)fri)).findFirst().map(GeneratedExecutableResource.class::cast);
            }
            catch (IOException e) {
                logger.debug("Failed to read GeneratedResources from {}.", (Object)indexFile.getName(), (Object)e);
                return Optional.empty();
            }
        });
    }

    public static Optional<GeneratedRedirectResource> getGeneratedRedirectResource(FRI fri, String modelType) {
        return GeneratedResourceUtils.getIndexFile(modelType).flatMap(indexFile -> {
            try {
                GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                return generatedResources.stream().filter(generatedResource -> generatedResource instanceof GeneratedRedirectResource && ((GeneratedRedirectResource)generatedResource).getFri().equals((Object)fri)).findFirst().map(GeneratedRedirectResource.class::cast);
            }
            catch (IOException e) {
                logger.debug("Failed to read GeneratedResources from {}.", (Object)indexFile.getName(), (Object)e);
                return Optional.empty();
            }
        });
    }

    public static Collection<GeneratedExecutableResource> getAllGeneratedExecutableResources(String modelType) {
        HashSet<GeneratedExecutableResource> toReturn = new HashSet<GeneratedExecutableResource>();
        GeneratedResourceUtils.getIndexFile(modelType).ifPresent(indexFile -> {
            try {
                GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                toReturn.addAll(generatedResources.stream().filter(generatedResource -> generatedResource instanceof GeneratedExecutableResource).map(GeneratedExecutableResource.class::cast).collect(Collectors.toSet()));
            }
            catch (IOException e) {
                logger.debug("Failed to read GeneratedClassResource from {}.", (Object)indexFile.getName(), (Object)e);
            }
        });
        return toReturn;
    }

    public static Collection<GeneratedClassResource> getAllGeneratedClassResources(String modelType) {
        HashSet<GeneratedClassResource> toReturn = new HashSet<GeneratedClassResource>();
        GeneratedResourceUtils.getIndexFile(modelType).ifPresent(indexFile -> {
            try {
                GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                toReturn.addAll(generatedResources.stream().filter(generatedResource -> generatedResource instanceof GeneratedClassResource).map(GeneratedClassResource.class::cast).collect(Collectors.toSet()));
            }
            catch (IOException e) {
                logger.debug("Failed to read GeneratedClassResource from {}.", (Object)indexFile.getName(), (Object)e);
            }
        });
        return toReturn;
    }

    public static Optional<IndexFile> getIndexFile(String modelType) {
        IndexFile toSearch = new IndexFile(modelType);
        return FileUtils.getFileFromFileName((String)toSearch.getName()).map(IndexFile::new);
    }
}

