/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.compilationmanager.api.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import org.kie.efesto.common.api.utils.CollectionUtils;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.CompilationManager;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPIUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)SPIUtils.class.getName());
    private static final ServiceLoader<CompilationManager> compilationManagerLoader = ServiceLoader.load(CompilationManager.class);
    private static final ServiceLoader<KieCompilerService> kieCompilerServiceLoader = ServiceLoader.load(KieCompilerService.class);

    private SPIUtils() {
    }

    public static Optional<KieCompilerService> getKieCompilerService(EfestoResource resource, boolean refresh) {
        logger.debug("getKieCompilerService {} {}", (Object)resource, (Object)refresh);
        return CollectionUtils.findAtMostOne(SPIUtils.getServices(refresh), service -> service.canManageResource(resource), (s1, s2) -> new KieCompilerServiceException("Found more than one compiler services: " + s1 + " and " + s2));
    }

    public static Optional<KieCompilerService> getKieCompilerServiceFromEfestoCompilationContext(EfestoResource resource, EfestoCompilationContext context) {
        logger.debug("getKieCompilerServiceFromEfestoCompilationContext {} {}", (Object)resource, (Object)context);
        ServiceLoader<KieCompilerService> contextServiceLoader = context.getKieCompilerServiceLoader();
        return CollectionUtils.findAtMostOne(contextServiceLoader, service -> service.canManageResource(resource), (s1, s2) -> new KieCompilerServiceException("Found more than one compiler services: " + s1 + " and " + s2));
    }

    public static List<KieCompilerService> getKieCompilerServices(boolean refresh) {
        logger.debug("getKieCompilerServices {}", (Object)refresh);
        ArrayList<KieCompilerService> toReturn = new ArrayList<KieCompilerService>();
        Iterable<KieCompilerService> services = SPIUtils.getServices(refresh);
        services.forEach(toReturn::add);
        logger.debug("toReturn {} {}", toReturn, (Object)toReturn.size());
        if (logger.isTraceEnabled()) {
            toReturn.forEach(provider -> logger.trace("{}", provider));
        }
        return toReturn;
    }

    public static Optional<CompilationManager> getCompilationManager(boolean refresh) {
        logger.debug("getCompilationManager {}", (Object)refresh);
        Iterable<CompilationManager> managers = SPIUtils.getManagers(refresh);
        return managers.iterator().hasNext() ? Optional.of(managers.iterator().next()) : Optional.empty();
    }

    private static Iterable<KieCompilerService> getServices(boolean refresh) {
        if (refresh) {
            kieCompilerServiceLoader.reload();
        }
        return kieCompilerServiceLoader;
    }

    private static Iterable<CompilationManager> getManagers(boolean refresh) {
        if (refresh) {
            compilationManagerLoader.reload();
        }
        return compilationManagerLoader;
    }

    public static Set<String> collectModelTypes(EfestoCompilationContext context) {
        Iterable<KieCompilerService> kieCompilerServices = SPIUtils.getServices(false);
        HashSet<String> modelTypes = new HashSet<String>();
        kieCompilerServices.forEach(kieCompilerService -> modelTypes.add(kieCompilerService.getModelType()));
        ServiceLoader<KieCompilerService> serviceLoader = context.getKieCompilerServiceLoader();
        for (KieCompilerService kieCompilerService2 : serviceLoader) {
            modelTypes.add(kieCompilerService2.getModelType());
        }
        return modelTypes;
    }
}

