/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;

public class ModelLocalUriIdSerializer
extends StdSerializer<ModelLocalUriId> {
    private static final long serialVersionUID = 5014755163979962781L;

    public ModelLocalUriIdSerializer() {
        this(null);
    }

    public ModelLocalUriIdSerializer(Class<ModelLocalUriId> t) {
        super(t);
    }

    public void serialize(ModelLocalUriId value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("model", value.model());
        gen.writeStringField("basePath", ModelLocalUriIdSerializer.decodedPath(value.basePath()));
        gen.writeStringField("fullPath", ModelLocalUriIdSerializer.decodedPath(value.fullPath()));
        gen.writeEndObject();
    }

    static String decodedPath(String toDecode) {
        StringTokenizer tok = new StringTokenizer(toDecode, "/");
        StringBuilder builder = new StringBuilder();
        while (tok.hasMoreTokens()) {
            builder.append("/");
            builder.append(ModelLocalUriIdSerializer.decodeString(tok.nextToken()));
        }
        return builder.toString();
    }

    static String decodeString(String toDecode) {
        return URLDecoder.decode(toDecode, StandardCharsets.UTF_8);
    }
}

