/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.common.api.model.GeneratedResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger((String)JSONUtils.class.getName());

    private JSONUtils() {
    }

    public static String getGeneratedResourceString(GeneratedResource generatedResource) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)generatedResource);
    }

    public static GeneratedResource getGeneratedResourceObject(String generatedResourceString) throws JsonProcessingException {
        return (GeneratedResource)objectMapper.readValue(generatedResourceString, GeneratedResource.class);
    }

    public static String getGeneratedResourcesString(GeneratedResources generatedResources) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)generatedResources);
    }

    public static GeneratedResources getGeneratedResourcesObject(String generatedResourcesString) throws JsonProcessingException {
        return (GeneratedResources)objectMapper.readValue(generatedResourcesString, GeneratedResources.class);
    }

    public static GeneratedResources getGeneratedResourcesObject(IndexFile indexFile) throws Exception {
        logger.debug("getGeneratedResourcesObject {}", (Object)indexFile);
        logger.debug("indexFile.length() {}", (Object)indexFile.length());
        return indexFile.length() == 0L ? new GeneratedResources() : (GeneratedResources)objectMapper.readValue(indexFile.getContent(), GeneratedResources.class);
    }

    public static void writeGeneratedResourcesObject(GeneratedResources toWrite, IndexFile indexFile) throws IOException {
        objectMapper.writeValue((File)indexFile, (Object)toWrite);
    }

    public static String getFRIString(FRI fri) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)fri);
    }

    public static FRI getFRIObject(String friString) throws JsonProcessingException {
        return (FRI)objectMapper.readValue(friString, FRI.class);
    }
}

