/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.utils.ResourceHelper;

public class FileUtils {
    private FileUtils() {
    }

    public static File getFile(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        File toReturn = ResourceHelper.getResourcesByExtension(extension).filter(file -> file.getName().equals(fileName)).findFirst().orElse(null);
        if (toReturn == null) {
            throw new KieEfestoCommonException(String.format("Failed to find %s due to", fileName));
        }
        return toReturn;
    }

    public static FileInputStream getFileInputStream(String fileName) throws IOException {
        File sourceFile = FileUtils.getFile(fileName);
        return new FileInputStream(sourceFile);
    }

    public static String getFileContent(String fileName) throws IOException {
        File file = FileUtils.getFile(fileName);
        Path path = file.toPath();
        Stream<String> lines = Files.lines(path);
        String toReturn = lines.collect(Collectors.joining("\n"));
        lines.close();
        return toReturn;
    }

    public static InputStream getInputStreamFromFileName(String fileName) {
        try {
            InputStream toReturn = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            if (toReturn == null) {
                throw new KieEfestoCommonException(String.format("Failed to find %s", fileName));
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new KieEfestoCommonException(String.format("Failed to find %s due to %s", fileName, e.getMessage()), e);
        }
    }

    public static Optional<File> getFileFromFileName(String fileName) {
        return FileUtils.getFileFromFileName(fileName, Thread.currentThread().getContextClassLoader());
    }

    public static Optional<File> getFileFromFileName(String fileName, ClassLoader classLoader) {
        URL retrieved = classLoader.getResource(fileName);
        if (retrieved != null) {
            return Optional.of(new File(retrieved.getFile()));
        }
        File file = new File(fileName);
        return file.exists() ? Optional.of(file) : Optional.empty();
    }
}

