/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.io;

import java.io.File;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.utils.FileNameUtils;

public final class IndexFile
extends File {
    public static final String INDEX_FILE = "IndexFile";
    public static final String FINAL_SUFFIX = "_json";

    static String getIndexFileName(String modelType) {
        return String.format("%s.%s%s", INDEX_FILE, modelType, FINAL_SUFFIX);
    }

    static String validatePathName(String toValidate) {
        String fileName = FileNameUtils.getFileName(toValidate);
        if (!fileName.endsWith(FINAL_SUFFIX)) {
            throw new KieEfestoCommonException("Wrong file name " + fileName);
        }
        String model = IndexFile.getModel(fileName);
        if (model.isEmpty()) {
            throw new KieEfestoCommonException("Wrong file name " + fileName);
        }
        return toValidate;
    }

    static String getModel(String fileName) {
        return FileNameUtils.getSuffix(fileName).replace(FINAL_SUFFIX, "");
    }

    public IndexFile(String modelType) {
        super(IndexFile.validatePathName(IndexFile.getIndexFileName(modelType)));
    }

    public IndexFile(String parent, String modelType) {
        super(parent, IndexFile.validatePathName(IndexFile.getIndexFileName(modelType)));
    }

    public IndexFile(File existingFile) {
        super(existingFile.toURI());
    }

    public String getModel() {
        return IndexFile.getModel(this.getSuffix());
    }

    private String getSuffix() {
        return FileNameUtils.getSuffix(this.getName());
    }
}

