/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.themeverifier;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.keycloak.themeverifier.MessagePropertiesFilter;
import org.keycloak.themeverifier.VerifyMessageProperties;

@Mojo(name="verify-theme", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true)
public class ThemeVerifierMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="false")
    private boolean validateMessageFormatQuotes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Iterator resources = this.mavenProject.getResources().iterator();
        ArrayList<String> messages = new ArrayList<String>();
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            File dir = new File(resource.getDirectory());
            Iterator fileIterator = FileUtils.iterateFiles((File)dir, (IOFileFilter)MessagePropertiesFilter.INSTANCE, (IOFileFilter)DirectoryFileFilter.INSTANCE);
            while (fileIterator.hasNext()) {
                File file = (File)fileIterator.next();
                messages.addAll(new VerifyMessageProperties(file).withValidateMessageFormatQuotes(this.validateMessageFormatQuotes).verify());
            }
        }
        if (!messages.isEmpty()) {
            throw new MojoFailureException("Validation errors: " + messages.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }
}

