/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.themeverifier;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class VerifyMessageProperties {
    private final File file;
    private List<String> messages;
    private boolean validateMessageFormatQuotes;
    private static final Pattern DOUBLE_SINGLE_QUOTES = Pattern.compile("''");
    private static final Pattern SINGLE_QUOTE_MIDDLE = Pattern.compile("[^']'[^']");
    private static final Pattern SINGLE_QUOTE_END = Pattern.compile("[^']'$");
    private static final Pattern SINGLE_QUOTE_START = Pattern.compile("^'[^']");
    private static final Pattern DOUBLE_CURLY_BRACES_START = Pattern.compile("\\{\\{[0-9]");
    private static final Pattern DOUBLE_CURLY_BRACES_END = Pattern.compile("[0-9]}}");
    private static final Pattern SINGLE_CURLY_BRACE_MIDDLE = Pattern.compile("[^{]\\{[0-9]");
    private static final Pattern SINGLE_CURLY_BRACE_END = Pattern.compile("[0-9]}$");
    private static final Pattern SINGLE_CURLY_BRACE_START = Pattern.compile("^\\{[0-9]");
    private static final Pattern UNBALANCED_ONE = Pattern.compile("\\{\\{[^{}]*}[^}]");
    private static final Pattern UNBALANCED_ONE_END = Pattern.compile("\\{\\{[^{}]*}$");
    private static final Pattern UNBALANCED_TWO = Pattern.compile("[^{]\\{[^{}]*}}");
    private static final Pattern UNBALANCED_TWO_START = Pattern.compile("^\\{[^{}]*}}");
    PolicyFactory POLICY_SOME_HTML = new HtmlPolicyBuilder().allowElements(new String[]{"br", "p", "strong", "b"}).toFactory();
    PolicyFactory POLICY_NO_HTML = new HtmlPolicyBuilder().toFactory();
    Pattern HTML_TAGS = Pattern.compile("<[a-z]+[^>]*>");
    private static final Pattern ANCHOR_PATTERN = Pattern.compile("</?a[^>]*>");

    public VerifyMessageProperties(File file) {
        this.file = file;
    }

    public List<String> verify() throws MojoExecutionException {
        this.messages = new ArrayList<String>();
        try {
            String contents = Files.readString(this.file.toPath());
            this.verifyNoDuplicateKeys(contents);
            this.verifySafeHtml();
            this.verifyProblematicBlanks();
            if (this.validateMessageFormatQuotes) {
                this.verifyMessageFormatQuotes();
                this.verifyMessageFormatPlaceholders();
            } else {
                this.verifyNotMessageFormatQuotes();
                this.verifyNotMessageFormatPlaceholders();
            }
            this.verifyUnbalancedCurlyBraces();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can not read file " + String.valueOf(this.file), (Exception)e);
        }
        return this.messages;
    }

    private void verifyNotMessageFormatQuotes() {
        PropertyResourceBundle bundle = this.getPropertyResourceBundle();
        bundle.getKeys().asIterator().forEachRemaining(key -> {
            String value = bundle.getString((String)key);
            if (DOUBLE_SINGLE_QUOTES.matcher(value).find()) {
                this.messages.add("Double single quotes are not allowed in message formats as they might be shown in frontends as-is in '" + key + "' for file " + String.valueOf(this.file) + ": " + value);
            }
        });
    }

    private void verifyMessageFormatQuotes() {
        PropertyResourceBundle bundle = this.getPropertyResourceBundle();
        bundle.getKeys().asIterator().forEachRemaining(key -> {
            String value = bundle.getString((String)key);
            if (SINGLE_QUOTE_START.matcher(value).find() || SINGLE_QUOTE_MIDDLE.matcher(value).find() || SINGLE_QUOTE_END.matcher(value).find()) {
                this.messages.add("Single quotes are not allowed in message formats due to unexpected behaviors in '" + key + "' for file " + String.valueOf(this.file) + ": " + value);
            }
        });
    }

    private void verifyMessageFormatPlaceholders() {
        PropertyResourceBundle bundle = this.getPropertyResourceBundle();
        bundle.getKeys().asIterator().forEachRemaining(key -> {
            String value = bundle.getString((String)key);
            if (DOUBLE_CURLY_BRACES_START.matcher(value).find() || DOUBLE_CURLY_BRACES_END.matcher(value).find()) {
                this.messages.add("Double curly braces are not allowed in message formats in the backend for in '" + key + "' for file " + String.valueOf(this.file) + ": " + value);
            }
        });
    }

    private void verifyNotMessageFormatPlaceholders() {
        PropertyResourceBundle bundle = this.getPropertyResourceBundle();
        bundle.getKeys().asIterator().forEachRemaining(key -> {
            String value = bundle.getString((String)key);
            if (SINGLE_CURLY_BRACE_START.matcher(value).find() || SINGLE_CURLY_BRACE_MIDDLE.matcher(value).find() || SINGLE_CURLY_BRACE_END.matcher(value).find()) {
                this.messages.add("Single curly quotes are not supported as placeholders for the frontend in '" + key + "' for file " + String.valueOf(this.file) + ": " + value);
            }
        });
    }

    private void verifyUnbalancedCurlyBraces() {
        PropertyResourceBundle bundle = this.getPropertyResourceBundle();
        bundle.getKeys().asIterator().forEachRemaining(key -> {
            String value = bundle.getString((String)key);
            if (UNBALANCED_ONE.matcher(value).find() || UNBALANCED_ONE_END.matcher(value).find() || UNBALANCED_TWO.matcher(value).find() || UNBALANCED_TWO_START.matcher(value).find()) {
                this.messages.add("Unbalanced curly braces in key '" + key + "' for file " + String.valueOf(this.file) + ": " + value);
            }
        });
    }

    private PropertyResourceBundle getPropertyResourceBundle() {
        PropertyResourceBundle bundle;
        try (FileInputStream fis = new FileInputStream(this.file);){
            bundle = new PropertyResourceBundle(fis);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to read file " + String.valueOf(this.file), e);
        }
        return bundle;
    }

    private void verifySafeHtml() {
        PropertyResourceBundle bundleEnglish;
        PropertyResourceBundle bundle = this.getPropertyResourceBundle();
        String englishFile = this.file.getAbsolutePath().replaceAll("resources-community", "resources").replaceAll("_[a-zA-Z-_]*\\.properties", "_en.properties");
        try (FileInputStream fis = new FileInputStream(englishFile);){
            bundleEnglish = new PropertyResourceBundle(fis);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to read file " + englishFile, e);
        }
        bundle.getKeys().asIterator().forEachRemaining(key -> {
            String value = bundle.getString((String)key);
            value = this.normalizeValue((String)key, value);
            String englishValue = VerifyMessageProperties.getEnglishValue(key, bundleEnglish);
            englishValue = this.normalizeValue((String)key, englishValue);
            value = this.santizeAnchors((String)key, value, englishValue);
            PolicyFactory policy = this.containsHtml(englishValue) ? this.POLICY_SOME_HTML : this.POLICY_NO_HTML;
            String sanitized = policy.sanitize(value);
            sanitized = StringEscapeUtils.unescapeHtml4((String)sanitized);
            if (!Objects.equals(sanitized = sanitized.replace("<!-- -->", ""), value)) {
                int end;
                int start;
                for (start = 0; start < sanitized.length() && start < value.length() && value.charAt(start) == sanitized.charAt(start); ++start) {
                }
                for (end = 0; end < sanitized.length() - start && end < value.length() - start && value.charAt(value.length() - end - 1) == sanitized.charAt(sanitized.length() - end - 1); ++end) {
                }
                this.messages.add("Illegal HTML in key " + key + " for file " + String.valueOf(this.file) + ": '" + value.substring(start, value.length() - end) + "' vs. '" + sanitized.substring(start, sanitized.length() - end) + "'");
            }
        });
    }

    private void verifyProblematicBlanks() {
        if (!this.file.getName().endsWith("_en.properties")) {
            return;
        }
        PropertyResourceBundle bundle = this.getPropertyResourceBundle();
        bundle.getKeys().asIterator().forEachRemaining(key -> {
            String value = bundle.getString((String)key);
            if (value.contains("  ")) {
                this.messages.add("Duplicate blanks in '" + key + "' for file " + String.valueOf(this.file) + ": '" + value);
            }
            if (value.startsWith(" ")) {
                this.messages.add(key + " starts with a blank in file " + String.valueOf(this.file) + ": '" + value);
            }
            if (value.endsWith(" ")) {
                this.messages.add(key + " ends with a blank in file " + String.valueOf(this.file) + ": '" + value);
            }
        });
    }

    private String normalizeValue(String key, String value) {
        if (key.equals("templateHelp")) {
            value = value.replaceAll("CLAIM\\.<[A-Z]*>", "");
        } else if (key.equals("optimizeLookupHelp")) {
            value = value.replaceAll("<Extensions>", "");
        } else if (key.startsWith("linkExpirationFormatter.timePeriodUnit") || key.equals("error-invalid-multivalued-size")) {
            value = value.replaceAll("\\{[0-9]+,choice,[^}]*}", "...");
        }
        value = StringEscapeUtils.unescapeHtml4((String)value);
        return value;
    }

    private boolean containsHtml(String englishValue) {
        return this.HTML_TAGS.matcher(englishValue).find();
    }

    private String santizeAnchors(String key, String value, String englishValue) {
        Matcher matcher = ANCHOR_PATTERN.matcher(value);
        Matcher englishMatcher = ANCHOR_PATTERN.matcher(englishValue);
        while (matcher.find()) {
            if (englishMatcher.find() && Objects.equals(matcher.group(), englishMatcher.group())) {
                value = value.replaceFirst(Pattern.quote(englishMatcher.group()), "");
                continue;
            }
            this.messages.add("Didn't find anchor tag " + matcher.group() + " in original string");
            break;
        }
        return value;
    }

    private static String getEnglishValue(String key, PropertyResourceBundle bundleEnglish) {
        String englishValue;
        try {
            englishValue = bundleEnglish.getString(key);
        }
        catch (MissingResourceException ex) {
            englishValue = "";
        }
        return englishValue;
    }

    private void verifyNoDuplicateKeys(String contents) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(contents));
        HashSet<String> seenKeys = new HashSet<String>();
        HashSet<String> duplicateKeys = new HashSet<String>();
        while ((line = bufferedReader.readLine()) != null) {
            int split;
            if (line.startsWith("#") || line.isEmpty() || (split = line.indexOf("=")) == -1) continue;
            String key = line.substring(0, split).trim();
            if (seenKeys.contains(key)) {
                duplicateKeys.add(key);
                continue;
            }
            seenKeys.add(key);
        }
        if (!duplicateKeys.isEmpty()) {
            this.messages.add("Duplicate keys in file '" + this.file.getAbsolutePath() + "': " + String.valueOf(duplicateKeys));
        }
    }

    public VerifyMessageProperties withValidateMessageFormatQuotes(boolean validateMessageFormatQuotes) {
        this.validateMessageFormatQuotes = validateMessageFormatQuotes;
        return this;
    }
}

